/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.api.importing;

public final class ReqNumbering
implements Comparable<ReqNumbering> {
    private static final int ZERO_BASED_NUMBERING = 0;
    private static final int ONE_BASED_NUMBERING = 1;
    private final boolean removeEndingZero;
    private final String numberStr;
    private final String[] values;

    public ReqNumbering(String number) {
        this(number, true);
    }

    public ReqNumbering(String number, boolean removeEndingZero) {
        this.numberStr = number.replace("-", ".");
        this.removeEndingZero = removeEndingZero;
        this.values = this.tokenize(removeEndingZero);
    }

    public String getNumberString() {
        return this.numberStr;
    }

    public String getParentString() {
        int finalIndex = this.values.length - 1;
        int lastZero = this.findIndexOfLastZero();
        if (lastZero > 0 && lastZero < finalIndex) {
            finalIndex = lastZero;
        }
        return this.unTokenize(this.values, finalIndex);
    }

    private int findIndexOfLastZero() {
        int i = this.values.length - 1;
        while (i >= 0) {
            if (this.values[i].equals("0")) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int getLength() {
        return this.values.length;
    }

    public String getReqNumberByLevel(int level) {
        return this.unTokenize(this.values, level);
    }

    private String unTokenize(String[] input, int index) {
        if (index > input.length) {
            index = input.length;
        }
        StringBuilder toReturn = new StringBuilder();
        int i = 0;
        while (i < index) {
            if (toReturn.length() > 0) {
                toReturn.append(".");
            }
            toReturn.append(input[i]);
            ++i;
        }
        return toReturn.toString();
    }

    public boolean isChild(ReqNumbering numbering) {
        String[] numberVals = numbering.values;
        int delta = numberVals.length - this.values.length;
        switch (delta % 2) {
            case 0: {
                if (delta > 0) break;
                return false;
            }
            case 1: {
                break;
            }
            default: {
                return false;
            }
        }
        int i = 0;
        while (i < Math.min(this.values.length, numberVals.length)) {
            if (!this.values[i].equals(numberVals[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String[] tokenize() {
        return this.tokenize(this.removeEndingZero);
    }

    public String[] tokenize(boolean chopOffZero) {
        String[] returnVal = this.numberStr.split("\\.");
        if (chopOffZero && returnVal[returnVal.length - 1].equals("0")) {
            String[] temp = new String[returnVal.length - 1];
            System.arraycopy(returnVal, 0, temp, 0, temp.length);
            returnVal = temp;
        }
        return returnVal;
    }

    @Override
    public int compareTo(ReqNumbering o) {
        int i = 0;
        while (i < Math.max(this.values.length, o.values.length)) {
            int oValue;
            int thisValue = this.getValue(i);
            if (thisValue > (oValue = o.getValue(i))) {
                return 1;
            }
            if (thisValue < oValue) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ReqNumbering)) {
            return false;
        }
        return this.compareTo((ReqNumbering)o) == 0;
    }

    public int hashCode() {
        return this.numberStr.hashCode();
    }

    private int getValue(int index) {
        if (index <= this.values.length - 1) {
            return Integer.parseInt(this.values[index]);
        }
        return 0;
    }

    public String toString() {
        return this.numberStr;
    }
}

