/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.users;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public abstract class CreateUserByUserIdOperation {
    protected final AtsApi atsApi;
    protected final OrcsApi orcsApi;
    protected String userIds;

    public CreateUserByUserIdOperation(String userIds, AtsApi atsApi, OrcsApi orcsApi) {
        this.userIds = userIds;
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public abstract String getUserQuery(String var1);

    public abstract String getCommitComment();

    public XResultData run() {
        XResultData rd = new XResultData();
        int count = 0;
        this.userIds = this.userIds.replaceAll(" ", "");
        HashSet<String> bemsIds = new HashSet<String>(Arrays.asList(this.userIds.split(",")));
        ArrayList<UserToken> userTokens = new ArrayList<UserToken>();
        ArrayList<AtsUser> inactiveUsers = new ArrayList<AtsUser>();
        this.atsApi.getConfigService().getConfigurationsWithPend();
        for (String userId : bemsIds) {
            if (Strings.isNumeric((String)userId)) {
                AtsUser userById;
                Long id = (Long)this.atsApi.getConfigService().getConfigurations().getUserIdToUserArtId().get(userId);
                if (id != null && (userById = (AtsUser)this.atsApi.getConfigService().getConfigurations().getIdToUser().get(id)) != null && userById.isValid()) {
                    rd.logf("User with UserId [%s] already exists %s\n", new Object[]{userId, userById.toStringWithId()});
                    boolean active = userById.isActive();
                    if (active) continue;
                    rd.logf("User %s not active and will be set as active\n", new Object[]{userById.toStringWithId()});
                    inactiveUsers.add(userById);
                    continue;
                }
                try (JdbcStatement chStmt = this.atsApi.getJdbcService().getClient().getStatement();){
                    String query = this.getUserQuery(userId);
                    chStmt.runPreparedQuery(query, new Object[0]);
                    while (chStmt.next()) {
                        String json = chStmt.getString(1);
                        ObjectMapper mapper = new ObjectMapper();
                        String loginId = "";
                        String email = "";
                        String userName = "";
                        try {
                            Map map = (Map)mapper.readValue(json, Map.class);
                            loginId = (String)map.get("login_id");
                            email = (String)map.get("mail");
                            userName = (String)map.get("user_name");
                        }
                        catch (IOException iOException) {
                            rd.errorf("Problem occurred with mapping the user %s", new Object[]{userId});
                        }
                        if (Strings.isInValid((String)loginId)) {
                            rd.errorf("Login Id can't be empty for %s, skipping\n", new Object[]{userId});
                            continue;
                        }
                        ArrayList<IUserGroupArtifactToken> roles = new ArrayList<IUserGroupArtifactToken>();
                        roles.add(CoreUserGroups.Everyone);
                        UserToken userTok = UserToken.create((Long)Id.SENTINEL, (String)userName, (String)email, (String)userId, (boolean)true, Arrays.asList(loginId), roles);
                        ++count;
                        userTokens.add(userTok);
                        rd.getIds().add(userTok.getIdString());
                    }
                    continue;
                }
            }
            rd.errorf("Error in UserId [%s]\n", new Object[]{userId});
        }
        if (!userTokens.isEmpty()) {
            this.orcsApi.userService().createUsers(userTokens, this.getCommitComment());
            rd.logf("Created %s Users\n", new Object[]{count});
        } else {
            rd.errorf("No users created.  Check that UserId(s) are valid: [%s]", new Object[]{this.userIds});
        }
        if (!inactiveUsers.isEmpty()) {
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, "Re-activate users from UserIds(s)");
            for (ArtifactId artifactId : inactiveUsers) {
                tx.setSoleAttributeValue(artifactId, (AttributeTypeToken)CoreAttributeTypes.Active, (Object)true);
            }
            tx.commit();
        }
        return rd;
    }
}

