/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.demo;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.core.workflow.transition.TeamWorkFlowManager;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;

public abstract class AbstractPopulateDemoDatabase {
    boolean debug = false;
    boolean isSuccessful = true;
    protected final XResultData rd;
    protected final AtsApi atsApi;

    public AbstractPopulateDemoDatabase(XResultData rd, AtsApi atsApi) {
        this.rd = rd;
        this.atsApi = atsApi;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public abstract void run();

    public void setValidationRequired(IAtsChangeSet changes, IAtsTeamWorkflow teamWf) {
        changes.setSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeToken)AtsAttributeTypes.ValidationRequired, (Object)true);
    }

    public TeamWorkFlowManager getTransitionMgr(IAtsTeamWorkflow teamWf) {
        return new TeamWorkFlowManager(teamWf, this.atsApi, new TransitionOption[]{TransitionOption.OverrideAssigneeCheck, TransitionOption.OverrideTransitionValidityCheck, TransitionOption.OverrideWorkingBranchCheck});
    }

    public Pair<IAtsTeamWorkflow, Result> transitionToWithPersist(IAtsTeamWorkflow teamWf, TeamState toState, AtsUser currentStateUser, Collection<AtsUser> transitionToAssignees, AtsApi atsApi) {
        while (teamWf.getCurrentState().isNotState((IStateToken)toState)) {
            IAtsChangeSet changes;
            TeamWorkFlowManager mgr = this.getTransitionMgr(teamWf);
            Result result = mgr.transitionTo(toState, currentStateUser, transitionToAssignees, false, changes = atsApi.createChangeSet("Transition to " + toState.getName()));
            if (result.isFalse()) {
                return new Pair((Object)teamWf, (Object)result);
            }
            TransactionToken tx = changes.executeIfNeeded();
            if (tx.isInvalid()) break;
            teamWf = atsApi.getQueryService().getTeamWf(teamWf.getId());
        }
        return new Pair((Object)teamWf, (Object)Result.TrueResult);
    }

    public IAtsTeamWorkflow setVersionAndReload(IAtsTeamWorkflow teamWf, ArtifactToken versionToken) {
        IAtsChangeSet changes = this.atsApi.createChangeSet("Set Version");
        Version version = this.atsApi.getVersionService().getVersionById((ArtifactId)versionToken);
        this.atsApi.getVersionService().setTargetedVersion(teamWf, (IAtsVersion)version, changes);
        changes.execute();
        return this.atsApi.getQueryService().getTeamWf(teamWf.getId());
    }

    public void transitionTo(IAtsTeamWorkflow teamWf, TeamState state, IAtsChangeSet changes) {
        TeamWorkFlowManager dtwm = new TeamWorkFlowManager(teamWf, this.atsApi, new TransitionOption[]{TransitionOption.OverrideAssigneeCheck, TransitionOption.OverrideTransitionValidityCheck});
        Result result = dtwm.transitionTo(state, (AtsUser)teamWf.getAssignees().iterator().next(), false, changes);
        if (result.isFalse()) {
            throw new OseeCoreException("Error transitioning [%s] to state [%s]: [%s]", new Object[]{teamWf.toStringWithId(), state, result.getText()});
        }
        if (!teamWf.isCompletedOrCancelled()) {
            changes.setAssignees((IAtsWorkItem)teamWf, this.atsApi.getTeamDefinitionService().getLeads(teamWf.getTeamDefinition()));
        }
    }

    public IAtsTeamWorkflow reload(IAtsTeamWorkflow teamWf) {
        teamWf = (IAtsTeamWorkflow)this.atsApi.getQueryService().getWorkItem(teamWf.getArtifactId());
        return teamWf;
    }

    public IAtsTeamWorkflow transitionAndReload(IAtsTeamWorkflow teamWf, TeamState toState) {
        IAtsChangeSet changes = this.atsApi.createChangeSet("Transition Workflows");
        TeamWorkFlowManager dtwm = new TeamWorkFlowManager(teamWf, this.atsApi, new TransitionOption[]{TransitionOption.OverrideAssigneeCheck, TransitionOption.OverrideTransitionValidityCheck});
        Result result = dtwm.transitionTo(toState, (AtsUser)teamWf.getAssignees().iterator().next(), false, changes);
        if (result.isFalse()) {
            throw new OseeCoreException("Error transitioning [%s] to state [%s]: [%s]", new Object[]{teamWf.toStringWithId(), toState.getName(), result.getText()});
        }
        changes.execute();
        ArtifactToken art = this.atsApi.getQueryService().getArtifact(teamWf.getId());
        return this.atsApi.getWorkItemService().getTeamWf(art);
    }
}

