/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osee.define.rest.internal.SafetyCriticalityLookup;
import org.eclipse.osee.define.rest.internal.ValidatingSafetyReportGenerator;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.orcs.search.QueryFactory;

public final class ValidatingSafetyInformationAccumulator {
    private final ISheetWriter writer;
    private final ValidatingSafetyReportGenerator safetyReport;
    private String functionalCategory;
    private List<ArtifactReadable> subsystemFunctions;
    private List<ArtifactId> allowedRequirements;
    private final HashMap<ArtifactReadable, List<ArtifactReadable>> subsystemRequirements = Maps.newHashMap();
    private final HashMap<ArtifactReadable, List<ArtifactReadable>> softwareRequirements = Maps.newHashMap();

    public ValidatingSafetyInformationAccumulator(ValidatingSafetyReportGenerator providedSafetyReport, ISheetWriter providedWriter) {
        this.safetyReport = providedSafetyReport;
        this.writer = providedWriter;
    }

    public void setupPartitions(QueryFactory qf, BranchId branch, ArtifactId view) {
        this.allowedRequirements = qf.fromBranch(branch, view).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.SoftwareRequirementMsWord}).asArtifactIds();
    }

    public String calculateLevelForPartition(List<String> partitions) {
        return this.safetyReport.getPartitionLevel(partitions);
    }

    public void reset(ArtifactReadable systemFunction) {
        this.functionalCategory = systemFunction.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.FunctionalCategory, "");
        this.subsystemRequirements.clear();
        this.softwareRequirements.clear();
    }

    public void buildSubsystemsRequirementsMap(ArtifactReadable systemFunction) {
        this.subsystemFunctions = Lists.newArrayList((Iterable)systemFunction.getRelated(CoreRelationTypes.Dependency_Dependency));
        Iterator<ArtifactReadable> sfIter = this.subsystemFunctions.iterator();
        while (sfIter.hasNext()) {
            ArtifactReadable subsystemFunction = sfIter.next();
            List<ArtifactReadable> localSubsystemRequirements = this.checkSubsystemRequirements(subsystemFunction);
            if (localSubsystemRequirements.isEmpty()) {
                sfIter.remove();
                continue;
            }
            this.subsystemRequirements.put(subsystemFunction, localSubsystemRequirements);
        }
    }

    private List<ArtifactReadable> checkSubsystemRequirements(ArtifactReadable subsystemFunction) {
        ArrayList localSubsystemRequirements = Lists.newArrayList((Iterable)subsystemFunction.getRelated(CoreRelationTypes.Design_Requirement));
        Iterator ssrIter = localSubsystemRequirements.iterator();
        while (ssrIter.hasNext()) {
            ArtifactReadable subsystemRequirement = (ArtifactReadable)ssrIter.next();
            ArrayList unfilteredSoftwareRequirements = Lists.newArrayList((Iterable)subsystemRequirement.getRelated(CoreRelationTypes.RequirementTrace_LowerLevelRequirement));
            ArrayList<ArtifactReadable> localSoftwareRequirements = new ArrayList<ArtifactReadable>();
            for (ArtifactReadable art : unfilteredSoftwareRequirements) {
                if (!this.allowedRequirements.contains(art)) continue;
                localSoftwareRequirements.add(art);
            }
            if (localSoftwareRequirements.isEmpty()) {
                ssrIter.remove();
                continue;
            }
            this.softwareRequirements.put(subsystemRequirement, localSoftwareRequirements);
        }
        return localSubsystemRequirements;
    }

    public void output(String[] currentRowValues) throws IOException {
        for (ArtifactReadable subsystemFunction : this.subsystemFunctions) {
            this.processSubsystemFunction(subsystemFunction, currentRowValues);
        }
    }

    private String convertSafetyCriticalityToDAL(String inputSafetyCriticality) {
        if (inputSafetyCriticality.length() > 4) {
            return "Error";
        }
        return SafetyCriticalityLookup.getDALLevelFromSeverityCategory(inputSafetyCriticality);
    }

    private void processSubsystemFunction(ArtifactReadable subsystemFunction, String[] currentRowValues) throws IOException {
        this.writeCell(subsystemFunction.getName(), currentRowValues, ValidatingSafetyReportGenerator.SUBSYSTEM_FUNCTION_INDEX);
        String sevCat = subsystemFunction.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.SeverityCategory, "Error: not available");
        this.writeCell(sevCat, currentRowValues, ValidatingSafetyReportGenerator.SUBSYSTEM_FUNCTION_INDEX + 1);
        this.writeCell(subsystemFunction.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.FDAL, ""), currentRowValues, ValidatingSafetyReportGenerator.SUBSYSTEM_FUNCTION_INDEX + 2);
        this.writeCell(subsystemFunction.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.FdalRationale, ""), currentRowValues, ValidatingSafetyReportGenerator.SUBSYSTEM_FUNCTION_INDEX + 3);
        for (ArtifactReadable subsystemRequirement : this.subsystemRequirements.get(subsystemFunction)) {
            this.processSubsystemRequirement(subsystemRequirement, this.convertSafetyCriticalityToDAL(sevCat), currentRowValues);
        }
        if (this.safetyReport.saveToPreviousAndCheckIfDifferent(currentRowValues)) {
            this.writer.writeRow((Object[])currentRowValues);
        }
    }

    private void writeCell(String value, String[] currentRow, int col) {
        currentRow[col] = value;
    }

    private void processSubsystemRequirement(ArtifactReadable subsystemRequirement, String criticality, String[] currentRowValues) throws IOException {
        this.writeCell(subsystemRequirement.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Subsystem, ""), currentRowValues, ValidatingSafetyReportGenerator.SUBSYSTEM_INDEX);
        this.writeCell((String)subsystemRequirement.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, (Object)""), currentRowValues, ValidatingSafetyReportGenerator.SUBSYSTEM_INDEX + 1);
        this.writeCell(subsystemRequirement.getName(), currentRowValues, ValidatingSafetyReportGenerator.SUBSYSTEM_INDEX + 2);
        this.writeCell(subsystemRequirement.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.IDAL, ""), currentRowValues, ValidatingSafetyReportGenerator.SUBSYSTEM_INDEX + 3);
        this.writeCell(subsystemRequirement.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.IdalRationale, ""), currentRowValues, ValidatingSafetyReportGenerator.SUBSYSTEM_INDEX + 4);
        String currentCriticality = this.writeCriticalityWithDesignCheck(subsystemRequirement, criticality, (AttributeTypeToken)CoreAttributeTypes.IDAL, CoreRelationTypes.Design_Design, (AttributeTypeToken)CoreAttributeTypes.SeverityCategory, currentRowValues, ValidatingSafetyReportGenerator.SUBSYSTEM_INDEX + 5);
        for (ArtifactReadable softwareRequirement : this.softwareRequirements.get(subsystemRequirement)) {
            this.processSoftwareRequirement(softwareRequirement, currentCriticality, currentRowValues);
        }
    }

    private String writeCriticalityWithDesignCheck(ArtifactReadable art, String criticality, AttributeTypeToken thisType, RelationTypeSide relType, AttributeTypeToken otherType, String[] currentRowValues, int col) {
        String current = art.getSoleAttributeAsString(thisType, "Error");
        if ("Error".equals(criticality) || "Error".equals(current)) {
            this.writeCell("Error: invalid content", currentRowValues, col);
            return "Error";
        }
        if ("Unspecified".equals(current)) {
            this.writeCell("Unspecified", currentRowValues, col);
            return "Unspecified";
        }
        if ("Unspecified".equals(criticality)) {
            criticality = "E";
        }
        this.writeCell(current, currentRowValues, col);
        return current;
    }

    private void checkBackTrace(ArtifactReadable art, Integer current, AttributeTypeId thisType, RelationTypeSide relType, AttributeTypeToken otherType, String[] currentRowValues, int col) {
        ArrayList tracedToRequirements = Lists.newArrayList((Iterable)art.getRelated(relType));
        int maxCritVal = 4;
        int parentCritVal = 4;
        for (ArtifactReadable parent : tracedToRequirements) {
            String intermediate;
            if (otherType.equals(CoreAttributeTypes.SeverityCategory)) {
                intermediate = parent.getSoleAttributeAsString(otherType, "NH");
                if ("Unspecified".equals(intermediate)) {
                    intermediate = "NH";
                }
                parentCritVal = SafetyCriticalityLookup.getSeverityLevel(intermediate);
            } else if (otherType.equals(CoreAttributeTypes.IDAL)) {
                intermediate = parent.getSoleAttributeAsString(otherType, "E");
                if ("Unspecified".equals(intermediate)) {
                    intermediate = "E";
                }
                parentCritVal = SafetyCriticalityLookup.getDALLevel(intermediate);
            } else {
                throw new OseeArgumentException("Invalid attribute type: %s", new Object[]{otherType.toString()});
            }
            maxCritVal = Integer.min(maxCritVal, parentCritVal);
        }
        if (current < maxCritVal) {
            this.writeCell(String.format("%s [Error:<%s]", SafetyCriticalityLookup.getDALLevelFromInt(current), SafetyCriticalityLookup.getDALLevelFromInt(maxCritVal)), currentRowValues, col);
        } else {
            this.writeCell(SafetyCriticalityLookup.getDALLevelFromInt(current), currentRowValues, col);
        }
    }

    private void processSoftwareRequirement(ArtifactReadable softwareRequirement, String sevCat, String[] currentRowValues) throws IOException {
        this.writeCell(softwareRequirement.getName(), currentRowValues, ValidatingSafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX);
        this.writeCell(softwareRequirement.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.IDAL, ""), currentRowValues, ValidatingSafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX + 1);
        this.writeCell(softwareRequirement.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.IdalRationale, ""), currentRowValues, ValidatingSafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX + 2);
        this.writeCell(softwareRequirement.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.SoftwareControlCategory, ""), currentRowValues, ValidatingSafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX + 3);
        this.writeCell(softwareRequirement.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.SoftwareControlCategoryRationale, ""), currentRowValues, ValidatingSafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX + 4);
        List partitions = softwareRequirement.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.Partition);
        this.writeCell(this.calculateLevelForPartition(partitions), currentRowValues, ValidatingSafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX + 5);
        this.writeCell(this.functionalCategory, currentRowValues, ValidatingSafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX + 6);
        this.writeCell(softwareRequirement.getAttributeValuesAsString((AttributeTypeToken)CoreAttributeTypes.Partition), currentRowValues, ValidatingSafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX + 7);
        this.writeCell(this.safetyReport.getComponentUtil().getQualifiedComponentNames(softwareRequirement), currentRowValues, ValidatingSafetyReportGenerator.SOFTWARE_REQUIREMENT_INDEX + 8);
        Collection<String> codeUnits = this.safetyReport.getRequirementToCodeUnitsValues(softwareRequirement);
        if (Conditions.hasValues(codeUnits)) {
            for (String codeUnit : codeUnits) {
                this.writeCell(codeUnit, currentRowValues, ValidatingSafetyReportGenerator.CODE_UNIT_INDEX);
                if (!this.safetyReport.saveToPreviousAndCheckIfDifferent(currentRowValues)) continue;
                this.writer.writeRow((Object[])currentRowValues);
            }
        } else if (this.safetyReport.saveToPreviousAndCheckIfDifferent(currentRowValues)) {
            this.writer.writeRow((Object[])currentRowValues);
        }
    }
}

