/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.define.rest.internal.PartitionLevelsData;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.OrcsApi;

public class PartitionLevels {
    private List<PartitionLevelsData> data = new ArrayList<PartitionLevelsData>();
    ArtifactReadable partitionArt;

    public void init(OrcsApi orcsApi) {
        Conditions.assertNotNull((Object)orcsApi, (String)"given orcsApi cannot be null", (Object[])new Object[0]);
        ArtifactReadable partitionArt = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId(ArtifactId.valueOf((int)11508068)).getArtifact();
        Conditions.assertNotNull((Object)partitionArt, (String)"No PartitionLevel Art Found for Art ID 11508068", (Object[])new Object[0]);
        String jsonData = partitionArt.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Description);
        Conditions.assertNotNullOrEmpty((String)jsonData, (String)"PartitionArt didn't provide the expected json data", (Object[])new Object[0]);
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.data = (List)mapper.readValue(jsonData, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, PartitionLevelsData.class));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new OseeCoreException("mapper couldn't map json string in PartitionArt", new Object[0]);
        }
    }

    public String getLevelForPartition(List<String> partitions) {
        String max = "C";
        boolean found = false;
        for (String partition : partitions) {
            for (PartitionLevelsData item : this.data) {
                if (!item.getPartition().equals(partition)) continue;
                max = this.getMax(item.getLevel(), max);
                found = true;
            }
        }
        if (found) {
            return max;
        }
        return "BP";
    }

    private String getMax(String level, String current) {
        return current.compareTo(level) > 0 ? level : current;
    }
}

