/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.define.rest.api.importing.RoughArtifact;
import org.eclipse.osee.define.rest.api.importing.RoughArtifactCollector;
import org.eclipse.osee.define.rest.api.importing.RoughArtifactKind;
import org.eclipse.osee.define.rest.importing.parsers.AbstractArtifactExtractor;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.OrcsApi;

public class WholeWordDocumentExtractor
extends AbstractArtifactExtractor {
    public String getDescription() {
        return "Extract all the content of each Word XML document as one artifact.";
    }

    @Override
    protected @NonNull XResultData extractFromSource(OrcsApi orcsApi, @NonNull XResultData results, @NonNull URI source, RoughArtifactCollector collector) throws Exception {
        Objects.requireNonNull(results, "WholeWordDocumentExtractor::extractFromSource, parameter \"results\" cannot be null.");
        Objects.requireNonNull(source, "WholeWordDocumentExtractor::extractFromSource, parameter \"source\" cannot be null.");
        RoughArtifact roughArtifact = new RoughArtifact(orcsApi, results, RoughArtifactKind.PRIMARY, Lib.removeExtension((String)new File(source).getName()));
        collector.addRoughArtifact(roughArtifact);
        roughArtifact.addAttribute((AttributeTypeToken)CoreAttributeTypes.WholeWordContent, source);
        return results;
    }

    public FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().endsWith(".xml");
            }
        };
    }

    public String getName() {
        return "Whole Word Document";
    }
}

