/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.identifier;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osee.define.operations.synchronization.LinkType;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierTypeGroup;

public final class IdentifierType
extends Enum<IdentifierType>
implements LinkType {
    public static final /* enum */ IdentifierType ATTRIBUTE_DEFINITION = new IdentifierType("AD", IdentifierTypeGroup.ATTRIBUTE, IdentifierTypeGroup.SYNCHRONIZATION_ARTIFACT_DOM);
    public static final /* enum */ IdentifierType ATTRIBUTE_VALUE = new IdentifierType("AV", IdentifierTypeGroup.ATTRIBUTE, IdentifierTypeGroup.SYNCHRONIZATION_ARTIFACT_DOM);
    public static final /* enum */ IdentifierType DATA_TYPE_DEFINITION = new IdentifierType("DD", IdentifierTypeGroup.SYNCHRONIZATION_ARTIFACT_DOM);
    public static final /* enum */ IdentifierType ENUM_VALUE = new IdentifierType("EV", IdentifierTypeGroup.SYNCHRONIZATION_ARTIFACT_DOM);
    public static final /* enum */ IdentifierType HEADER = new IdentifierType("H", IdentifierTypeGroup.SYNCHRONIZATION_ARTIFACT_DOM);
    public static final /* enum */ IdentifierType SPECIFICATION = new IdentifierType("S", IdentifierTypeGroup.SYNCHRONIZATION_ARTIFACT_DOM, IdentifierTypeGroup.OBJECT);
    public static final /* enum */ IdentifierType SPECIFICATION_TYPE = new IdentifierType("ST", IdentifierTypeGroup.SYNCHRONIZATION_ARTIFACT_DOM, IdentifierTypeGroup.TYPE);
    public static final /* enum */ IdentifierType SPECTER_SPEC_OBJECT = new IdentifierType("SSO", IdentifierTypeGroup.SYNCHRONIZATION_ARTIFACT_DOM, IdentifierTypeGroup.OBJECT, IdentifierTypeGroup.SUBORDINATE_OBJECT, IdentifierTypeGroup.RELATABLE_OBJECT);
    public static final /* enum */ IdentifierType SPEC_OBJECT = new IdentifierType("SO", IdentifierTypeGroup.SYNCHRONIZATION_ARTIFACT_DOM, IdentifierTypeGroup.OBJECT, IdentifierTypeGroup.SUBORDINATE_OBJECT, IdentifierTypeGroup.RELATABLE_OBJECT);
    public static final /* enum */ IdentifierType SPEC_OBJECT_TYPE = new IdentifierType("SOT", IdentifierTypeGroup.SYNCHRONIZATION_ARTIFACT_DOM, IdentifierTypeGroup.TYPE);
    public static final /* enum */ IdentifierType SPEC_RELATION = new IdentifierType("SR", IdentifierTypeGroup.SYNCHRONIZATION_ARTIFACT_DOM, IdentifierTypeGroup.OBJECT, IdentifierTypeGroup.SUBORDINATE_OBJECT);
    public static final /* enum */ IdentifierType SPEC_RELATION_TYPE = new IdentifierType("SRT", IdentifierTypeGroup.SYNCHRONIZATION_ARTIFACT_DOM, IdentifierTypeGroup.TYPE);
    private static final Map<IdentifierType, IdentifierType> associatedTypeMap;
    private static final Map<IdentifierTypeGroup, String> identifierTypeGroupMembersMessageMap;
    private static final int size;
    private ThreadLocal<Long> identifierCount;
    private String identifierPrefix;
    private Set<IdentifierTypeGroup> identifierTypeGroups;
    private ThreadLocal<StringBuilder> stringBuilder;
    private static final /* synthetic */ IdentifierType[] ENUM$VALUES;

    static {
        ENUM$VALUES = new IdentifierType[]{ATTRIBUTE_DEFINITION, ATTRIBUTE_VALUE, DATA_TYPE_DEFINITION, ENUM_VALUE, HEADER, SPECIFICATION, SPECIFICATION_TYPE, SPECTER_SPEC_OBJECT, SPEC_OBJECT, SPEC_OBJECT_TYPE, SPEC_RELATION, SPEC_RELATION_TYPE};
        associatedTypeMap = Map.of(SPECIFICATION, SPECIFICATION_TYPE, SPECTER_SPEC_OBJECT, SPEC_OBJECT_TYPE, SPEC_OBJECT, SPEC_OBJECT_TYPE, SPEC_RELATION, SPEC_RELATION_TYPE);
        identifierTypeGroupMembersMessageMap = Stream.of(IdentifierTypeGroup.values()).map(identifierTypeGroup -> Map.entry(identifierTypeGroup, Stream.of(IdentifierType.values()).filter(identifierType -> identifierType.isInGroup((IdentifierTypeGroup)identifierTypeGroup)).map(Enum::name).collect(Collectors.joining(", ", "[ ", " ]")))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        size = IdentifierType.values().length;
    }

    private IdentifierType(String identifierPrefix, IdentifierTypeGroup ... identifierTypeGroups) {
        assert (Objects.nonNull(identifierPrefix));
        this.identifierPrefix = identifierPrefix;
        this.identifierTypeGroups = EnumSet.noneOf(IdentifierTypeGroup.class);
        if (Objects.nonNull(identifierTypeGroups)) {
            IdentifierTypeGroup[] identifierTypeGroupArray = identifierTypeGroups;
            int n2 = identifierTypeGroups.length;
            int n3 = 0;
            while (n3 < n2) {
                IdentifierTypeGroup identifierTypeGroup = identifierTypeGroupArray[n3];
                this.identifierTypeGroups.add(identifierTypeGroup);
                ++n3;
            }
        }
        this.identifierCount = new ThreadLocal<Long>(){

            @Override
            protected Long initialValue() {
                return 0L;
            }
        };
        this.stringBuilder = new ThreadLocal<StringBuilder>(){

            @Override
            protected StringBuilder initialValue() {
                return new StringBuilder(32);
            }
        };
    }

    public static String getIdentifierTypeGroupMembersMessage(IdentifierTypeGroup identifierTypeGroup) {
        return identifierTypeGroupMembersMessageMap.get(identifierTypeGroup);
    }

    public static int size() {
        return size;
    }

    public static void resetIdentifierCounts() {
        Arrays.stream(IdentifierType.values()).forEach(IdentifierType::resetIdentifierCount);
    }

    private void resetIdentifierCount() {
        this.identifierCount.set(0L);
    }

    public IdentifierType getAssociatedType() {
        IdentifierType associatedType = associatedTypeMap.get(this);
        if (Objects.isNull(associatedType)) {
            StringBuilder message = new StringBuilder(1024);
            message.append("\n").append("Requested the associated type for an IdentifierType other than SPECIFICATION, SPECTER_SPEC_OBJECT, SPEC_OBJECT, or SPEC_RELATION.").append("\n").append("   Identifier Type: ").append(this).append("\n");
            throw new RuntimeException(message.toString());
        }
        return associatedType;
    }

    public String getIdentifierPrefix() {
        return this.identifierPrefix;
    }

    public boolean isInGroup(IdentifierTypeGroup identifierTypeGroup) {
        return this.identifierTypeGroups.contains(identifierTypeGroup);
    }

    public boolean isInGroupAllOf(IdentifierTypeGroup ... identifierTypeGroups) {
        IdentifierTypeGroup[] identifierTypeGroupArray = identifierTypeGroups;
        int n = identifierTypeGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IdentifierTypeGroup identifierTypeGroup = identifierTypeGroupArray[n2];
            if (!this.identifierTypeGroups.contains(identifierTypeGroup)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public List<IdentifierTypeGroup> notInGroups(IdentifierTypeGroup ... identifierTypeGroups) {
        return Arrays.stream(identifierTypeGroups).filter(identifierTypeGroup -> !this.isInGroup((IdentifierTypeGroup)identifierTypeGroup)).collect(Collectors.toList());
    }

    public boolean isInGroupAnyOf(IdentifierTypeGroup ... identifierTypeGroups) {
        IdentifierTypeGroup[] identifierTypeGroupArray = identifierTypeGroups;
        int n = identifierTypeGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IdentifierTypeGroup identifierTypeGroup = identifierTypeGroupArray[n2];
            if (this.identifierTypeGroups.contains(identifierTypeGroup)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IdentifierType[] values() {
        IdentifierType[] identifierTypeArray = ENUM$VALUES;
        int n = identifierTypeArray.length;
        IdentifierType[] identifierTypeArray2 = new IdentifierType[n];
        System.arraycopy(ENUM$VALUES, 0, identifierTypeArray2, 0, n);
        return identifierTypeArray2;
    }

    public static IdentifierType valueOf(String string) {
        return Enum.valueOf(IdentifierType.class, string);
    }
}

