/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.forest.denizens;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import org.eclipse.osee.define.operations.synchronization.RootList;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.server.OseeInfo;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;

public final class NativeHeader
implements Id,
ToMessage {
    Long id;
    private final OrcsApi orcsApi;
    private final RootList rootList;

    public NativeHeader(Long id, OrcsApi orcsApi, RootList rootList) {
        this.id = Objects.requireNonNull(id);
        this.orcsApi = Objects.requireNonNull(orcsApi);
        this.rootList = Objects.requireNonNull(rootList);
    }

    public Long getId() {
        return this.id;
    }

    public String getComment() {
        return this.rootList.toText(null).toString();
    }

    public String getRepositoryId() {
        JdbcService jdbcService = this.orcsApi.getJdbcService();
        JdbcClient jdbcClient = jdbcService.getClient();
        String databaseName = OseeInfo.getValue((JdbcClient)jdbcClient, (String)"osee.db");
        if (Objects.isNull(databaseName) || databaseName.isEmpty()) {
            databaseName = "(no-database-name)";
        }
        String databaseId = OseeInfo.getValue((JdbcClient)jdbcClient, (String)"osee.db.guid");
        return databaseName + "( " + databaseId + " )";
    }

    public String getSourceToolId() {
        return OseeCodeVersion.getVersionId().toString();
    }

    public GregorianCalendar getTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        return calendar;
    }

    public String getTitle() {
        return "OSEE Synchronization Artifact";
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        String name = this.getClass().getName();
        outMessage.indent(indent).title((CharSequence)name).indentInc().segment((CharSequence)"ORCS API", (Object)this.orcsApi, v -> Objects.nonNull(v) ? "(is set)" : "(is not set)").toMessage((ToMessage)this.rootList).indentDec();
        return outMessage;
    }
}

