/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.reports;

import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.define.operations.api.DefineOperations;
import org.eclipse.osee.define.operations.api.reports.ReportsOperations;
import org.eclipse.osee.define.operations.reports.FeatureImpactStreamingOutput;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.BranchQuery;

public class ReportsOperationsImpl
implements ReportsOperations {
    private static ReportsOperationsImpl reportsOperationsImpl = null;
    private final OrcsApi orcsApi;
    private final DefineOperations defineOperations;

    public static synchronized ReportsOperationsImpl create(OrcsApi orcsApi, DefineOperations defineOperations) {
        return Objects.isNull(reportsOperationsImpl) ? (reportsOperationsImpl = new ReportsOperationsImpl(orcsApi, defineOperations)) : reportsOperationsImpl;
    }

    public static synchronized void free() {
        reportsOperationsImpl = null;
    }

    private ReportsOperationsImpl(OrcsApi orcsApi, DefineOperations defineOperations) {
        this.orcsApi = orcsApi;
        this.defineOperations = defineOperations;
    }

    public StreamingOutput applicabilityImpact(BranchId branch, String publish, List<ArtifactTypeToken> artTypes, List<AttributeTypeToken> attrTypes) {
        boolean publishUpdates = publish.equals("true");
        Branch branchArt = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branch)).getResults().getAtMostOneOrDefault((Object)Branch.SENTINEL);
        FeatureImpactStreamingOutput streamingOutput = new FeatureImpactStreamingOutput(branchArt, this.orcsApi, this.defineOperations, publishUpdates, artTypes, attrTypes);
        return streamingOutput;
    }
}

