/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publisher.publishing;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMLApplicabilityHandler;
import org.eclipse.osee.define.rest.internal.wordupdate.WordMlLinkHandler;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchSpecification;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.publishing.DataAccessOperations;
import org.eclipse.osee.framework.core.publishing.IncludeDeleted;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.core.publishing.WordTemplateContentData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryFactory;

public class WordTemplateContentRendererHandler {
    public static final String PGNUMTYPE_START_1 = "<w:pgNumType [^>]*w:start=\"1\"/>";
    public static final String PL_STYLE_WITH_RETURN = "<w:rPr><w:rStyle w:val=\"ProductLineApplicability\"((?=/>)(/>)|(.*?</w:rStyle>)).*?</w:rPr>";
    public static final String PL_STYLE = "<w:rStyle w:val=\"ProductLineApplicability\"((?=/>)(/>)|(.*?</w:rStyle>))";
    public static final String PL_HIGHLIGHT = "<w:highlight w:val=\"light-gray\"></w:highlight><w:shd w:color=\"auto\" w:fill=\"BFBFBF\" w:val=\"clear\"></w:shd>";
    public static final String EMPTY_PARAGRAPHS = "<w:r wsp:rsidRPr=\"\\d+\"><w:t></w:t></w:r>";
    public static final String EXTRA_SPACES = "<w:r><w:t> </w:t></w:r>";
    private final OrcsApi orcsApi;
    private final Log logger;
    private WordMLApplicabilityHandler applicHandler;
    private final QueryFactory queryFactory;
    private final DataAccessOperations dataAccessOperations;

    public WordTemplateContentRendererHandler(OrcsApi orcsApi, DataAccessOperations dataAccessOperations, Log logger) {
        this.orcsApi = orcsApi;
        this.queryFactory = orcsApi.getQueryFactory();
        this.logger = logger;
        this.dataAccessOperations = dataAccessOperations;
    }

    public Pair<String, Set<String>> renderWordMLForArtifact(ArtifactReadable artifact, WordTemplateContentData wtcData) {
        int lastIndex;
        CharSequence data;
        CharSequence charSequence = data = artifact.isDeleted() ? (CharSequence)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.WordTemplateContent, DeletionFlag.INCLUDE_DELETED, null) : (CharSequence)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.WordTemplateContent, DeletionFlag.EXCLUDE_DELETED, null);
        if (Objects.isNull(data) && wtcData.getIsEdit()) {
            data = (CharSequence)CoreArtifactTypes.MsWordTemplate.getAttributeDefault((AttributeTypeGeneric)CoreAttributeTypes.WordTemplateContent);
        }
        HashSet<String> unknownGuids = new HashSet<String>();
        if (Objects.isNull(data)) {
            if (artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.HeadingMsWord})) {
                data = "";
                data = WordMlLinkHandler.link(this.queryFactory, wtcData.getLinkType(), artifact, data.toString(), wtcData.getTxId(), unknownGuids, wtcData.getPresentationType(), wtcData.getDesktopClientLoopbackUrl(), wtcData.getIncludeBookmark());
                return new Pair((Object)data.toString(), unknownGuids);
            }
            return null;
        }
        data = WordCoreUtil.replaceBinaryDataIdentifiers((CharSequence)data);
        if (wtcData.getArtIsChanged()) {
            data = WordCoreUtil.appendInlineChangeTag((CharSequence)data);
        }
        try {
            data = WordMlLinkHandler.link(this.queryFactory, wtcData.getLinkType(), artifact, data.toString(), wtcData.getTxId(), unknownGuids, wtcData.getPresentationType(), wtcData.getDesktopClientLoopbackUrl(), wtcData.getIncludeBookmark());
        }
        catch (Exception exception) {}
        data = WordCoreUtil.removeFootersAndNoDataRightsStatements((CharSequence)data);
        data = WordCoreUtil.removeProofErrors((CharSequence)data);
        data = WordCoreUtil.replaceEmptySectionBreaksWithPageBreaks((CharSequence)data).toString();
        String dataString = data.toString();
        if (wtcData.getIsEdit() && !dataString.contains("<w:tbl>") && (lastIndex = dataString.lastIndexOf("<w:p wsp:rsidR=")) != -1) {
            String temp = dataString.substring(lastIndex);
            temp = temp.replaceAll("<w:p\\s[^>]*>(<w:pPr><w:spacing[^>]*></w:spacing></w:pPr>)?</w:p>", "");
            dataString = String.valueOf(dataString.substring(0, lastIndex)) + temp;
        }
        if (!wtcData.getIsEdit() && (wtcData.getBranch().getViewId().notEqual((Id)ArtifactId.SENTINEL) || wtcData.isViewIdValid())) {
            if (this.applicHandler == null) {
                this.applicHandler = new WordMLApplicabilityHandler(this.orcsApi, this.logger, wtcData.getBranch(), wtcData.getViewId());
            }
            dataString = dataString.replaceAll(PL_STYLE_WITH_RETURN, "");
            dataString = dataString.replaceAll(PL_STYLE, "");
            dataString = dataString.replaceAll(PL_HIGHLIGHT, "");
            dataString = this.applicHandler.previewValidApplicabilityContent(dataString);
            dataString = dataString.replaceAll(EMPTY_PARAGRAPHS, "");
        }
        dataString = dataString.concat(wtcData.getFooter());
        if (!wtcData.getIsEdit()) {
            dataString = dataString.replaceAll(PGNUMTYPE_START_1, "");
        }
        return new Pair((Object)dataString, unknownGuids);
    }

    public Pair<String, Set<String>> renderWordML(WordTemplateContentData wtcData) {
        return (Pair)this.dataAccessOperations.getArtifactReadables(new BranchSpecification(wtcData.getBranch(), wtcData.getViewId()), List.of(ArtifactId.valueOf((Id)wtcData.getArtId())), List.of(), "", ArtifactTypeToken.SENTINEL, wtcData.isTxIdValid() ? wtcData.getTxId() : TransactionId.SENTINEL, IncludeDeleted.YES).filterValue(Predicate.not(List::isEmpty)).mapValue(artifactReadables -> this.renderWordMLForArtifact((ArtifactReadable)artifactReadables.get(0), wtcData)).orElseGet(null);
    }
}

