/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.testscript.internal.ScriptResultToken;

public class SetDiffToken {
    private final String name;
    private final Map<ArtifactId, SetDiffResult> results;
    private final int numSets;

    public SetDiffToken(String name, int numSets) {
        this.name = name;
        this.results = new HashMap<ArtifactId, SetDiffResult>();
        this.numSets = numSets;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEqual() {
        if (this.getResults().isEmpty()) {
            return true;
        }
        if (this.getResults().size() != this.numSets) {
            return false;
        }
        return this.getResults().values().stream().allMatch(this.getResults().values().toArray()[0]::equals);
    }

    public Map<ArtifactId, SetDiffResult> getResults() {
        return this.results;
    }

    public void addResult(ArtifactId setId, ScriptResultToken result) {
        SetDiffResult diff = this.getResults().get(setId);
        if (diff == null || result.getExecutionDate().after(diff.getExecutionDate())) {
            this.getResults().put(setId, new SetDiffResult(result.getPassedCount(), result.getFailedCount(), result.getScriptAborted(), result.getExecutionDate()));
        }
    }

    private class SetDiffResult {
        private final int passes;
        private final int fails;
        private final boolean abort;
        private final Date executionDate;

        public SetDiffResult(int passes, int fails, boolean abort, Date executionDate) {
            this.passes = passes;
            this.fails = fails;
            this.abort = abort;
            this.executionDate = executionDate;
        }

        public int getPasses() {
            return this.passes;
        }

        public int getFails() {
            return this.fails;
        }

        public boolean isAbort() {
            return this.abort;
        }

        @JsonIgnore
        public Date getExecutionDate() {
            return this.executionDate;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SetDiffResult) {
                SetDiffResult res = (SetDiffResult)obj;
                return this.getPasses() == res.getPasses() && this.getFails() == res.getFails() && this.isAbort() == res.isAbort();
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

