/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.orcs.rest.model.transaction.TransactionBuilderData;
import org.eclipse.osee.testscript.ScriptImportEndpoint;
import org.eclipse.osee.testscript.TmoImportApi;
import org.eclipse.osee.testscript.internal.ScriptDefToken;
import org.eclipse.osee.testscript.internal.TmoImportResult;

public class ScriptImportEndpointImpl
implements ScriptImportEndpoint {
    private final BranchId branch;
    private final TmoImportApi tmoImportApi;

    public ScriptImportEndpointImpl(BranchId branch, TmoImportApi tmoImportApi) {
        this.branch = branch;
        this.tmoImportApi = tmoImportApi;
    }

    @Override
    public TransactionBuilderData getTxBuilderData(InputStream stream, ArtifactId ciSetId) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            stream.transferTo(outputStream);
            ScriptDefToken scriptDef = this.tmoImportApi.getScriptDefinition(new ByteArrayInputStream(outputStream.toByteArray()), ciSetId);
            outputStream.close();
            stream.close();
            return this.tmoImportApi.getTxBuilderData(this.branch, scriptDef);
        }
        catch (IOException ex) {
            System.out.println(ex);
            return new TransactionBuilderData();
        }
    }

    @Override
    public TmoImportResult importFile(InputStream stream, ArtifactId ciSetId) {
        return this.tmoImportApi.importFile(stream, this.branch, ciSetId);
    }

    @Override
    public TmoImportResult importBatch(InputStream stream, ArtifactId ciSetId) {
        return this.tmoImportApi.importBatch(stream, this.branch, ciSetId);
    }

    @Override
    public ScriptDefToken getScriptDefinition(InputStream stream) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            stream.transferTo(outputStream);
            ScriptDefToken scriptDef = this.tmoImportApi.getScriptDefinition(new ByteArrayInputStream(outputStream.toByteArray()), ArtifactId.SENTINEL);
            outputStream.close();
            stream.close();
            return scriptDef;
        }
        catch (IOException ex) {
            System.out.println(ex);
            return ScriptDefToken.SENTINEL;
        }
    }
}

