/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;
import org.eclipse.osee.testscript.internal.InfoToken;

public class InfoGroupToken
extends ArtifactAccessorResultWithoutGammas {
    public static final InfoGroupToken SENTINEL = new InfoGroupToken();
    private String groupType;
    private List<InfoToken> info;

    public InfoGroupToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InfoGroupToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(art.getName());
        this.setGroupType(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.GroupType, "InfoGroup"));
        this.setInfo(art.getRelated(CoreRelationTypes.InfoGroupToInfo_Info).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new InfoToken((ArtifactReadable)a)).collect(Collectors.toList()));
    }

    public InfoGroupToken(Long id, String name) {
        super(id, name);
        this.setGroupType("InfoGroup");
        this.setInfo(new LinkedList<InfoToken>());
    }

    public InfoGroupToken() {
    }

    public String getGroupType() {
        return this.groupType;
    }

    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    public List<InfoToken> getInfo() {
        return this.info;
    }

    public void setInfo(List<InfoToken> info) {
        this.info = info;
    }

    public CreateArtifact createArtifact(String key) {
        HashMap<AttributeTypeString, String> values = new HashMap<AttributeTypeString, String>();
        values.put(CoreAttributeTypes.GroupType, this.getGroupType());
        CreateArtifact art = new CreateArtifact();
        art.setName(this.getName());
        art.setTypeId(CoreArtifactTypes.InfoGroup.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.InfoGroup.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setkey(key);
        return art;
    }
}

