/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import com.google.common.collect.TreeBasedTable;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.accessor.internal.ArtifactAccessorImpl;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.ds.FollowRelation;
import org.eclipse.osee.testscript.DashboardApi;
import org.eclipse.osee.testscript.ScriptDefApi;
import org.eclipse.osee.testscript.internal.CIStatsToken;
import org.eclipse.osee.testscript.internal.CITimelineStatsToken;
import org.eclipse.osee.testscript.internal.ScriptDefToken;
import org.eclipse.osee.testscript.internal.ScriptResultToken;

public class DashboardApiImpl
implements DashboardApi {
    private final ScriptDefApi scriptDefApi;
    private final OrcsApi orcsApi;

    public DashboardApiImpl(ScriptDefApi scriptDefApi, OrcsApi orcsApi) {
        this.scriptDefApi = scriptDefApi;
        this.orcsApi = orcsApi;
    }

    @Override
    public Collection<CITimelineStatsToken> getTimelineStats(BranchId branch, ArtifactId ciSet, ArtifactId viewId) {
        viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        TreeBasedTable stats = TreeBasedTable.create();
        Collection<ScriptDefToken> defs = this.scriptDefApi.getAllByFilter(branch, ciSet.getIdString(), FollowRelation.followList((RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.TestScriptDefToTestScriptResults_TestScriptResults}), 0L, 0L, null, Arrays.asList(CoreAttributeTypes.SetId));
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        for (ScriptDefToken def : defs) {
            for (ScriptResultToken scriptResultToken : def.getScriptResults()) {
                Date executionDate = scriptResultToken.getExecutionDate();
                try {
                    executionDate = formatter.parse(formatter.format(executionDate));
                }
                catch (ParseException parseException) {}
                if (!stats.contains((Object)"All", (Object)executionDate)) {
                    stats.put((Object)"All", (Object)executionDate, (Object)new CIStatsToken("All", executionDate));
                }
                if (def.getTeam().isEmpty() || stats.contains((Object)def.getTeam(), (Object)executionDate)) continue;
                stats.put((Object)def.getTeam(), (Object)executionDate, (Object)new CIStatsToken(def.getTeam(), executionDate));
            }
        }
        Date currentDate = new Date();
        try {
            currentDate = formatter.parse(formatter.format(currentDate));
        }
        catch (ParseException parseException) {}
        for (String team : stats.rowKeySet()) {
            CIStatsToken allStats = new CIStatsToken(team, currentDate);
            stats.put((Object)team, (Object)currentDate, (Object)allStats);
        }
        block9: for (ScriptDefToken def : defs) {
            List<ScriptResultToken> scriptResults = def.getScriptResults();
            Collections.sort(scriptResults, Comparator.comparing(ScriptResultToken::getExecutionDate));
            int prevPointsPassed = 0;
            int prevPointsFailed = 0;
            boolean prevAborted = false;
            boolean prevPassed = false;
            boolean prevScriptRun = false;
            Date prevExecutionDate = new Date(0L);
            for (ScriptResultToken res : scriptResults) {
                Date executionDate = res.getExecutionDate();
                try {
                    executionDate = formatter.parse(formatter.format(executionDate));
                }
                catch (ParseException parseException) {}
                int pointsPassed = res.getPassedCount();
                int pointsFailed = res.getFailedCount();
                boolean aborted = res.getScriptAborted();
                boolean passed = aborted ? false : pointsFailed == 0;
                boolean scriptRun = true;
                CIStatsToken allStats = (CIStatsToken)stats.get((Object)"All", (Object)executionDate);
                if (aborted) {
                    allStats.addScriptsAbort(1);
                } else if (passed) {
                    allStats.addScriptsPass(1);
                } else {
                    allStats.addScriptsFail(1);
                }
                if (scriptRun) {
                    allStats.addScriptsRan(1);
                } else {
                    allStats.addScriptsNotRan(1);
                }
                allStats.addTestPointsPass(pointsPassed);
                allStats.addTestPointsFail(pointsFailed);
                stats.put((Object)"All", (Object)executionDate, (Object)allStats);
                if (!def.getTeam().isEmpty()) {
                    CIStatsToken teamStats = (CIStatsToken)stats.get((Object)def.getTeam(), (Object)executionDate);
                    if (aborted) {
                        teamStats.addScriptsAbort(1);
                    } else if (passed) {
                        teamStats.addScriptsPass(1);
                    } else {
                        teamStats.addScriptsFail(1);
                    }
                    if (scriptRun) {
                        teamStats.addScriptsRan(1);
                    } else {
                        teamStats.addScriptsNotRan(1);
                    }
                    teamStats.addTestPointsPass(pointsPassed);
                    teamStats.addTestPointsFail(pointsFailed);
                    stats.put((Object)def.getTeam(), (Object)executionDate, (Object)teamStats);
                }
                for (Date specifiedDate : stats.row((Object)"All").keySet()) {
                    if (specifiedDate.after(prevExecutionDate) && specifiedDate.before(executionDate)) {
                        allStats = (CIStatsToken)stats.get((Object)"All", (Object)specifiedDate);
                        if (prevAborted) {
                            allStats.addScriptsAbort(1);
                        } else if (prevPassed) {
                            allStats.addScriptsPass(1);
                        } else {
                            allStats.addScriptsFail(1);
                        }
                        if (prevScriptRun) {
                            allStats.addScriptsRan(1);
                        } else {
                            allStats.addScriptsNotRan(1);
                        }
                        allStats.addTestPointsPass(prevPointsPassed);
                        allStats.addTestPointsFail(prevPointsFailed);
                        stats.put((Object)"All", (Object)specifiedDate, (Object)allStats);
                        continue;
                    }
                    if (specifiedDate.equals(executionDate)) break;
                }
                for (Date specifiedDate : stats.row((Object)def.getTeam()).keySet()) {
                    if (specifiedDate.after(prevExecutionDate) && specifiedDate.before(executionDate)) {
                        if (def.getTeam().isEmpty()) continue;
                        CIStatsToken teamStats = (CIStatsToken)stats.get((Object)def.getTeam(), (Object)executionDate);
                        teamStats = (CIStatsToken)stats.get((Object)def.getTeam(), (Object)specifiedDate);
                        if (prevAborted) {
                            teamStats.addScriptsAbort(1);
                        } else if (prevPassed) {
                            teamStats.addScriptsPass(1);
                        } else {
                            teamStats.addScriptsFail(1);
                        }
                        if (prevScriptRun) {
                            teamStats.addScriptsRan(1);
                        } else {
                            teamStats.addScriptsNotRan(1);
                        }
                        teamStats.addTestPointsPass(prevPointsPassed);
                        teamStats.addTestPointsFail(prevPointsFailed);
                        stats.put((Object)def.getTeam(), (Object)specifiedDate, (Object)teamStats);
                        continue;
                    }
                    if (specifiedDate.equals(executionDate)) break;
                }
                prevPointsPassed = pointsPassed;
                prevPointsFailed = pointsFailed;
                prevAborted = aborted;
                prevPassed = passed;
                prevScriptRun = scriptRun;
                prevExecutionDate = executionDate;
            }
            if (prevExecutionDate.equals(currentDate)) continue;
            for (Date specifiedDate : stats.row((Object)"All").keySet()) {
                if (specifiedDate.after(prevExecutionDate) && (specifiedDate.before(currentDate) || specifiedDate.equals(currentDate))) {
                    CIStatsToken allStats = (CIStatsToken)stats.get((Object)"All", (Object)specifiedDate);
                    if (prevAborted) {
                        allStats.addScriptsAbort(1);
                    } else if (prevPassed) {
                        allStats.addScriptsPass(1);
                    } else {
                        allStats.addScriptsFail(1);
                    }
                    if (prevScriptRun) {
                        allStats.addScriptsRan(1);
                    } else {
                        allStats.addScriptsNotRan(1);
                    }
                    allStats.addTestPointsPass(prevPointsPassed);
                    allStats.addTestPointsFail(prevPointsFailed);
                    stats.put((Object)"All", (Object)specifiedDate, (Object)allStats);
                    continue;
                }
                if (specifiedDate.equals(currentDate)) break;
            }
            for (Date specifiedDate : stats.row((Object)def.getTeam()).keySet()) {
                if (specifiedDate.after(prevExecutionDate) && (specifiedDate.before(currentDate) || specifiedDate.equals(currentDate))) {
                    if (def.getTeam().isEmpty()) continue;
                    CIStatsToken teamStats = (CIStatsToken)stats.get((Object)def.getTeam(), (Object)specifiedDate);
                    if (prevAborted) {
                        teamStats.addScriptsAbort(1);
                    } else if (prevPassed) {
                        teamStats.addScriptsPass(1);
                    } else {
                        teamStats.addScriptsFail(1);
                    }
                    if (prevScriptRun) {
                        teamStats.addScriptsRan(1);
                    } else {
                        teamStats.addScriptsNotRan(1);
                    }
                    teamStats.addTestPointsPass(prevPointsPassed);
                    teamStats.addTestPointsFail(prevPointsFailed);
                    stats.put((Object)def.getTeam(), (Object)specifiedDate, (Object)teamStats);
                    continue;
                }
                if (specifiedDate.equals(currentDate)) continue block9;
            }
        }
        LinkedList<CITimelineStatsToken> values = new LinkedList<CITimelineStatsToken>();
        for (String string : stats.rowKeySet()) {
            CITimelineStatsToken timelineStats = new CITimelineStatsToken(string);
            timelineStats.setCiStats(stats.row((Object)string).values());
            values.add(timelineStats);
        }
        return values;
    }

    @Override
    public Collection<ArtifactAccessorResultWithoutGammas> getSubsystems(BranchId branch, String filter, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        ArtifactAccessorResultAccessor accessor = new ArtifactAccessorResultAccessor(CoreArtifactTypes.ScriptSubsystem, this.orcsApi);
        try {
            return accessor.getAllByFilter(branch, filter, Arrays.asList(CoreAttributeTypes.Name), pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return Collections.emptyList();
        }
    }

    @Override
    public Integer getSubsystemsCount(BranchId branch, String filter) {
        ArtifactAccessorImpl accessor = new ArtifactAccessorImpl(CoreArtifactTypes.ScriptSubsystem, this.orcsApi);
        return accessor.getAllByFilterAndCount(branch, filter, Arrays.asList(CoreAttributeTypes.Name));
    }

    @Override
    public Collection<ArtifactAccessorResultWithoutGammas> getTeams(BranchId branch, String filter, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        ArtifactAccessorResultAccessor accessor = new ArtifactAccessorResultAccessor(CoreArtifactTypes.ScriptTeam, this.orcsApi);
        try {
            return accessor.getAllByFilter(branch, filter, Arrays.asList(CoreAttributeTypes.Name), pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return Collections.emptyList();
        }
    }

    @Override
    public Integer getTeamsCount(BranchId branch, String filter) {
        ArtifactAccessorImpl accessor = new ArtifactAccessorImpl(CoreArtifactTypes.ScriptTeam, this.orcsApi);
        return accessor.getAllByFilterAndCount(branch, filter, Arrays.asList(CoreAttributeTypes.Name));
    }

    private class ArtifactAccessorResultAccessor
    extends ArtifactAccessorImpl<ArtifactAccessorResultWithoutGammas> {
        public ArtifactAccessorResultAccessor(ArtifactTypeToken type, OrcsApi orcsApi) {
            super(type, orcsApi);
        }
    }
}

