/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;
import org.eclipse.osee.testscript.internal.StackTraceToken;

public class AttentionLocationToken
extends ArtifactAccessorResultWithoutGammas {
    public static final AttentionLocationToken SENTINEL = new AttentionLocationToken();
    private String locationId;
    private String locationTime;
    private String attentionMessage;
    private List<StackTraceToken> stackTraces;

    public AttentionLocationToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public AttentionLocationToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(art.getName());
        this.setLocationId(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.LocationId, ""));
        this.setLocationTime(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.LocationTime, ""));
        this.setAttentionMessage(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.AttentionMessage, ""));
        this.setStackTraces(art.getRelated(CoreRelationTypes.AttentionLocationToStackTrace_StackTrace).getList().stream().filter(a -> a.getExistingAttributeTypes().isEmpty()).map(a -> new StackTraceToken((ArtifactReadable)a)).collect(Collectors.toList()));
    }

    public AttentionLocationToken(Long id, String name) {
        super(id, name);
        this.setLocationId("");
        this.setLocationTime("");
        this.setAttentionMessage("");
        this.setStackTraces(new LinkedList<StackTraceToken>());
    }

    public AttentionLocationToken() {
    }

    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public String getLocationTime() {
        return this.locationTime;
    }

    public void setLocationTime(String locationTime) {
        this.locationTime = locationTime;
    }

    public String getAttentionMessage() {
        return this.attentionMessage;
    }

    public void setAttentionMessage(String attentionMessage) {
        this.attentionMessage = attentionMessage;
    }

    public List<StackTraceToken> getStackTraces() {
        return this.stackTraces;
    }

    public void setStackTraces(List<StackTraceToken> stackTraces) {
        this.stackTraces = stackTraces;
    }

    public CreateArtifact createArtifact(String key) {
        Attribute attr;
        CreateArtifact art = new CreateArtifact();
        art.setName(this.getName());
        art.setTypeId(CoreArtifactTypes.AttentionLocation.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        if (Strings.isValid((String)this.getLocationId())) {
            attr = new Attribute(CoreAttributeTypes.LocationId.getIdString());
            attr.setValue(Arrays.asList(this.getLocationId()));
            attrs.add(attr);
        }
        if (Strings.isValid((String)this.getLocationTime())) {
            attr = new Attribute(CoreAttributeTypes.LocationTime.getIdString());
            attr.setValue(Arrays.asList(this.getLocationTime()));
            attrs.add(attr);
        }
        if (Strings.isValid((String)this.getAttentionMessage())) {
            attr = new Attribute(CoreAttributeTypes.AttentionMessage.getIdString());
            attr.setValue(Arrays.asList(this.getAttentionMessage()));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setkey(key);
        return art;
    }
}

