/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.coverage.internal;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.coverage.internal.CoverageItemToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;

public class PartitionResultToken
extends ArtifactAccessorResultWithoutGammas {
    public static final PartitionResultToken SENTINEL = new PartitionResultToken();
    private Date coverageCreatedDate = new Date();
    private String coverageImportPath = "";
    private String serverImportPath = "";
    private String coverageImportState = "";
    private String coverageNotesJson = "";
    private String coverageOperationSummary = "";
    private Date coverageImportDate = new Date();
    private int passedCount = 0;
    private int failedCount = 0;
    private int coveredCount = 0;
    private int modifyCount = 0;
    private String result = "";
    private Date executionDate = new Date();
    private String executedBy = "";
    private String errors = "";
    private List<CoverageItemToken> coverageItems;

    public PartitionResultToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public PartitionResultToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(art.getName());
        this.setCoverageCreatedDate((Date)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.CoverageCreatedDate, (Object)new Date()));
        this.setCoverageImportPath(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageImportPath, ""));
        this.setServerImportPath(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageImportApi, ""));
        this.setCoverageImportState(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageImportState, ""));
        this.setCoverageNotesJson(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageNotesJson, ""));
        this.setCoverageOperationSummary(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.CoverageOperationSummary, ""));
        this.setCoverageImportDate((Date)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.CoverageImportDate, (Object)new Date()));
        this.setPassedCount((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.PassedCount, (Object)0));
        this.setFailedCount((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.FailedCount, (Object)0));
        this.setCoveredCount((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.CoveredCount, (Object)0));
        this.setModifyCount((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ModifyCount, (Object)0));
        this.setResult(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Result, ""));
        this.setExecutionDate((Date)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ExecutionDate, (Object)new Date()));
        this.setExecutedBy(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ExecutedBy, ""));
        this.setErrors("");
        this.setCoverageItems(art.getRelated(CoreRelationTypes.DefaultHierarchical_Child).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new CoverageItemToken((ArtifactReadable)a)).collect(Collectors.toList()));
    }

    public PartitionResultToken(Long id, String name) {
        super(id, name);
        this.setCoverageCreatedDate(new Date());
        this.setCoverageImportPath("");
        this.setServerImportPath("");
        this.setCoverageImportState("");
        this.setCoverageNotesJson("");
        this.setCoverageOperationSummary("");
        this.setCoverageImportDate(new Date());
        this.setPassedCount(0);
        this.setFailedCount(0);
        this.setCoveredCount(0);
        this.setModifyCount(0);
        this.setResult("");
        this.setExecutionDate(new Date());
        this.setExecutedBy("");
        this.setErrors("");
        this.setCoverageItems(new LinkedList<CoverageItemToken>());
    }

    public PartitionResultToken(Exception ex) {
        this.setErrors(ex.toString());
    }

    public PartitionResultToken() {
    }

    public Date getCoverageCreatedDate() {
        return this.coverageCreatedDate;
    }

    public void setCoverageCreatedDate(Date coverageCreatedDate) {
        this.coverageCreatedDate = coverageCreatedDate;
    }

    public String getCoverageImportPath() {
        return this.coverageImportPath;
    }

    public void setCoverageImportPath(String coverageImportPath) {
        this.coverageImportPath = coverageImportPath;
    }

    public String getServerImportPath() {
        return this.serverImportPath;
    }

    public void setServerImportPath(String serverImportPath) {
        this.serverImportPath = serverImportPath;
    }

    public String getCoverageImportState() {
        return this.coverageImportState;
    }

    public void setCoverageImportState(String coverageImportState) {
        this.coverageImportState = coverageImportState;
    }

    public String getCoverageNotesJson() {
        return this.coverageNotesJson;
    }

    public void setCoverageNotesJson(String coverageNotesJson) {
        this.coverageNotesJson = coverageNotesJson;
    }

    public String getCoverageOperationSummary() {
        return this.coverageOperationSummary;
    }

    public void setCoverageOperationSummary(String coverageOperationSummary) {
        this.coverageOperationSummary = coverageOperationSummary;
    }

    public Date getCoverageImportDate() {
        return this.coverageImportDate;
    }

    public void setCoverageImportDate(Date coverageImportDate) {
        this.coverageImportDate = coverageImportDate;
    }

    public int getPassedCount() {
        return this.passedCount;
    }

    public void setPassedCount(int passedCount) {
        this.passedCount = passedCount;
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public void setFailedCount(int failedCount) {
        this.failedCount = failedCount;
    }

    public int getCoveredCount() {
        return this.coveredCount;
    }

    public void setCoveredCount(int coveredCount) {
        this.coveredCount = coveredCount;
    }

    public int getModifyCount() {
        return this.modifyCount;
    }

    public void setModifyCount(int modifyCount) {
        this.modifyCount = modifyCount;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public Date getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(Date executionDate) {
        this.executionDate = executionDate;
    }

    public String getExecutedBy() {
        return this.executedBy;
    }

    public void setExecutedBy(String executedBy) {
        this.executedBy = executedBy;
    }

    public List<CoverageItemToken> getCoverageItems() {
        return this.coverageItems;
    }

    public void setCoverageItems(List<CoverageItemToken> coverageItems) {
        this.coverageItems = coverageItems;
    }

    public String getErrors() {
        return this.errors;
    }

    public void setErrors(String errors) {
        this.errors = errors;
    }
}

