/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.proxy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Zip;
import org.eclipse.osee.orcs.core.ds.CharacterDataProxy;
import org.eclipse.osee.orcs.core.ds.ResourceNameResolver;
import org.eclipse.osee.orcs.db.internal.proxy.AbstractDataProxy;

public class VarCharDataProxy<T>
extends AbstractDataProxy<T>
implements CharacterDataProxy<T> {
    private T rawValue;

    public String getDisplayableString() {
        return this.getValueAsString();
    }

    public void setDisplayableString(String toDisplay) {
        throw new UnsupportedOperationException();
    }

    public T getValue() {
        String fromStorage = this.getFromStorage();
        T toReturn = null;
        if (fromStorage != null) {
            return (T)this.getAttribute().convertStringToValue(fromStorage);
        }
        if (this.rawValue != null) {
            return this.rawValue;
        }
        return toReturn;
    }

    public String getValueAsString() {
        String fromStorage = this.getFromStorage();
        String toReturn = null;
        if (fromStorage != null) {
            toReturn = fromStorage;
        } else if (this.rawValue != null) {
            toReturn = this.rawValue.toString();
        }
        return toReturn != null ? toReturn : "";
    }

    public boolean setValue(T value) {
        boolean response = false;
        String currentValue = value instanceof String ? this.getValueAsString() : this.getValue();
        if (currentValue == value || currentValue != null && currentValue.equals(value)) {
            response = false;
        } else {
            this.storeValue(value);
            response = true;
        }
        return response;
    }

    private String getFromStorage() {
        String fromStorage = null;
        byte[] data = null;
        try {
            data = this.getStorage().getContent();
            if (data != null) {
                data = Zip.decompressBytes((InputStream)new ByteArrayInputStream(data));
                fromStorage = new String(data, "UTF-8");
            }
        }
        catch (IOException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        return fromStorage;
    }

    private void storeValue(T value) {
        if (value != null && value instanceof String && ((String)value).length() > 4000) {
            ResourceNameResolver resolver = this.getResolver();
            Conditions.checkNotNull((Object)resolver, (String)"ResourceNameResolver", (String)"Unable to determine internal file name", (Object[])new Object[0]);
            try {
                byte[] compressed = Zip.compressStream((InputStream)new ByteArrayInputStream(((String)value).getBytes("UTF-8")), (String)resolver.getInternalFileName());
                this.getStorage().setContent(compressed, "zip", "application/zip", "ISO-8859-1");
                this.rawValue = null;
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        } else {
            this.rawValue = value;
            this.getStorage().clear();
        }
    }

    public T getRawValue() {
        return this.rawValue;
    }

    public String getStorageString() {
        if (this.rawValue == null) {
            return "";
        }
        return this.getAttribute().convertToStorageString(this.rawValue);
    }

    public void setData(T value, String uri) {
        this.storeValue(value);
        this.getStorage().setLocator(uri);
    }
}

