/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class Triplet<F, S, T>
extends Pair<F, S> {
    private static final long serialVersionUID = -3319956950656820062L;
    protected @Nullable T third;

    public static <F, S, T> @NonNull Triplet<F, S, T> createNonNull(@NonNull F first, @NonNull S second, @NonNull T third) {
        return new Triplet<F, S, T>(Objects.requireNonNull(first), Objects.requireNonNull(second), Objects.requireNonNull(third));
    }

    public static <F, S, T> @NonNull Triplet<F, S, T> createNonNullImmutable(@NonNull F first, @NonNull S second, @NonNull T third) {
        return Triplet.createNullableImmutable(Objects.requireNonNull(first), Objects.requireNonNull(second), Objects.requireNonNull(third));
    }

    public static <F, S, T> @NonNull Triplet<F, S, T> createNullable(@Nullable F first, @Nullable S second, @Nullable T third) {
        return new Triplet<F, S, T>(first, second, third);
    }

    public static <F, S, T> @NonNull Triplet<F, S, T> createNullableImmutable(@Nullable F first, @Nullable S second, @Nullable T third) {
        return new Triplet<F, S, T>((Object)first, (Object)second, (Object)third){
            private static final long serialVersionUID = -3319956950656820062L;

            @Override
            public Pair<F, S> set(F first, S second) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Triplet<F, S, T> set(F first, S second, T third) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setFirst(F first) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setSecond(S second) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setThird(T third) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Triplet() {
        this.third = null;
    }

    public Triplet(@Nullable F first, @Nullable S second, @Nullable T third) {
        super(first, second);
        this.third = third;
    }

    @Override
    public boolean equals(Object obj) {
        boolean superEqual = super.equals(obj);
        if (!superEqual) {
            return false;
        }
        if (!(obj instanceof Triplet)) {
            return false;
        }
        Triplet other = (Triplet)obj;
        boolean thirdEqual = this.third != null ? this.third.equals(other.third) : other.third == null;
        return thirdEqual;
    }

    public @Nullable F getFirstIfPresentOthers(@Nullable Consumer<@NonNull S> secondAction, @Nullable Consumer<@NonNull T> thirdAction) {
        Conditions.acceptWhenNonNull(this.second, secondAction);
        Conditions.acceptWhenNonNull(this.third, thirdAction);
        return (F)this.first;
    }

    public @NonNull F getFirstNonNullIfPresentOthers(@Nullable Consumer<@NonNull S> secondAction, @Nullable Consumer<@NonNull T> thirdAction) {
        Conditions.acceptWhenNonNull(this.second, secondAction);
        Conditions.acceptWhenNonNull(this.third, thirdAction);
        return (F)Conditions.requireNonNull(this.first);
    }

    public @Nullable T getThird() {
        return this.third;
    }

    public @NonNull T getThirdNonNull() {
        return Conditions.requireNonNull(this.third);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.first, this.second, this.third);
    }

    public void ifPresent(@Nullable Consumer<@NonNull F> firstAction, @Nullable Consumer<@NonNull S> secondAction, @Nullable Consumer<@NonNull T> thirdAction) {
        Conditions.acceptWhenNonNull(this.first, firstAction);
        Conditions.acceptWhenNonNull(this.second, secondAction);
        Conditions.acceptWhenNonNull(this.third, thirdAction);
    }

    public @NonNull Triplet<F, S, T> set(@Nullable F first, @Nullable S second, @Nullable T third) {
        super.set(first, second);
        this.setThird(third);
        return this;
    }

    public void setThird(@Nullable T third) {
        this.third = third;
    }

    @Override
    public @NonNull String toString() {
        String firstAsString = String.valueOf(this.first);
        String secondAsString = String.valueOf(this.second);
        String thirdAsString = String.valueOf(this.third);
        String result = String.format("[%s, %s, %s]", firstAsString, secondAsString, thirdAsString);
        return Conditions.requireNonNull(result);
    }

    public boolean typesKo(@NonNull Class<?> firstClass, @NonNull Class<?> secondClass, @NonNull Class<?> thirdClass) {
        return !this.typesOk(firstClass, secondClass, thirdClass);
    }

    public boolean typesOk(@NonNull Class<?> firstClass, @NonNull Class<?> secondClass, @NonNull Class<?> thirdClass) {
        Class classOfThird = Conditions.applyWhenNonNull(this.third, t -> t.getClass());
        return this.typesOk(firstClass, secondClass) && (classOfThird == null || secondClass.isAssignableFrom(classOfThird));
    }
}

