/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workdef.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.workdef.IAtsWidgetOptionHandler;
import org.eclipse.osee.ats.api.workdef.WidgetOption;
import org.eclipse.osee.ats.api.workdef.WidgetOptionHandler;
import org.eclipse.osee.ats.api.workdef.model.LayoutItem;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.ComputedCharacteristic;
import org.eclipse.osee.framework.core.data.ComputedCharacteristicToken;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.UserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.conditions.ConditionalRule;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.WidgetHint;

public class WidgetDefinition
extends LayoutItem {
    private final AttributeTypeToken attributeType;
    private AttributeTypeToken attributeType2;
    @JsonIgnore
    private final ComputedCharacteristicToken<?> computedCharacteristic;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    @JsonIgnore
    private final RelationTypeSide relationTypeSide;
    private final WidgetOptionHandler options = new WidgetOptionHandler(new WidgetOption[0]);
    private List<ConditionalRule> conditions = new ArrayList<ConditionalRule>();
    private final List<WidgetHint> widgetHints = new ArrayList<WidgetHint>();
    private IUserGroupArtifactToken userGroup = UserGroupArtifactToken.SENTINEL;
    private String toolTip;
    private String description;
    private int height;
    private String xWidgetName;
    private String defaultValue;
    private Double min;
    private Double max;
    private ArtifactToken enumeratedArt = ArtifactToken.SENTINEL;
    private OseeImage oseeImage;

    public WidgetDefinition(String name) {
        this(name, "", new WidgetOption[0]);
    }

    public WidgetDefinition(String name, AttributeTypeToken attributeType, String xWidgetName, WidgetOption ... widgetOptions) {
        this(name, RelationTypeSide.SENTINEL, attributeType, ComputedCharacteristicToken.SENTINEL, xWidgetName, widgetOptions);
    }

    public WidgetDefinition(String name, String xWidgetName, WidgetOption ... widgetOptions) {
        this(name, RelationTypeSide.SENTINEL, (AttributeTypeToken)AttributeTypeToken.SENTINEL, ComputedCharacteristicToken.SENTINEL, xWidgetName, widgetOptions);
    }

    public WidgetDefinition(String name, RelationTypeSide relationTypeSide, String xWidgetName, WidgetOption ... widgetOptions) {
        this(name, relationTypeSide, (AttributeTypeToken)AttributeTypeToken.SENTINEL, ComputedCharacteristicToken.SENTINEL, xWidgetName, widgetOptions);
    }

    public WidgetDefinition(String name, RelationTypeSide relationTypeSide, AttributeTypeToken attributeType, ComputedCharacteristic<?> computedCharacteristic, String xWidgetName, WidgetOption ... widgetOptions) {
        super(name);
        this.relationTypeSide = relationTypeSide;
        Conditions.assertNotNull((Object)attributeType, (String)"attribute type can not be null for WidgetDefinition [%s]", (Object[])new Object[]{name});
        this.attributeType = attributeType;
        this.computedCharacteristic = computedCharacteristic;
        this.xWidgetName = xWidgetName;
        WidgetOption[] widgetOptionArray = widgetOptions;
        int n = widgetOptions.length;
        int n2 = 0;
        while (n2 < n) {
            WidgetOption opt = widgetOptionArray[n2];
            this.options.add(opt);
            ++n2;
        }
    }

    public WidgetDefinition(AttributeTypeToken attrType, String xWidgetName, List<ConditionalRule> conditions, WidgetOption ... widgetOptions) {
        this(attrType, xWidgetName, widgetOptions);
        this.conditions = conditions;
    }

    public WidgetDefinition(AttributeTypeToken attrType, String xWidgetName, WidgetOption ... widgetOptions) {
        this(attrType.getUnqualifiedName(), RelationTypeSide.SENTINEL, attrType, ComputedCharacteristicToken.SENTINEL, xWidgetName, widgetOptions);
    }

    public WidgetDefinition(ComputedCharacteristic<?> computedCharacteristic, String xWidgetName, WidgetOption ... widgetOptions) {
        this(computedCharacteristic.getName(), RelationTypeSide.SENTINEL, (AttributeTypeToken)AttributeTypeToken.SENTINEL, computedCharacteristic, xWidgetName, widgetOptions);
    }

    public WidgetDefinition(String name, AttributeTypeToken attrType, String xWidgetName, List<ConditionalRule> conditions, WidgetOption ... widgetOptions) {
        this(name, attrType, xWidgetName, widgetOptions);
        this.conditions = conditions;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public boolean is(WidgetOption widgetOption) {
        return this.options.contains(widgetOption);
    }

    public void set(WidgetOption widgetOption) {
        this.options.add(widgetOption);
    }

    public String getXWidgetName() {
        return this.xWidgetName;
    }

    public void setXWidgetName(String xWidgetName) {
        this.xWidgetName = xWidgetName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String toString() {
        return String.format("[%s][%s]", this.getName(), this.getAttributeType().isValid() ? this.getAttributeType().toStringWithId() : "");
    }

    public IAtsWidgetOptionHandler getOptions() {
        return this.options;
    }

    public void setConstraint(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public AttributeTypeToken getAttributeType() {
        return this.attributeType;
    }

    public ComputedCharacteristicToken<?> getComputedCharacteristic() {
        return this.computedCharacteristic;
    }

    public RelationTypeSide getRelationTypeSide() {
        return this.relationTypeSide;
    }

    public void addParameter(String key, Object obj) {
        this.parameters.put(key, obj);
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public List<ConditionalRule> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<ConditionalRule> conditions) {
        this.conditions = conditions;
    }

    public WidgetDefinition andEnumeratedArt(ArtifactToken enumeratedArt) {
        Conditions.requireNonNull((Object)enumeratedArt, (String)"Enumerated Art");
        this.enumeratedArt = enumeratedArt;
        return this;
    }

    public ArtifactToken getEnumeratedArt() {
        return this.enumeratedArt;
    }

    public void setEnumeratedArt(ArtifactToken enumeratedArt) {
        Conditions.requireNonNull((Object)enumeratedArt, (String)"Enumerated Art");
        this.enumeratedArt = enumeratedArt;
    }

    public OseeImage getOseeImage() {
        return this.oseeImage;
    }

    public void setOseeImage(OseeImage oseeImage) {
        this.oseeImage = oseeImage;
    }

    public AttributeTypeToken getAttributeType2() {
        return this.attributeType2;
    }

    public void setAttributeType2(AttributeTypeToken attributeType2) {
        this.attributeType2 = attributeType2;
    }

    public List<WidgetHint> getWidgetHints() {
        return this.widgetHints;
    }

    public IUserGroupArtifactToken getUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(IUserGroupArtifactToken userGroup) {
        this.userGroup = userGroup;
    }

    public LayoutItem andCondition(ConditionalRule ... rules) {
        ConditionalRule[] conditionalRuleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            ConditionalRule rule = conditionalRuleArray[n2];
            this.conditions.add(rule);
            ++n2;
        }
        return this;
    }
}

