/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithGammas;
import org.eclipse.osee.accessor.types.AttributePojo;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;

public class TransportType
extends ArtifactAccessorResultWithGammas {
    public static final TransportType SENTINEL = new TransportType();
    private AttributePojo<Boolean> byteAlignValidation = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.ByteAlignValidation, (GammaId)GammaId.SENTINEL, (Object)false, (String)"");
    private AttributePojo<Boolean> messageGeneration = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.MessageGeneration, (GammaId)GammaId.SENTINEL, (Object)false, (String)"");
    private AttributePojo<Integer> byteAlignValidationSize = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.ByteAlignValidationSize, (GammaId)GammaId.SENTINEL, (Object)0, (String)"");
    private AttributePojo<String> messageGenerationType = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.MessageGenerationType, (GammaId)GammaId.SENTINEL, (Object)"", (String)"");
    private AttributePojo<String> messageGenerationPosition = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.MessageGenerationPosition, (GammaId)GammaId.SENTINEL, (Object)"", (String)"");
    private AttributePojo<Integer> minimumSubscriberMultiplicity = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.MinimumSubscriberMultiplicity, (GammaId)GammaId.SENTINEL, (Object)0, (String)"");
    private AttributePojo<Integer> maximumSubscriberMultiplicity = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.MaximumSubscriberMultiplicity, (GammaId)GammaId.SENTINEL, (Object)0, (String)"");
    private AttributePojo<Integer> minimumPublisherMultiplicity = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.MinimumPublisherMultiplicity, (GammaId)GammaId.SENTINEL, (Object)0, (String)"");
    private AttributePojo<Integer> maximumPublisherMultiplicity = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.MaximumPublisherMultiplicity, (GammaId)GammaId.SENTINEL, (Object)0, (String)"");
    private AttributePojo<Boolean> isDashed = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.DashedPresentation, (GammaId)GammaId.SENTINEL, (Object)false, (String)"");
    private AttributePojo<Boolean> spareAutoNumbering = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.SpareAutoNumbering, (GammaId)GammaId.SENTINEL, (Object)false, (String)"");
    private AttributePojo<List<String>> interfaceLevelsToUse = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.InterfaceLevelsToUse, (GammaId)GammaId.SENTINEL, new LinkedList(), (String)"");
    private AttributePojo<List<String>> availableMessageHeaders = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.AvailableMessageHeaders, (GammaId)GammaId.SENTINEL, new LinkedList(), (String)"");
    private AttributePojo<List<String>> availableSubmessageHeaders = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.AvailableSubmessageHeaders, (GammaId)GammaId.SENTINEL, new LinkedList(), (String)"");
    private AttributePojo<List<String>> availableStructureHeaders = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.AvailableStructureHeaders, (GammaId)GammaId.SENTINEL, new LinkedList(), (String)"");
    private AttributePojo<List<String>> availableElementHeaders = AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.AvailableElementHeaders, (GammaId)GammaId.SENTINEL, new LinkedList(), (String)"");
    private ApplicabilityToken applicability = ApplicabilityToken.SENTINEL;

    public TransportType(ArtifactToken art) {
        super(art);
    }

    public TransportType(ArtifactReadable art) {
        super(art);
        if (art.isValid()) {
            this.setByteAlignValidation((AttributePojo<Boolean>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.ByteAlignValidation, (Object)false)));
            this.setMessageGeneration((AttributePojo<Boolean>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.MessageGeneration, (Object)false)));
            AttributePojo validationSize = AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.ByteAlignValidationSize, (Object)0));
            this.setByteAlignValidationSize((AttributePojo<Integer>)((Boolean)this.getByteAlignValidation().getValue() != false ? validationSize : AttributePojo.valueOf((Long)validationSize.getId(), (AttributeTypeToken)CoreAttributeTypes.ByteAlignValidationSize, (GammaId)validationSize.getGammaId(), (Object)0, (String)validationSize.getDisplayableString())));
            AttributePojo messageGenerationType = AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.MessageGenerationType, (Object)""));
            this.setMessageGenerationType((AttributePojo<String>)((Boolean)this.getMessageGeneration().getValue() != false ? messageGenerationType : AttributePojo.valueOf((Long)messageGenerationType.getId(), (AttributeTypeToken)CoreAttributeTypes.MessageGenerationType, (GammaId)messageGenerationType.getGammaId(), (Object)"", (String)messageGenerationType.getDisplayableString())));
            AttributePojo messageGenerationPosition = AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.MessageGenerationPosition, (Object)""));
            this.setMessageGenerationPosition((AttributePojo<String>)((Boolean)this.getMessageGeneration().getValue() != false ? messageGenerationPosition : AttributePojo.valueOf((Long)messageGenerationPosition.getId(), (AttributeTypeToken)CoreAttributeTypes.MessageGenerationPosition, (GammaId)messageGenerationPosition.getGammaId(), (Object)"", (String)messageGenerationPosition.getDisplayableString())));
            AttributePojo minSubMultiplicity = AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.MinimumSubscriberMultiplicity, (Object)""));
            AttributePojo maxSubMultiplicity = AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.MaximumSubscriberMultiplicity, (Object)""));
            AttributePojo minPubMultiplicity = AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.MinimumPublisherMultiplicity, (Object)""));
            AttributePojo maxPubMultiplicity = AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.MaximumPublisherMultiplicity, (Object)""));
            if (Strings.isNumeric((String)((String)minSubMultiplicity.getValue()))) {
                this.setMinimumSubscriberMultiplicity((AttributePojo<Integer>)AttributePojo.valueOf((Long)minSubMultiplicity.getId(), (AttributeTypeToken)minSubMultiplicity.getTypeId(), (GammaId)minSubMultiplicity.getGammaId(), (Object)Integer.valueOf((String)minSubMultiplicity.getValue()), (String)minSubMultiplicity.getDisplayableString()));
            } else {
                this.setMinimumSubscriberMultiplicity((AttributePojo<Integer>)AttributePojo.valueOf((Long)minSubMultiplicity.getId(), (AttributeTypeToken)minSubMultiplicity.getTypeId(), (GammaId)minSubMultiplicity.getGammaId(), (Object)0, (String)minSubMultiplicity.getDisplayableString()));
            }
            if (Strings.isNumeric((String)((String)maxSubMultiplicity.getValue()))) {
                this.setMaximumSubscriberMultiplicity((AttributePojo<Integer>)AttributePojo.valueOf((Long)maxSubMultiplicity.getId(), (AttributeTypeToken)maxSubMultiplicity.getTypeId(), (GammaId)maxSubMultiplicity.getGammaId(), (Object)Integer.valueOf((String)maxSubMultiplicity.getValue()), (String)maxSubMultiplicity.getDisplayableString()));
            } else {
                this.setMaximumSubscriberMultiplicity((AttributePojo<Integer>)AttributePojo.valueOf((Long)maxSubMultiplicity.getId(), (AttributeTypeToken)maxSubMultiplicity.getTypeId(), (GammaId)maxSubMultiplicity.getGammaId(), (Object)0, (String)maxSubMultiplicity.getDisplayableString()));
            }
            if (Strings.isNumeric((String)((String)minPubMultiplicity.getValue()))) {
                this.setMinimumPublisherMultiplicity((AttributePojo<Integer>)AttributePojo.valueOf((Long)minPubMultiplicity.getId(), (AttributeTypeToken)minPubMultiplicity.getTypeId(), (GammaId)minPubMultiplicity.getGammaId(), (Object)Integer.valueOf((String)minPubMultiplicity.getValue()), (String)minPubMultiplicity.getDisplayableString()));
            } else {
                this.setMinimumPublisherMultiplicity((AttributePojo<Integer>)AttributePojo.valueOf((Long)minPubMultiplicity.getId(), (AttributeTypeToken)minPubMultiplicity.getTypeId(), (GammaId)minPubMultiplicity.getGammaId(), (Object)0, (String)minPubMultiplicity.getDisplayableString()));
            }
            if (Strings.isNumeric((String)((String)maxPubMultiplicity.getValue()))) {
                this.setMaximumPublisherMultiplicity((AttributePojo<Integer>)AttributePojo.valueOf((Long)maxPubMultiplicity.getId(), (AttributeTypeToken)maxPubMultiplicity.getTypeId(), (GammaId)maxPubMultiplicity.getGammaId(), (Object)Integer.valueOf((String)maxPubMultiplicity.getValue()), (String)maxPubMultiplicity.getDisplayableString()));
            } else {
                this.setMaximumPublisherMultiplicity((AttributePojo<Integer>)AttributePojo.valueOf((Long)maxPubMultiplicity.getId(), (AttributeTypeToken)maxPubMultiplicity.getTypeId(), (GammaId)maxPubMultiplicity.getGammaId(), (Object)0, (String)maxPubMultiplicity.getDisplayableString()));
            }
            AttributePojo levels = AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.InterfaceLevelsToUse, (Object)"[]"));
            this.setInterfaceLevelsToUse((AttributePojo<List<String>>)AttributePojo.valueOf((Long)levels.getId(), (AttributeTypeToken)levels.getTypeId(), (GammaId)levels.getGammaId(), this.getJSONContents((String)levels.getValue()), (String)levels.getDisplayableString()));
            AttributePojo messageHeaders = AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.AvailableMessageHeaders, (Object)"[]"));
            this.setAvailableMessageHeaders((AttributePojo<List<String>>)AttributePojo.valueOf((Long)messageHeaders.getId(), (AttributeTypeToken)messageHeaders.getTypeId(), (GammaId)messageHeaders.getGammaId(), this.getJSONContents((String)messageHeaders.getValue()), (String)messageHeaders.getDisplayableString()));
            AttributePojo submessageHeaders = AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.AvailableSubmessageHeaders, (Object)"[]"));
            this.setAvailableSubmessageHeaders((AttributePojo<List<String>>)AttributePojo.valueOf((Long)submessageHeaders.getId(), (AttributeTypeToken)submessageHeaders.getTypeId(), (GammaId)submessageHeaders.getGammaId(), this.getJSONContents((String)submessageHeaders.getValue()), (String)submessageHeaders.getDisplayableString()));
            AttributePojo structureHeaders = AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.AvailableStructureHeaders, (Object)"[]"));
            this.setAvailableStructureHeaders((AttributePojo<List<String>>)AttributePojo.valueOf((Long)structureHeaders.getId(), (AttributeTypeToken)structureHeaders.getTypeId(), (GammaId)structureHeaders.getGammaId(), this.getJSONContents((String)structureHeaders.getValue()), (String)structureHeaders.getDisplayableString()));
            AttributePojo elementHeaders = AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.AvailableElementHeaders, (Object)"[]"));
            this.setAvailableElementHeaders((AttributePojo<List<String>>)AttributePojo.valueOf((Long)elementHeaders.getId(), (AttributeTypeToken)elementHeaders.getTypeId(), (GammaId)elementHeaders.getGammaId(), this.getJSONContents((String)elementHeaders.getValue()), (String)elementHeaders.getDisplayableString()));
            this.setDashedPresentation((AttributePojo<Boolean>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.DashedPresentation, (Object)false)));
            this.setSpareAutoNumbering((AttributePojo<Boolean>)AttributePojo.valueOf((IAttribute)art.getSoleAttribute((AttributeTypeToken)CoreAttributeTypes.SpareAutoNumbering, (Object)false)));
            this.setApplicability(!art.getApplicabilityToken().getId().equals(-1L) ? art.getApplicabilityToken() : ApplicabilityToken.SENTINEL);
        } else {
            this.setApplicability(ApplicabilityToken.SENTINEL);
        }
    }

    public TransportType(Long id, String name) {
        super(id, AttributePojo.valueOf((Long)Id.SENTINEL, (AttributeTypeToken)CoreAttributeTypes.Name, (GammaId)GammaId.SENTINEL, (Object)name, (String)""));
    }

    public TransportType() {
    }

    public AttributePojo<String> getMessageGenerationType() {
        return this.messageGenerationType;
    }

    @JsonProperty
    public void setMessageGenerationType(AttributePojo<String> messageGenerationType) {
        this.messageGenerationType = messageGenerationType;
    }

    public void setMessageGenerationType(String messageGenerationType) {
        this.messageGenerationType = AttributePojo.valueOf((Long)this.messageGenerationType.getId(), (AttributeTypeToken)this.messageGenerationType.getTypeId(), (GammaId)this.messageGenerationType.getGammaId(), (Object)messageGenerationType, (String)this.messageGenerationType.getDisplayableString());
    }

    public AttributePojo<String> getMessageGenerationPosition() {
        return this.messageGenerationPosition;
    }

    @JsonProperty
    public void setMessageGenerationPosition(AttributePojo<String> messageGenerationPosition) {
        this.messageGenerationPosition = messageGenerationPosition;
    }

    public void setMessageGenerationPosition(String messageGenerationPosition) {
        this.messageGenerationType = AttributePojo.valueOf((Long)this.messageGenerationPosition.getId(), (AttributeTypeToken)this.messageGenerationPosition.getTypeId(), (GammaId)this.messageGenerationPosition.getGammaId(), (Object)messageGenerationPosition, (String)this.messageGenerationPosition.getDisplayableString());
    }

    public AttributePojo<Integer> getByteAlignValidationSize() {
        return this.byteAlignValidationSize;
    }

    @JsonProperty
    public void setByteAlignValidationSize(AttributePojo<Integer> byteAlignValidationSize) {
        this.byteAlignValidationSize = byteAlignValidationSize;
    }

    public void setByteAlignValidationSize(Integer byteAlignValidationSize) {
        this.byteAlignValidationSize = AttributePojo.valueOf((Long)this.byteAlignValidationSize.getId(), (AttributeTypeToken)this.byteAlignValidationSize.getTypeId(), (GammaId)this.byteAlignValidationSize.getGammaId(), (Object)byteAlignValidationSize, (String)this.byteAlignValidationSize.getDisplayableString());
    }

    public AttributePojo<Boolean> getMessageGeneration() {
        return this.messageGeneration;
    }

    @JsonProperty
    public void setMessageGeneration(AttributePojo<Boolean> messageGeneration) {
        this.messageGeneration = messageGeneration;
    }

    public void setMessageGeneration(Boolean messageGeneration) {
        this.messageGeneration = AttributePojo.valueOf((Long)this.messageGeneration.getId(), (AttributeTypeToken)this.messageGeneration.getTypeId(), (GammaId)this.messageGeneration.getGammaId(), (Object)messageGeneration, (String)this.messageGeneration.getDisplayableString());
    }

    public AttributePojo<Boolean> getByteAlignValidation() {
        return this.byteAlignValidation;
    }

    @JsonProperty
    public void setByteAlignValidation(AttributePojo<Boolean> byteAlignValidation) {
        this.byteAlignValidation = byteAlignValidation;
    }

    public void setByteAlignValidation(Boolean byteAlignValidation) {
        this.byteAlignValidation = AttributePojo.valueOf((Long)this.byteAlignValidation.getId(), (AttributeTypeToken)this.byteAlignValidation.getTypeId(), (GammaId)this.byteAlignValidation.getGammaId(), (Object)byteAlignValidation, (String)this.byteAlignValidation.getDisplayableString());
    }

    public AttributePojo<Integer> getMinimumSubscriberMultiplicity() {
        return this.minimumSubscriberMultiplicity;
    }

    @JsonProperty
    public void setMinimumSubscriberMultiplicity(AttributePojo<Integer> minimumSubscriberMultiplicity) {
        this.minimumSubscriberMultiplicity = minimumSubscriberMultiplicity;
    }

    public void setMinimumSubscriberMultiplicity(Integer minimumSubscriberMultiplicity) {
        this.minimumSubscriberMultiplicity = AttributePojo.valueOf((Long)this.minimumSubscriberMultiplicity.getId(), (AttributeTypeToken)this.minimumSubscriberMultiplicity.getTypeId(), (GammaId)this.minimumSubscriberMultiplicity.getGammaId(), (Object)minimumSubscriberMultiplicity, (String)this.minimumSubscriberMultiplicity.getDisplayableString());
    }

    public AttributePojo<Integer> getMaximumSubscriberMultiplicity() {
        return this.maximumSubscriberMultiplicity;
    }

    @JsonProperty
    public void setMaximumSubscriberMultiplicity(AttributePojo<Integer> maximumSubscriberMultiplicity) {
        this.maximumSubscriberMultiplicity = maximumSubscriberMultiplicity;
    }

    public void setMaximumSubscriberMultiplicity(Integer maximumSubscriberMultiplicity) {
        this.maximumSubscriberMultiplicity = AttributePojo.valueOf((Long)this.maximumSubscriberMultiplicity.getId(), (AttributeTypeToken)this.maximumSubscriberMultiplicity.getTypeId(), (GammaId)this.maximumSubscriberMultiplicity.getGammaId(), (Object)maximumSubscriberMultiplicity, (String)this.maximumSubscriberMultiplicity.getDisplayableString());
    }

    public AttributePojo<Integer> getMinimumPublisherMultiplicity() {
        return this.minimumPublisherMultiplicity;
    }

    @JsonProperty
    public void setMinimumPublisherMultiplicity(AttributePojo<Integer> minimumPublisherMultiplicity) {
        this.minimumPublisherMultiplicity = minimumPublisherMultiplicity;
    }

    public void setMinimumPublisherMultiplicity(Integer minimumPublisherMultiplicity) {
        this.minimumPublisherMultiplicity = AttributePojo.valueOf((Long)this.minimumPublisherMultiplicity.getId(), (AttributeTypeToken)this.minimumPublisherMultiplicity.getTypeId(), (GammaId)this.minimumPublisherMultiplicity.getGammaId(), (Object)minimumPublisherMultiplicity, (String)this.minimumPublisherMultiplicity.getDisplayableString());
    }

    public AttributePojo<Integer> getMaximumPublisherMultiplicity() {
        return this.maximumPublisherMultiplicity;
    }

    @JsonProperty
    public void setMaximumPublisherMultiplicity(AttributePojo<Integer> maximumPublisherMultiplicity) {
        this.maximumPublisherMultiplicity = maximumPublisherMultiplicity;
    }

    public void setMaximumPublisherMultiplicity(Integer maximumPublisherMultiplicity) {
        this.maximumPublisherMultiplicity = AttributePojo.valueOf((Long)this.maximumPublisherMultiplicity.getId(), (AttributeTypeToken)this.maximumPublisherMultiplicity.getTypeId(), (GammaId)this.maximumPublisherMultiplicity.getGammaId(), (Object)maximumPublisherMultiplicity, (String)this.maximumPublisherMultiplicity.getDisplayableString());
    }

    public AttributePojo<List<String>> getInterfaceLevelsToUse() {
        return this.interfaceLevelsToUse;
    }

    @JsonProperty
    public void setInterfaceLevelsToUse(AttributePojo<List<String>> interfaceLevelsToUse) {
        this.interfaceLevelsToUse = interfaceLevelsToUse;
    }

    public AttributePojo<List<String>> getAvailableMessageHeaders() {
        return this.availableMessageHeaders;
    }

    @JsonProperty
    public void setAvailableMessageHeaders(AttributePojo<List<String>> availableMessageHeaders) {
        this.availableMessageHeaders = availableMessageHeaders;
    }

    public AttributePojo<List<String>> getAvailableSubmessageHeaders() {
        return this.availableSubmessageHeaders;
    }

    @JsonProperty
    public void setAvailableSubmessageHeaders(AttributePojo<List<String>> availableSubmessageHeaders) {
        this.availableSubmessageHeaders = availableSubmessageHeaders;
    }

    public AttributePojo<List<String>> getAvailableStructureHeaders() {
        return this.availableStructureHeaders;
    }

    @JsonProperty
    public void setAvailableStructureHeaders(AttributePojo<List<String>> availableStructureHeaders) {
        this.availableStructureHeaders = availableStructureHeaders;
    }

    public AttributePojo<List<String>> getAvailableElementHeaders() {
        return this.availableElementHeaders;
    }

    @JsonProperty
    public void setAvailableElementHeaders(AttributePojo<List<String>> availableElementHeaders) {
        this.availableElementHeaders = availableElementHeaders;
    }

    public boolean isDirectConnection() {
        return (Integer)this.getMinimumPublisherMultiplicity().getValue() == 1 && (Integer)this.getMaximumPublisherMultiplicity().getValue() == 1 && (Integer)this.getMinimumSubscriberMultiplicity().getValue() == 1 && (Integer)this.getMaximumSubscriberMultiplicity().getValue() == 1;
    }

    @JsonIgnore
    private List<String> getJSONContents(String jsonToParse) {
        String innerString = jsonToParse.substring(jsonToParse.indexOf("[") + 1, jsonToParse.indexOf("]"));
        List<String> innerStrings = Arrays.asList(innerString.split(","));
        return innerStrings.stream().filter(s -> !s.isEmpty()).map(s -> s.replaceAll("'", "")).collect(Collectors.toList());
    }

    public AttributePojo<Boolean> getDashedPresentation() {
        return this.isDashed;
    }

    @JsonProperty
    public void setDashedPresentation(AttributePojo<Boolean> isDashed) {
        this.isDashed = isDashed;
    }

    public AttributePojo<Boolean> getSpareAutoNumbering() {
        return this.spareAutoNumbering;
    }

    @JsonProperty
    public void setSpareAutoNumbering(AttributePojo<Boolean> spareAutoNumbering) {
        this.spareAutoNumbering = spareAutoNumbering;
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }

    public CreateArtifact createArtifact(String key, ApplicabilityId applicId) {
        Attribute attr;
        HashMap<Object, String> values = new HashMap<Object, String>();
        values.put(CoreAttributeTypes.ByteAlignValidation, Boolean.toString((Boolean)this.getByteAlignValidation().getValue()));
        values.put(CoreAttributeTypes.ByteAlignValidationSize, Integer.toString((Integer)this.getByteAlignValidationSize().getValue()));
        values.put(CoreAttributeTypes.MessageGeneration, Boolean.toString((Boolean)this.getMessageGeneration().getValue()));
        values.put(CoreAttributeTypes.MessageGenerationType, (String)this.getMessageGenerationType().getValue());
        values.put(CoreAttributeTypes.MinimumSubscriberMultiplicity, Integer.toString((Integer)this.getMinimumPublisherMultiplicity().getValue()));
        values.put(CoreAttributeTypes.MaximumSubscriberMultiplicity, Integer.toString((Integer)this.getMaximumSubscriberMultiplicity().getValue()));
        values.put(CoreAttributeTypes.MinimumPublisherMultiplicity, Integer.toString((Integer)this.getMinimumPublisherMultiplicity().getValue()));
        values.put(CoreAttributeTypes.MaximumPublisherMultiplicity, Integer.toString((Integer)this.getMaximumPublisherMultiplicity().getValue()));
        values.put(CoreAttributeTypes.DashedPresentation, Boolean.toString((Boolean)this.getDashedPresentation().getValue()));
        values.put(CoreAttributeTypes.SpareAutoNumbering, Boolean.toString((Boolean)this.getSpareAutoNumbering().getValue()));
        CreateArtifact art = new CreateArtifact();
        art.setName((String)this.getName().getValue());
        art.setTypeId(CoreArtifactTypes.TransportType.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.TransportType.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr2 = new Attribute(type.getIdString());
            attr2.setValue(Arrays.asList(value));
            attrs.add(attr2);
        }
        if (((List)this.getInterfaceLevelsToUse().getValue()).size() > 0) {
            attr = new Attribute(CoreAttributeTypes.InterfaceLevelsToUse.getIdString());
            attr.setValue((List)this.getInterfaceLevelsToUse().getValue());
            attrs.add(attr);
        }
        if (((List)this.getAvailableMessageHeaders().getValue()).size() > 0) {
            attr = new Attribute(CoreAttributeTypes.AvailableMessageHeaders.getIdString());
            attr.setValue((List)this.getAvailableMessageHeaders().getValue());
            attrs.add(attr);
        }
        if (((List)this.getAvailableSubmessageHeaders().getValue()).size() > 0) {
            attr = new Attribute(CoreAttributeTypes.AvailableSubmessageHeaders.getIdString());
            attr.setValue((List)this.getAvailableSubmessageHeaders().getValue());
            attrs.add(attr);
        }
        if (((List)this.getAvailableStructureHeaders().getValue()).size() > 0) {
            attr = new Attribute(CoreAttributeTypes.AvailableStructureHeaders.getIdString());
            attr.setValue((List)this.getAvailableStructureHeaders().getValue());
            attrs.add(attr);
        }
        if (((List)this.getAvailableElementHeaders().getValue()).size() > 0) {
            attr = new Attribute(CoreAttributeTypes.AvailableElementHeaders.getIdString());
            attr.setValue((List)this.getAvailableElementHeaders().getValue());
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setApplicabilityId(applicId.getIdString());
        art.setkey(key);
        return art;
    }
}

