/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.io.excel.ExcelWorkbookReader;
import org.eclipse.osee.framework.jdk.core.util.io.excel.ExcelWorkbookWriter;
import org.eclipse.osee.mim.MimApi;
import org.eclipse.osee.mim.MimImportApi;
import org.eclipse.osee.mim.types.IcdElementIndex;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.mim.types.InterfaceEnumOrdinalType;
import org.eclipse.osee.mim.types.InterfaceEnumeration;
import org.eclipse.osee.mim.types.InterfaceEnumerationSet;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;
import org.eclipse.osee.mim.types.MimImportSummary;
import org.eclipse.osee.mim.types.PlatformTypeToken;
import org.eclipse.osee.mim.types.TransportType;
import org.eclipse.osee.orcs.core.ds.FollowRelation;

public class IcdImportApiImpl
implements MimImportApi {
    private final ExcelWorkbookReader reader;
    private final MimApi mimApi;
    private final BranchId branch;
    private final ArtifactId transportTypeId;
    private MimImportSummary summary;
    private Long id = 1L;

    public IcdImportApiImpl(BranchId branch, ArtifactId transportTypeId, String fileName, InputStream inputStream, MimApi mimApi) {
        this.reader = new ExcelWorkbookReader(inputStream, fileName != null && fileName.toLowerCase().endsWith("xls") ? ExcelWorkbookWriter.WorkbookFormat.XLS : ExcelWorkbookWriter.WorkbookFormat.XLSX);
        this.mimApi = mimApi;
        this.branch = branch;
        this.transportTypeId = transportTypeId == null ? ArtifactId.SENTINEL : transportTypeId;
    }

    @Override
    public MimImportSummary getSummary() {
        int end;
        int start;
        String[] split;
        TransportType transportType;
        InterfaceNode secondaryNode;
        InterfaceNode primaryNode;
        this.summary = new MimImportSummary();
        this.reader.setActiveSheet("Message and Submessage Summary");
        String primaryNodeName = this.reader.getCellStringValue(0, 0).split(" Initiated Message")[0];
        String secondaryNodeName = this.reader.getCellStringValue(0, 5).split(" Initiated Message")[0];
        List existingNodes = (List)this.mimApi.getInterfaceNodeViewApi().getAll(this.branch);
        InterfaceNode existingPrimaryNode = existingNodes.stream().filter(node -> ((String)node.getName().getValue()).equals(primaryNodeName)).findFirst().orElse(InterfaceNode.SENTINEL);
        InterfaceNode existingSecondaryNode = existingNodes.stream().filter(node -> ((String)node.getName().getValue()).equals(secondaryNodeName)).findFirst().orElse(InterfaceNode.SENTINEL);
        if (existingPrimaryNode.isValid()) {
            primaryNode = existingPrimaryNode;
        } else {
            primaryNode = new InterfaceNode(this.id, primaryNodeName);
            primaryNode.setApplicability(ApplicabilityToken.BASE);
            primaryNode.setInterfaceNodeAddress("");
            primaryNode.setInterfaceNodeBackgroundColor("");
            primaryNode.setDescription("");
            this.incrementId();
            this.summary.getNodes().add(primaryNode);
        }
        if (existingSecondaryNode.isValid()) {
            secondaryNode = existingSecondaryNode;
        } else {
            secondaryNode = new InterfaceNode(this.id, secondaryNodeName);
            secondaryNode.setApplicability(ApplicabilityToken.BASE);
            secondaryNode.setInterfaceNodeAddress("");
            secondaryNode.setInterfaceNodeBackgroundColor("");
            secondaryNode.setDescription("");
            this.incrementId();
            this.summary.getNodes().add(secondaryNode);
        }
        InterfaceConnection connection = this.mimApi.getInterfaceConnectionViewApi().getAll(this.branch).stream().filter(c -> c.getNodes().stream().filter(n -> n.getId().equals(existingPrimaryNode.getId())).findAny().isPresent() && c.getNodes().stream().filter(n -> n.getId().equals(existingSecondaryNode.getId())).findAny().isPresent()).findFirst().orElse(InterfaceConnection.SENTINEL);
        if (!connection.isValid()) {
            connection = new InterfaceConnection(this.id, String.valueOf(primaryNodeName) + "_" + secondaryNodeName);
            this.incrementId();
            connection.setApplicability(ApplicabilityToken.BASE);
            connection.getNodes().add(primaryNode);
            connection.getNodes().add(secondaryNode);
            this.summary.getConnections().add(connection);
            List rels = this.summary.getConnectionNodeRelations().getOrDefault(connection.getIdString(), new LinkedList());
            rels.add(primaryNode.getIdString());
            rels.add(secondaryNode.getIdString());
            this.summary.getConnectionNodeRelations().put(connection.getIdString(), rels);
        }
        if ((transportType = this.mimApi.getTransportTypeApi().get(this.branch, this.transportTypeId)).isInvalid()) {
            this.summary.getErrors().add("Invalid Transport Type ID");
            return this.summary;
        }
        List rels = this.summary.getConnectionTransportTypeRelations().getOrDefault(connection.getIdString(), new LinkedList());
        rels.add(transportType.getIdString());
        this.summary.getConnectionTransportTypeRelations().put(connection.getIdString(), rels);
        List primaryRegions = this.reader.getMergedRegions().stream().filter(r -> r.split(":")[0].charAt(0) == 'A' && r.split(":")[1].charAt(0) == 'A').collect(Collectors.toList());
        List secondaryRegions = this.reader.getMergedRegions().stream().filter(r -> r.split(":")[0].charAt(0) == 'F' && r.split(":")[1].charAt(0) == 'F').collect(Collectors.toList());
        HashMap<String, Long> submessageIds = new HashMap<String, Long>();
        for (String region : primaryRegions) {
            split = region.split(":");
            start = Integer.parseInt(split[0].substring(1)) - 1;
            end = Integer.parseInt(split[1].substring(1)) - 1;
            this.readMessage(primaryNode, secondaryNode, start, end, 0, submessageIds);
        }
        for (String region : secondaryRegions) {
            split = region.split(":");
            start = Integer.parseInt(split[0].substring(1)) - 1;
            end = Integer.parseInt(split[1].substring(1)) - 1;
            this.readMessage(secondaryNode, primaryNode, start, end, 5, submessageIds);
        }
        this.reader.setActiveSheet("Structure Summary");
        LinkedList<String> structureSheetNames = new LinkedList<String>();
        int rowIndex = 1;
        while (this.reader.rowExists(rowIndex)) {
            String nameFormula = this.reader.getCellHyperlinkString(rowIndex, 1);
            String sheetName = nameFormula.split("!")[0].replace("'", "");
            if (!sheetName.contains(" Header")) {
                structureSheetNames.add(sheetName);
            }
            ++rowIndex;
        }
        List<PlatformTypeToken> existingPlatformTypes = this.mimApi.getInterfacePlatformTypeApi().getAllWithRelations(this.branch, FollowRelation.followList((RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.InterfacePlatformTypeEnumeration_EnumerationSet, CoreRelationTypes.InterfaceEnumeration_EnumerationState}));
        HashMap<String, InterfaceStructureElementToken> elements = new HashMap<String, InterfaceStructureElementToken>();
        HashMap<String, PlatformTypeToken> platformTypes = new HashMap<String, PlatformTypeToken>();
        LinkedList<PlatformTypeToken> platformTypesToCreate = new LinkedList<PlatformTypeToken>();
        HashMap<String, InterfaceEnumerationSet> enumsToUpdate = new HashMap<String, InterfaceEnumerationSet>();
        for (PlatformTypeToken type : existingPlatformTypes) {
            String typeKey = ((String)type.getInterfaceLogicalType().getValue()).equals("enumeration") ? this.getEnumSetKey(type.getEnumSet()) : this.mimApi.getInterfacePlatformTypeApi().getUniqueIdentifier((String)type.getInterfaceLogicalType().getValue(), (String)type.getInterfacePlatformTypeMinval().getValue(), (String)type.getInterfacePlatformTypeMaxval().getValue(), (String)type.getInterfacePlatformTypeValidRangeDescription().getValue(), (String)type.getInterfacePlatformTypeUnits().getValue(), (String)type.getInterfaceDefaultValue().getValue(), Integer.parseInt((String)type.getInterfacePlatformTypeBitSize().getValue()) / 8);
            platformTypes.put(typeKey, type);
        }
        if (!platformTypes.containsKey("boolean")) {
            PlatformTypeToken boolToken = new PlatformTypeToken(this.id, "Boolean", "boolean", "8", "0", "1", "", "", "", "0 to 1");
            platformTypes.put("boolean", boolToken);
            this.incrementId();
            platformTypesToCreate.add(boolToken);
        }
        for (String sheetName : structureSheetNames) {
            this.reader.setActiveSheet(sheetName);
            InterfaceStructureToken structure = this.readStructure(primaryNode, secondaryNode, submessageIds);
            this.readStructureElements(structure, elements, platformTypes, platformTypesToCreate, enumsToUpdate, String.valueOf(primaryNodeName) + "_" + secondaryNodeName);
        }
        for (PlatformTypeToken pTypeToken : platformTypesToCreate) {
            this.summary.getPlatformTypes().add(pTypeToken);
        }
        Collections.sort(this.summary.getMessages(), new Comparator<InterfaceMessageToken>(){

            @Override
            public int compare(InterfaceMessageToken o1, InterfaceMessageToken o2) {
                if (((String)o1.getPublisherNodes().get(0).getName().getValue()).equals(o2.getPublisherNodes().get(0).getName().getValue())) {
                    boolean isO1Numeric = IcdImportApiImpl.this.isStringNumeric((String)o1.getInterfaceMessageNumber().getValue());
                    boolean isO2Numeric = IcdImportApiImpl.this.isStringNumeric((String)o2.getInterfaceMessageNumber().getValue());
                    if (isO1Numeric && isO2Numeric) {
                        return (int)Double.parseDouble((String)o1.getInterfaceMessageNumber().getValue()) > (int)Double.parseDouble((String)o2.getInterfaceMessageNumber().getValue()) ? 1 : -1;
                    }
                    if (!isO1Numeric && !isO2Numeric) {
                        return ((String)o1.getInterfaceMessageNumber().getValue()).compareTo((String)o2.getInterfaceMessageNumber().getValue());
                    }
                    return isO2Numeric ? 1 : -1;
                }
                if (((String)o1.getPublisherNodes().get(0).getName().getValue()).equals(primaryNode.getName().getValue())) {
                    return -1;
                }
                return 1;
            }
        });
        List connectionRels = this.summary.getConnectionMessageRelations().getOrDefault(connection.getIdString(), new LinkedList());
        for (InterfaceMessageToken message : this.summary.getMessages()) {
            connectionRels.add(message.getIdString());
            this.summary.getConnectionMessageRelations().put(connection.getIdString(), connectionRels);
        }
        this.reader.closeWorkbook();
        return this.summary;
    }

    private void readMessage(InterfaceNode pubNode, InterfaceNode subNode, int firstRow, int lastRow, int colOffset, Map<String, Long> subMessageIdMap) {
        String messageNumber = this.reader.getCellStringValue(firstRow, 0 + colOffset);
        String rate = this.reader.getCellStringValue(firstRow, 1 + colOffset);
        String write = this.reader.getCellStringValue(firstRow, 2 + colOffset);
        String name = this.reader.getCellStringValue(firstRow, 3 + colOffset);
        if (messageNumber.equals("0")) {
            return;
        }
        String periodicity = rate.equals("Aperiodic") ? rate : "Periodic";
        rate = rate.equals("Aperiodic") ? "1" : rate.split(" ")[0];
        InterfaceMessageToken message = new InterfaceMessageToken(this.id, name);
        message.setInterfaceMessageNumber(messageNumber);
        message.setInterfaceMessageRate(rate);
        message.setInterfaceMessagePeriodicity(periodicity);
        message.setInterfaceMessageWriteAccess(write.equals("W"));
        message.setApplicability(ApplicabilityToken.BASE);
        message.getPublisherNodes().add(pubNode);
        message.getSubscriberNodes().add(subNode);
        message.setInterfaceMessageType("Operational");
        message.setDescription("");
        this.incrementId();
        List pubRels = this.summary.getMessagePublisherNodeRelations().getOrDefault(message.getIdString(), new LinkedList());
        pubRels.add(pubNode.getIdString());
        this.summary.getMessagePublisherNodeRelations().put(message.getIdString(), pubRels);
        List subRels = this.summary.getMessageSubscriberNodeRelations().getOrDefault(message.getIdString(), new LinkedList());
        subRels.add(subNode.getIdString());
        this.summary.getMessageSubscriberNodeRelations().put(message.getIdString(), subRels);
        LinkedList<String> subMessageIds = new LinkedList<String>();
        int subMsgNum = 1;
        int i = firstRow + 2;
        while (i <= lastRow) {
            String label = this.reader.getCellStringValue(i, 3 + colOffset);
            if (label == null || !label.contains("Submessage")) break;
            String subMessageName = this.reader.getCellStringValue(i, 4 + colOffset);
            InterfaceSubMessageToken subMessage = new InterfaceSubMessageToken(this.id, subMessageName);
            subMessage.setApplicability(ApplicabilityToken.BASE);
            subMessage.setInterfaceSubMessageNumber("" + subMsgNum);
            subMessage.setDescription("");
            subMessageIds.add("" + this.id);
            subMessageIdMap.put(this.getSubMessageMapKey(String.valueOf(messageNumber), String.valueOf(subMsgNum), (String)pubNode.getName().getValue()), this.id);
            this.incrementId();
            this.summary.getSubMessages().add(subMessage);
            ++subMsgNum;
            ++i;
        }
        this.summary.getMessageSubmessageRelations().put(message.getIdString(), subMessageIds);
        this.summary.getMessages().add(message);
    }

    private InterfaceStructureToken readStructure(InterfaceNode primaryNode, InterfaceNode secondaryNode, Map<String, Long> subMessageIdMap) {
        int taskFile;
        int structureRow = 1;
        String name = this.reader.getCellStringValue(structureRow, 1);
        String nameAbbrev = this.reader.getCellStringValue(structureRow, 2);
        String category = this.reader.getCellStringValue(structureRow, 4);
        String txRate = this.reader.getCellValue(structureRow, 5).toString();
        String minSim = this.reader.getCellValue(structureRow, 6).toString();
        String maxSim = this.reader.getCellValue(structureRow, 7).toString();
        String nodeName = this.reader.getCellStringValue(structureRow, 10);
        String msgNum = this.reader.getCellStringValue(structureRow, 11);
        String subMsgNum = this.reader.getCellValue(structureRow, 12).toString();
        String taskfileType = this.reader.getCellValue(structureRow, 13).toString();
        String description = this.reader.getCellStringValue(structureRow, 14);
        InterfaceStructureToken structure = new InterfaceStructureToken(this.id, name);
        this.incrementId();
        structure.setApplicability(ApplicabilityToken.BASE);
        structure.setInterfaceStructureCategory(category);
        structure.setInterfaceMinSimultaneity(this.toIntString(minSim));
        structure.setInterfaceMaxSimultaneity(this.toIntString(maxSim));
        structure.setDescription(description);
        structure.setNameAbbrev(!name.equals(nameAbbrev) ? nameAbbrev : "");
        msgNum = this.isStringNumeric(msgNum) ? String.valueOf((int)Double.parseDouble(msgNum)) : msgNum;
        subMsgNum = subMsgNum.equals("n/a") ? "0" : subMsgNum;
        subMsgNum = this.isStringNumeric(subMsgNum) ? String.valueOf((int)Double.parseDouble(subMsgNum)) : subMsgNum;
        try {
            taskFile = Integer.parseInt(taskfileType);
        }
        catch (NumberFormatException numberFormatException) {
            taskFile = 0;
        }
        structure.setInterfaceTaskFileType(taskFile);
        InterfaceMessageToken message = InterfaceMessageToken.SENTINEL;
        for (InterfaceMessageToken msg : this.summary.getMessages()) {
            if (!((String)msg.getInterfaceMessageNumber().getValue()).equals(String.valueOf(msgNum)) || msg.getPublisherNodes().size() <= 0 || !((String)msg.getPublisherNodes().get(0).getName().getValue()).equals(nodeName)) continue;
            message = msg;
            break;
        }
        if (!message.isValid()) {
            InterfaceNode pubNode = ((String)primaryNode.getName().getValue()).equals(nodeName) ? primaryNode : secondaryNode;
            InterfaceNode subNode = pubNode.equals((Object)primaryNode) ? secondaryNode : primaryNode;
            message = new InterfaceMessageToken(this.id, "Message " + msgNum);
            message.setInterfaceMessageNumber(msgNum);
            message.setInterfaceMessageWriteAccess(false);
            message.setApplicability(ApplicabilityToken.BASE);
            message.getPublisherNodes().add(pubNode);
            message.getSubscriberNodes().add(subNode);
            message.setInterfaceMessageType("Connection");
            message.setDescription("");
            this.incrementId();
            this.summary.getMessages().add(message);
            List pubRels = this.summary.getMessagePublisherNodeRelations().getOrDefault(message.getIdString(), new LinkedList());
            pubRels.add(pubNode.getIdString());
            this.summary.getMessagePublisherNodeRelations().put(message.getIdString(), pubRels);
            List subRels = this.summary.getMessageSubscriberNodeRelations().getOrDefault(message.getIdString(), new LinkedList());
            subRels.add(subNode.getIdString());
            this.summary.getMessageSubscriberNodeRelations().put(message.getIdString(), subRels);
        }
        String[] txRateSplit = txRate.split("-");
        String txRateInt = txRateSplit[0].split("[.]")[0];
        String periodicity = txRateSplit.length == 2 && txRateSplit[1].equals("A") ? "Aperiodic" : "Periodic";
        message.setInterfaceMessageRate(txRateInt);
        message.setInterfaceMessagePeriodicity(periodicity);
        String subMsgKey = this.getSubMessageMapKey(msgNum, subMsgNum, nodeName);
        if (!subMessageIdMap.containsKey(subMsgKey)) {
            InterfaceSubMessageToken subMessage = new InterfaceSubMessageToken(this.id, "SubMessage " + subMsgNum);
            this.incrementId();
            subMessage.setInterfaceSubMessageNumber(String.valueOf(subMsgNum));
            subMessage.setApplicability(ApplicabilityToken.BASE);
            subMessage.setDescription("");
            this.summary.getSubMessages().add(subMessage);
            List msgRels = this.summary.getMessageSubmessageRelations().getOrDefault(message.getIdString(), new LinkedList());
            msgRels.add(subMessage.getIdString());
            this.summary.getMessageSubmessageRelations().put(message.getIdString(), msgRels);
            subMessageIdMap.put(this.getSubMessageMapKey(msgNum, subMsgNum, nodeName), subMessage.getId());
        }
        Long subMsgId = subMessageIdMap.get(subMsgKey);
        List rels = this.summary.getSubMessageStructureRelations().getOrDefault(subMsgId.toString(), new LinkedList());
        rels.add(structure.getIdString());
        this.summary.getSubMessageStructureRelations().put(subMsgId.toString(), rels);
        this.summary.getStructures().add(structure);
        return structure;
    }

    private void readStructureElements(InterfaceStructureToken structure, Map<String, InterfaceStructureElementToken> elements, Map<String, PlatformTypeToken> platformTypes, List<PlatformTypeToken> platformTypesToCreate, Map<String, InterfaceEnumerationSet> enumsToUpdate, String connectionName) {
        Boolean hasDefaultValue = this.reader.getCellStringValue(3, 18).equals("Default Value");
        int rowIndex = 4;
        InterfaceStructureElementToken previousElement = InterfaceStructureElementToken.SENTINEL;
        PlatformTypeToken previousPType = PlatformTypeToken.SENTINEL;
        while (this.reader.rowExists(rowIndex)) {
            boolean possibleArray;
            int numBytes = (int)this.reader.getCellNumericValue(rowIndex, IcdElementIndex.byteSize.ordinal());
            String logicalType = this.reader.getCellStringValue(rowIndex, IcdElementIndex.dataType.ordinal()).trim();
            String name = this.reader.getCellStringValue(rowIndex, IcdElementIndex.name.ordinal()).trim();
            String units = this.reader.getCellStringValue(rowIndex, IcdElementIndex.units.ordinal()).trim();
            String validRange = this.reader.getCellStringValue(rowIndex, IcdElementIndex.validRange.ordinal());
            boolean alterable = this.reader.getCellStringValue(rowIndex, IcdElementIndex.alterable.ordinal()).equals("Yes");
            String description = this.reader.getCellStringValue(rowIndex, IcdElementIndex.description.ordinal());
            String enumDesc = this.reader.getCellStringValue(rowIndex, IcdElementIndex.enumLiterals.ordinal());
            String notes = this.reader.getCellStringValue(rowIndex, IcdElementIndex.notes.ordinal());
            String defaultValue = this.reader.getCellStringValue(rowIndex, IcdElementIndex.defaultValue.ordinal());
            if (hasDefaultValue.booleanValue()) {
                defaultValue = this.reader.getCellStringValue(rowIndex, 18);
            }
            if (name.isEmpty() && logicalType.toLowerCase().contains("instrumentation message")) {
                name = (String)structure.getName().getValue();
            }
            PlatformTypeToken pType = PlatformTypeToken.SENTINEL;
            if (logicalType.equals("boolean")) {
                pType = platformTypes.get("boolean");
            } else if (logicalType.equals("enumeration")) {
                String pTypeKey;
                String enumName = enumDesc.split("\n")[0].split(":")[0].replaceAll("[()]", "").trim();
                enumName = name.equals("Taskfile Type") ? (((String)structure.getName().getValue()).toLowerCase().contains("command taskfile") ? "Command Taskfile" : "Status Taskfile") : enumName;
                enumName = enumName.isEmpty() || enumName.split("[-=]").length > 1 && enumName.split("[-=]")[0].matches("^\\d+\\s*") ? name : enumName;
                InterfaceEnumerationSet enumSet = new InterfaceEnumerationSet(this.id, enumName);
                this.incrementId();
                enumSet.setApplicability(ApplicabilityToken.BASE);
                if (!enumName.matches("^C\\d+$")) {
                    String enumSetDescription = "";
                    String[] stringArray = enumDesc.split("\n");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        if (line.trim().matches("^\\s*\\d+\\s*[-=].*") || line.trim().matches("^0x.*\\s*[-=].*")) {
                            String[] splitLine = line.trim().split("\\s*[-=]\\s*", 2);
                            InterfaceEnumeration enumeration = new InterfaceEnumeration(this.id, splitLine[1].split("//")[0].trim());
                            this.incrementId();
                            long ordinal = splitLine[0].matches("^0x.*") ? Long.decode(splitLine[0].trim()) : Long.parseLong(splitLine[0]);
                            InterfaceEnumOrdinalType ordinalType = splitLine[0].matches("^0x.*") ? InterfaceEnumOrdinalType.HEX : InterfaceEnumOrdinalType.LONG;
                            enumeration.setApplicability(ApplicabilityToken.BASE);
                            enumeration.setOrdinal(ordinal);
                            enumeration.setOrdinalType(ordinalType);
                            enumSetDescription = String.valueOf(enumSetDescription) + enumeration.toString() + "\n";
                            enumSet.getEnumerations().add(enumeration);
                        }
                        ++n2;
                    }
                    enumSet.setDescription(enumSetDescription.trim());
                }
                pTypeKey = (pTypeKey = this.getEnumSetKey(enumSet)).isEmpty() ? enumName : pTypeKey;
                boolean create = false;
                if (enumsToUpdate.containsKey(enumName) && enumSet.getEnumerations().size() > 0) {
                    InterfaceEnumerationSet setToUpdate = enumsToUpdate.get(enumName);
                    pType = platformTypes.get(this.getEnumSetKey(setToUpdate));
                    platformTypes.remove(this.getEnumSetKey(setToUpdate));
                    setToUpdate.setEnumerations(enumSet.getEnumerations());
                    platformTypes.put(this.getEnumSetKey(setToUpdate), pType);
                    enumsToUpdate.remove(enumName);
                    for (InterfaceEnumeration enumeration : enumSet.getEnumerations()) {
                        this.summary.getEnums().add(enumeration);
                        List rels = this.summary.getEnumSetEnumRelations().getOrDefault(enumSet.getIdString(), new LinkedList());
                        rels.add(enumeration.getIdString());
                        this.summary.getEnumSetEnumRelations().put(enumSet.getIdString(), rels);
                    }
                } else if (platformTypes.containsKey(pTypeKey)) {
                    pType = platformTypes.get(pTypeKey);
                } else if (enumSet.getEnumerations().isEmpty()) {
                    pType = platformTypesToCreate.stream().filter(e -> e.getEnumSet() != null).filter(e -> e.getEnumSet().getName().equals((Object)enumSet.getName())).findFirst().orElse(PlatformTypeToken.SENTINEL);
                    if (!pType.isValid() && !(pType = platformTypes.values().stream().filter(e -> e.getEnumSet() != null).filter(e -> e.getEnumSet().getName().equals((Object)enumSet.getName())).findFirst().orElse(PlatformTypeToken.SENTINEL)).isValid()) {
                        create = true;
                        enumsToUpdate.put((String)enumSet.getName().getValue(), enumSet);
                    }
                } else {
                    create = true;
                }
                if (create) {
                    String pTypeName;
                    String n = pTypeName = enumName;
                    if (platformTypes.values().stream().filter(t -> ((String)t.getName().getValue()).equals(n)).findFirst().orElse(PlatformTypeToken.SENTINEL).isValid()) {
                        pTypeName = String.valueOf(pTypeName) + " (" + connectionName + ")";
                    }
                    pType = new PlatformTypeToken(this.id, pTypeName, logicalType, String.valueOf(numBytes * 8), "", "", units, "", defaultValue, validRange);
                    pType.setEnumSet(enumSet);
                    this.incrementId();
                    platformTypes.put(pTypeKey, pType);
                    platformTypesToCreate.add(pType);
                    this.summary.getEnumSets().add(enumSet);
                    this.summary.getPlatformTypeEnumSetRelations().put(pType.getIdString(), new LinkedList<String>(Arrays.asList(enumSet.getIdString())));
                    for (InterfaceEnumeration enumeration : enumSet.getEnumerations()) {
                        this.summary.getEnums().add(enumeration);
                        List rels = this.summary.getEnumSetEnumRelations().getOrDefault(enumSet.getIdString(), new LinkedList());
                        rels.add(enumeration.getIdString());
                        this.summary.getEnumSetEnumRelations().put(enumSet.getIdString(), rels);
                    }
                }
            } else {
                units = units.contains("n/a") ? "" : units;
                validRange = validRange.contains("n/a") ? "" : validRange;
                String minVal = "";
                String maxVal = "";
                String[] range = validRange.replace("--", "").replace("---", "").split(" to ");
                if (range.length == 1 && range[0].split(" ").length == 1) {
                    minVal = range[0].trim();
                    maxVal = range[0].trim();
                    validRange = range[0].trim();
                } else if (range.length == 2) {
                    minVal = range[0].trim();
                    maxVal = range[1].trim();
                    validRange = String.valueOf(range[0]) + " to " + range[1];
                }
                String pTypeName = this.mimApi.getInterfacePlatformTypeApi().getUniqueIdentifier(logicalType, minVal, maxVal, validRange, units, defaultValue, numBytes);
                if (platformTypes.containsKey(pTypeName)) {
                    pType = platformTypes.get(pTypeName);
                } else {
                    pType = new PlatformTypeToken(this.id, pTypeName, logicalType, String.valueOf(numBytes * 8), minVal, maxVal, units, "", defaultValue, validRange);
                    this.incrementId();
                    platformTypes.put(pTypeName, pType);
                    platformTypesToCreate.add(pType);
                }
            }
            String elementKey = this.getElementKey(name, alterable, description, notes, pType.getId());
            InterfaceStructureElementToken element = InterfaceStructureElementToken.SENTINEL;
            boolean relateElement = true;
            boolean bl = possibleArray = name.matches(".*\\s\\d+$") && !name.matches(".*\\s(and)\\s\\d+$");
            if (!possibleArray && elements.containsKey(elementKey)) {
                previousElement = element = elements.get(elementKey);
                previousPType = pType;
            } else if (possibleArray && name.matches(".*\\s\\d+$") && !name.matches(".*\\s(and)\\s\\d+$") && previousElement.isValid() && previousPType.isValid() && this.compareElementsForArray((String)previousElement.getName().getValue(), name, previousPType.getId(), pType.getId())) {
                String[] nameSplit = name.split(" ");
                int arrayNum = Integer.parseInt(nameSplit[nameSplit.length - 1]);
                if ((Integer)previousElement.getInterfaceElementIndexStart().getValue() == 0) {
                    String[] prevNameSplit = ((String)previousElement.getName().getValue()).split(" ");
                    int prevArrayNum = Integer.parseInt(prevNameSplit[prevNameSplit.length - 1]);
                    previousElement.setInterfaceElementIndexStart(prevArrayNum);
                }
                previousElement.setInterfaceElementIndexEnd(arrayNum);
                relateElement = false;
                if (this.reader.rowExists(rowIndex + 1) && this.reader.getCellValue(rowIndex + 1, 0) != null && !this.reader.getCellValue(rowIndex + 1, 0).toString().isEmpty()) {
                    String nextName = this.reader.getCellStringValue(rowIndex + 1, 11).trim();
                    if (!nextName.split("\\s\\d+$")[0].trim().equals(name.split("\\s\\d+$")[0].trim())) {
                        previousElement.setName(((String)previousElement.getName().getValue()).split("\\s\\d+$")[0].trim());
                    }
                } else if (((String)previousElement.getName().getValue()).matches(".*\\s\\d+$")) {
                    previousElement.setName(((String)previousElement.getName().getValue()).split("\\s\\d+$")[0].trim());
                }
            } else {
                element = new InterfaceStructureElementToken(this.id, name);
                this.incrementId();
                element.setInterfaceElementAlterable(alterable);
                element.setDescription(description);
                element.setNotes(notes);
                element.setInterfaceDefaultValue(defaultValue);
                element.setEnumLiteral(logicalType.equals("enumeration") ? "" : enumDesc);
                elements.put(elementKey, element);
                this.summary.getElements().add(element);
                this.summary.getElementPlatformTypeRelations().put(element.getIdString(), new LinkedList<String>(Arrays.asList(pType.getIdString())));
                previousElement = element;
                previousPType = pType;
            }
            if (relateElement) {
                List rels = this.summary.getStructureElementRelations().getOrDefault(structure.getIdString(), new LinkedList());
                rels.add(element.getIdString());
                this.summary.getStructureElementRelations().put(structure.getIdString(), rels);
            }
            ++rowIndex;
        }
    }

    private String toIntString(String str) {
        String result = "";
        try {
            int val = (int)Double.parseDouble(str);
            result = String.valueOf(val);
        }
        catch (NumberFormatException numberFormatException) {
            result = str;
        }
        return result;
    }

    private boolean isStringNumeric(String input) {
        return input.matches("^(\\d+.)*\\d+$");
    }

    private String getEnumSetKey(InterfaceEnumerationSet enumSet) {
        String key = String.join((CharSequence)";", enumSet.getEnumerations().stream().map(e -> e.getOrdinal().getValue() + "=" + (String)e.getName().getValue()).collect(Collectors.toList()));
        return String.valueOf(((String)enumSet.getName().getValue()).toUpperCase().replace(" ", "_")) + "_" + key.hashCode();
    }

    private boolean compareElementsForArray(String name1, String name2, Long pTypeId1, Long pTypeId2) {
        String n2;
        String n1 = name1.split("\\s\\d+$")[0];
        return n1.equals(n2 = name2.split("\\s\\d+$")[0]) && pTypeId1 == pTypeId2;
    }

    private String getSubMessageMapKey(String messageNum, String subMessageNum, String nodeName) {
        return String.valueOf(nodeName) + messageNum + subMessageNum;
    }

    private String getElementKey(String name, boolean alterable, String description, String notes, Long pTypeId) {
        return String.valueOf(name) + "_" + alterable + "_" + description.hashCode() + "_" + notes.hashCode() + "_" + pTypeId;
    }

    private void incrementId() {
        this.id = this.id + 1L;
    }
}

