/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.GetAllMIMRelatedObjectsEndpoint;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.ResolvedStructurePath;
import org.eclipse.osee.mim.types.StructurePath;
import org.eclipse.osee.orcs.core.ds.FollowRelation;

public class GetAllMIMRelatedObjectsEndpointImpl
implements GetAllMIMRelatedObjectsEndpoint {
    private final BranchId branch;
    private final InterfaceStructureApi interfaceStructureApi;
    private final InterfaceElementApi elementApi;

    public GetAllMIMRelatedObjectsEndpointImpl(BranchId branch, InterfaceStructureApi interfaceStructureApi, InterfaceElementApi interfaceElementApi) {
        this.branch = branch;
        this.interfaceStructureApi = interfaceStructureApi;
        this.elementApi = interfaceElementApi;
    }

    @Override
    public Collection<StructurePath> getAllStructureNames(String filter, ArtifactId connectionId) {
        List structures = this.interfaceStructureApi.getAllWithRelations(this.branch, FollowRelation.followList((RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.InterfaceSubMessageContent_SubMessage, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, CoreRelationTypes.InterfaceConnectionMessage_Connection}), filter, Arrays.asList(CoreAttributeTypes.Name), (AttributeTypeId)CoreAttributeTypes.Name).stream().map(s -> new StructurePath((InterfaceStructureToken)((Object)s))).collect(Collectors.toList());
        LinkedList<StructurePath> connectionStructures = new LinkedList<StructurePath>();
        for (StructurePath structure : structures) {
            for (ArtifactReadable submessage : structure.getStructure().getArtifactReadable().getRelatedList(CoreRelationTypes.InterfaceSubMessageContent_SubMessage)) {
                for (ArtifactReadable message : submessage.getRelatedList(CoreRelationTypes.InterfaceMessageSubMessageContent_Message)) {
                    for (ArtifactReadable connection : message.getRelatedList(CoreRelationTypes.InterfaceConnectionMessage_Connection)) {
                        if (!connectionId.isInvalid() && !connectionId.equals(connection.getArtifactId())) continue;
                        structure.addPath(new ResolvedStructurePath(String.valueOf(message.getName()) + " > " + submessage.getName(), "/" + connection.getIdString() + "/messages/" + message.getIdString() + "/" + submessage.getIdString() + "/elements/" + structure.getIdString()));
                        connectionStructures.add(structure);
                    }
                }
            }
        }
        return connectionStructures;
    }

    @Override
    public Collection<InterfaceStructureElementToken> getElements() {
        return this.elementApi.getAll(this.branch);
    }
}

