/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.BranchId;

public class TxBuilderInput {
    private final String branch;
    private final String txComment;
    private final List<TxBuilderArtifact> createArtifacts;

    public TxBuilderInput(BranchId branch, List<ArtifactReadable> arts) {
        this.branch = branch.getIdString();
        this.txComment = "Create " + (arts.size() > 0 ? String.valueOf(arts.get(0).getArtifactType().getName()) + "s" : "artifacts");
        this.createArtifacts = arts.stream().map(art -> new TxBuilderArtifact((ArtifactReadable)art)).collect(Collectors.toList());
    }

    public String getBranch() {
        return this.branch;
    }

    public String getTxComment() {
        return this.txComment;
    }

    public List<TxBuilderArtifact> getCreateArtifacts() {
        return this.createArtifacts;
    }

    private class TxBuilderArtifact {
        private final String typeId;
        private final String name;
        private final List<TxBuilderAttribute> attributes;

        public TxBuilderArtifact(ArtifactReadable art) {
            this.typeId = art.getArtifactType().getIdString();
            this.name = art.getName();
            this.attributes = art.getExistingAttributeTypes().stream().filter(attr -> !attr.getName().equals("Name")).map(attr -> new TxBuilderAttribute(attr.getName(), art.getAttributeValues(attr).stream().filter(v -> v != null).map(v -> v.toString()).collect(Collectors.toList()))).filter(attr -> attr.getValue() != null).collect(Collectors.toList());
        }

        public String getTypeId() {
            return this.typeId;
        }

        public String getName() {
            return this.name;
        }

        public List<TxBuilderAttribute> getAttributes() {
            return this.attributes;
        }
    }

    private class TxBuilderAttribute {
        private final String typeName;
        private final List<String> value;

        public TxBuilderAttribute(String typeName, List<String> value) {
            this.typeName = typeName;
            this.value = value;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public List<String> getValue() {
            return this.value;
        }
    }
}

