/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.authentication.ldap.core.internal;

import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.osee.framework.authentication.ldap.core.Activator;
import org.eclipse.osee.framework.authentication.ldap.core.LDAPAuthenticationProvider;
import org.eclipse.osee.framework.core.exception.OseeDataStoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;

public class LDAPConnector {
    public static final String DEFAULT_ACCOUNT_SEARCH_FILTER = "(&(objectCategory=person)(sAMAccountName=%s))";
    public static final String DEFAULT_ACCOUNT_FIELD = "sAMAccountName";
    private static InitialLdapContext ctxInstance = null;
    private static LDAPConnector connector = null;
    private final String searchBase;
    private final Log logger;
    private final Hashtable<String, String> env;
    private final String accountSearchFilter;
    private LdapContext ctx;
    private final String accountField;

    public LDAPConnector(Log logger, Hashtable<String, String> env, String searchBase) {
        this(logger, env, searchBase, DEFAULT_ACCOUNT_SEARCH_FILTER, DEFAULT_ACCOUNT_FIELD);
    }

    public LDAPConnector(Log logger, Hashtable<String, String> env, String searchBase, String accountSearchFilter, String accountField) {
        this.logger = logger;
        this.env = env;
        this.searchBase = searchBase;
        this.accountSearchFilter = accountSearchFilter;
        this.accountField = accountField;
    }

    public LdapContext getCtx() {
        return this.ctx;
    }

    public String findAccountNameForUser(String username) throws NamingException {
        String toReturn;
        block11: {
            toReturn = null;
            String searchFilter = String.format(this.accountSearchFilter, username);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            InitialLdapContext ldapContext = null;
            try {
                ldapContext = new InitialLdapContext(this.env, null);
                this.logger.info("LDAP connection established", new Object[0]);
                NamingEnumeration<SearchResult> results = ldapContext.search(this.searchBase, searchFilter, searchControls);
                if (results == null) break block11;
                while (results.hasMoreElements()) {
                    SearchResult searchResult = (SearchResult)results.nextElement();
                    Attributes attribs = searchResult.getAttributes();
                    if (attribs.size() > 0) {
                        Attribute attribute = attribs.get(this.accountField);
                        NamingEnumeration<?> allMembers = attribute.getAll();
                        while (allMembers != null && allMembers.hasMoreElements()) {
                            String accountName = (String)allMembers.next();
                            if (!username.equalsIgnoreCase(accountName)) continue;
                            toReturn = accountName;
                            break;
                        }
                    }
                    if (toReturn == null) continue;
                    break;
                }
            }
            finally {
                if (ldapContext != null) {
                    try {
                        ldapContext.close();
                    }
                    catch (NamingException e) {
                        this.logger.info((Throwable)e, "Error closing LDAP context", new Object[0]);
                    }
                }
            }
        }
        return toReturn;
    }

    /*
     * Exception decompiling
     */
    public SearchResult getLdapUser(String username) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isLDAPUSer(String username) {
        boolean result = false;
        try {
            String accountName = this.findAccountNameForUser(username);
            result = accountName != null;
        }
        catch (NamingException ex) {
            this.logger.info((Throwable)ex, "Error authenticating LDAP user [%s]", new Object[]{username});
        }
        return result;
    }

    public void init() throws NamingException {
        try {
            this.ctx = new InitialLdapContext(this.env, null);
        }
        catch (NamingException namingException) {
            OseeLog.logf(Activator.class, (Level)Level.SEVERE, (String)"Failed to establish LDAP connection", (Object[])new Object[]{null});
        }
        if (this.ctx != null) {
            OseeLog.logf(Activator.class, (Level)Level.INFO, (String)"LDAP connection established", (Object[])new Object[]{null});
        }
    }

    /*
     * Loose catch block
     */
    public static InitialLdapContext getCtxInstance() {
        block10: {
            if (ctxInstance == null) {
                JdbcStatement statement = null;
                try {
                    statement = LDAPAuthenticationProvider.getAtsApi().getJdbcService().getClient().getStatement();
                    statement.runPreparedQuery("SELECT * FROM ldap_details", new Object[0]);
                    while (statement.next()) {
                        String ServerName = statement.getString("server_name");
                        int Port = statement.getInt("port");
                        String LDAPServerPrefix = "ldap://";
                        String sUserName = statement.getString("user_name");
                        String sPasswordEnc = statement.getString("password");
                        byte[] decodeBase64 = Base64.decodeBase64((byte[])sPasswordEnc.getBytes());
                        String sPassword = new String(decodeBase64);
                        Hashtable<String, String> env = new Hashtable<String, String>();
                        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                        env.put("java.naming.security.authentication", "simple");
                        env.put("java.naming.security.principal", sUserName);
                        env.put("java.naming.security.credentials", sPassword);
                        String ldapURL = String.valueOf(LDAPServerPrefix) + ServerName + ":" + Port;
                        env.put("java.naming.provider.url", ldapURL);
                        ctxInstance = new InitialLdapContext(env, null);
                    }
                }
                catch (NamingException namingException) {
                    OseeLog.logf(Activator.class, (Level)Level.SEVERE, (String)"Failed to establish LDAP connection", (Object[])new Object[]{null});
                    Lib.close((AutoCloseable)statement);
                    break block10;
                }
                catch (OseeDataStoreException e) {
                    e.printStackTrace();
                    Lib.close((AutoCloseable)statement);
                    break block10;
                }
                catch (OseeCoreException e) {
                    e.printStackTrace();
                    {
                        catch (Throwable throwable) {
                            Lib.close(statement);
                            throw throwable;
                        }
                    }
                    Lib.close((AutoCloseable)statement);
                    break block10;
                }
                Lib.close((AutoCloseable)statement);
            }
        }
        return ctxInstance;
    }

    public static LDAPConnector getConnector() {
        return connector;
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    /*
     * Loose catch block
     */
    public static String getsearchBaseFromDb() {
        block7: {
            JdbcStatement statement;
            block6: {
                String string;
                statement = null;
                try {
                    String SearchBase;
                    statement = LDAPAuthenticationProvider.getAtsApi().getJdbcService().getClient().getStatement();
                    statement.runPreparedQuery("SELECT * FROM ldap_details", new Object[0]);
                    if (!statement.next()) break block6;
                    string = SearchBase = statement.getString("search_base");
                }
                catch (OseeDataStoreException e) {
                    e.printStackTrace();
                    Lib.close((AutoCloseable)statement);
                    break block7;
                }
                catch (OseeCoreException e2) {
                    e2.printStackTrace();
                    {
                        catch (Throwable throwable) {
                            Lib.close(statement);
                            throw throwable;
                        }
                    }
                    Lib.close((AutoCloseable)statement);
                    break block7;
                }
                Lib.close((AutoCloseable)statement);
                return string;
            }
            Lib.close((AutoCloseable)statement);
        }
        return null;
    }

    public static void setCtxInstance(InitialLdapContext ctxInstance) {
        LDAPConnector.ctxInstance = ctxInstance;
    }
}

