/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal.oauth;

import com.google.common.io.ByteSource;
import java.util.Collection;
import java.util.Map;
import org.eclipse.osee.account.admin.OseePrincipal;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.OAuthOseeTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.jaxrs.server.security.OAuthClient;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.account.admin.internal.oauth.ClientArtifact;
import org.eclipse.osee.orcs.account.admin.internal.oauth.OAuthClientCredential;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class ClientStorage {
    private final OrcsApi orcsApi;
    private final BranchId storageBranch;

    public ClientStorage(OrcsApi orcsApi, BranchId storageBranch) {
        this.orcsApi = orcsApi;
        this.storageBranch = storageBranch;
    }

    private BranchId getBranch() {
        return this.storageBranch;
    }

    private QueryBuilder newQuery() {
        return this.orcsApi.getQueryFactory().fromBranch(this.getBranch());
    }

    private TransactionBuilder newTransaction(OseePrincipal principal, String comment) {
        UserToken author = principal == null ? SystemUser.OseeSystem : UserId.valueOf((Long)((Long)principal.getGuid()));
        TransactionFactory transactionFactory = this.orcsApi.getTransactionFactory();
        return transactionFactory.createTransaction(this.getBranch(), (UserId)author, comment);
    }

    public ResultSet<ArtifactReadable> getClientByApplicationId(ArtifactId applicationId) {
        return this.newQuery().andId(applicationId).getResults();
    }

    public ResultSet<ArtifactReadable> getClientByClientGuid(String guid) {
        return this.newQuery().andGuid(guid).getResults();
    }

    public ResultSet<ArtifactReadable> getClientByClientId(ArtifactId id) {
        return this.newQuery().andId(id).getResults();
    }

    public boolean exists(Long id) {
        return this.newQuery().andUuid(id.longValue()).exists();
    }

    public ArtifactId insert(OseePrincipal principal, OAuthClient data) {
        TransactionBuilder tx = this.newTransaction(principal, "Create OAuth Client");
        ArtifactToken artId = tx.createArtifact(OAuthOseeTypes.OAuthClient, data.getApplicationName(), ArtifactId.valueOf((Long)data.getClientUuid()));
        this.txSetClient(tx, (ArtifactId)artId, data);
        tx.commit();
        return artId;
    }

    public void update(OseePrincipal principal, OAuthClient data) {
        ArtifactId artId = ArtifactId.valueOf((Long)data.getClientUuid());
        TransactionBuilder tx = this.newTransaction(principal, "Update OAuth Client");
        tx.setName(artId, data.getApplicationName());
        this.txSetClient(tx, artId, data);
        tx.commit();
    }

    private void txSetClient(TransactionBuilder tx, ArtifactId artId, OAuthClient data) {
        tx.setSoleAttributeFromString(artId, (AttributeTypeToken)CoreAttributeTypes.Description, data.getApplicationDescription());
        tx.setSoleAttributeFromString(artId, (AttributeTypeToken)OAuthOseeTypes.OAuthClientWebsiteUri, data.getApplicationWebUri());
        tx.setSoleAttributeFromString(artId, (AttributeTypeToken)OAuthOseeTypes.OAuthClientLogoUri, data.getApplicationLogoUri());
        tx.setSoleAttributeValue(artId, (AttributeTypeToken)OAuthOseeTypes.OAuthClientIsConfidential, (Object)data.isConfidential());
        tx.setAttributesFromStrings(artId, (AttributeTypeToken)OAuthOseeTypes.OAuthClientAuthorizedAudience, (Collection)data.getRegisteredAudiences());
        tx.setAttributesFromStrings(artId, (AttributeTypeToken)OAuthOseeTypes.OAuthClientAuthorizedGrantType, (Collection)data.getAllowedGrantTypes());
        tx.setAttributesFromStrings(artId, (AttributeTypeToken)OAuthOseeTypes.OAuthClientAuthorizedRedirectUri, (Collection)data.getRedirectUris());
        tx.setAttributesFromStrings(artId, (AttributeTypeToken)OAuthOseeTypes.OAuthClientAuthorizedScope, (Collection)data.getRegisteredScopes());
        ByteSource supplier = data.getApplicationLogoSupplier();
        if (supplier != null) {
            try {
                tx.setSoleAttributeValue(artId, (AttributeTypeToken)CoreAttributeTypes.ImageContent, (Object)supplier.openStream());
            }
            catch (Exception ex) {
                throw new OseeCoreException((Throwable)ex, "Error reading logo data for [%s]", new Object[]{artId});
            }
        }
        Map props = data.getProperties();
        String json = JsonUtil.toJson((Object)props);
        tx.setSoleAttributeValue(artId, (AttributeTypeToken)OAuthOseeTypes.OAuthClientProperties, (Object)json);
    }

    public void delete(OseePrincipal principal, OAuthClient data) {
        ArtifactId artId = ArtifactId.valueOf((Long)data.getClientUuid());
        TransactionBuilder tx = this.newTransaction(principal, "Delete OAuth Client");
        tx.deleteArtifact(artId);
        tx.commit();
    }

    public OAuthClient newClient(ArtifactReadable artifact, OAuthClientCredential credential) {
        return new ClientArtifact(artifact, credential, this.orcsApi.jaxRsApi());
    }
}

