/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IExecuteListener;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogFactory;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateFactory;
import org.eclipse.osee.ats.core.util.AbstractAtsChangeSet;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class AtsChangeSet
extends AbstractAtsChangeSet {
    private TransactionBuilder transaction;
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;

    public AtsChangeSet(AtsApi atsApi, IAttributeResolver attributeResolver, OrcsApi orcsApi, IAtsStateFactory stateFactory, IAtsLogFactory logFactory, String comment, AtsUser user, BranchToken branch) {
        super(comment, branch, user);
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public TransactionBuilder getTransaction() {
        if (this.transaction == null) {
            if (this.branch == null) {
                this.branch = this.atsApi.getAtsBranch();
            }
            this.transaction = this.orcsApi.getTransactionFactory().createTransaction((BranchId)this.branch, this.comment);
        }
        return this.transaction;
    }

    public TransactionToken execute() {
        Conditions.checkNotNull((Object)this.comment, (String)"comment");
        if (this.isEmpty() && this.execptionIfEmpty) {
            throw new OseeArgumentException("objects/deleteObjects cannot be empty", new Object[0]);
        }
        for (IAtsObject atsObject : new ArrayList(this.atsObjects)) {
            if (!(atsObject instanceof IAtsWorkItem)) continue;
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            if (workItem.getStateMgr().isDirty()) {
                this.atsApi.getStateFactory().writeToStore(this.asUser, workItem, (IAtsChangeSet)this);
            }
            if (!workItem.getLog().isDirty()) continue;
            this.atsApi.getLogFactory().writeToStore(workItem, this.atsApi.getAttributeResolver(), (IAtsChangeSet)this);
        }
        TransactionToken tx = this.getTransaction().commit();
        for (IExecuteListener listener : this.listeners) {
            listener.changesStored((IAtsChangeSet)this);
        }
        this.atsApi.getNotificationService().sendNotifications(this.getNotifications());
        for (IAtsObject atsObject : new ArrayList(this.atsObjects)) {
            if (!(atsObject instanceof IAtsWorkItem)) continue;
            this.atsApi.getStoreService().clearCaches((IAtsWorkItem)atsObject);
        }
        return tx;
    }

    public void deleteSoleAttribute(IAtsWorkItem workItem, AttributeTypeToken attributeType) {
        this.getTransaction().deleteSoleAttribute((ArtifactId)this.getArtifact(workItem), attributeType);
        this.add(workItem);
    }

    public void setSoleAttributeValue(IAtsWorkItem workItem, AttributeTypeToken attributeType, String value) {
        ArtifactReadable artifact = this.getArtifact(workItem);
        this.setSoleAttributeValue((ArtifactId)artifact, attributeType, (Object)value);
    }

    public void setSoleAttributeValue(IAtsObject atsObject, AttributeTypeToken attributeType, Object value) {
        this.getTransaction().setSoleAttributeValue((ArtifactId)this.getArtifact(atsObject), attributeType, value);
        this.add(atsObject);
    }

    public void deleteAttribute(IAtsObject atsObject, AttributeTypeToken attributeType, Object value) {
        this.getTransaction().deleteAttributesWithValue((ArtifactId)this.getArtifact(atsObject), attributeType, value);
        this.add(atsObject);
    }

    public void deleteAttribute(ArtifactToken artifact, AttributeTypeToken attributeType, Object value) {
        this.getTransaction().deleteAttributesWithValue((ArtifactId)this.getArtifact(artifact), attributeType, value);
        this.add(artifact);
    }

    public <T> void setValue(IAtsWorkItem workItem, IAttribute<T> attr, AttributeTypeId attributeType, T value) {
        ArtifactReadable artifactId = this.getArtifact(workItem);
        this.getTransaction().setAttributeById((ArtifactId)artifactId, attr, value);
        this.add(workItem);
    }

    public <T> void deleteAttribute(IAtsWorkItem workItem, IAttribute<T> attr) {
        this.getTransaction().deleteByAttributeId((ArtifactId)this.getArtifact(workItem), attr);
        this.add(workItem);
    }

    public boolean isAttributeTypeValid(IAtsWorkItem workItem, AttributeTypeId attributeType) {
        ArtifactReadable artifact = this.getArtifact(workItem);
        return artifact.getValidAttributeTypes().contains(attributeType);
    }

    public void addAttribute(IAtsObject atsObject, AttributeTypeToken attributeType, Object value) {
        this.getTransaction().createAttribute((ArtifactId)this.getArtifact(atsObject), attributeType, value);
        this.add(atsObject);
    }

    public ArtifactToken createArtifact(ArtifactTypeToken artifactType, String name) {
        ArtifactToken artifact = this.getTransaction().createArtifact(artifactType, name);
        this.add(artifact);
        return artifact;
    }

    public ArtifactToken createArtifact(ArtifactTypeToken artifactType, String name, Long artifactId) {
        ArtifactToken artifact = this.getTransaction().createArtifact(artifactType, name, ArtifactId.valueOf((Long)artifactId));
        this.add(artifact);
        return artifact;
    }

    public void deleteAttributes(IAtsObject atsObject, AttributeTypeToken attributeType) {
        ArtifactReadable artifact = this.getArtifact(atsObject);
        this.getTransaction().deleteAttributes((ArtifactId)artifact, attributeType);
        this.add(atsObject);
    }

    public void relate(Object object1, RelationTypeSide relationSide, Object object2) {
        ArtifactReadable artifact = this.getArtifact(object1);
        ArtifactReadable artifact2 = this.getArtifact(object2);
        this.relate((ArtifactId)artifact, relationSide, (ArtifactId)artifact2);
    }

    public void relate(ArtifactId artifact1, RelationTypeSide relationSide, ArtifactId artifact2) {
        if (relationSide.getSide().isSideA()) {
            this.getTransaction().relate(artifact2, (RelationTypeToken)relationSide, artifact1);
        } else {
            this.getTransaction().relate(artifact1, (RelationTypeToken)relationSide, artifact2);
        }
        this.add(artifact1);
        this.add(artifact2);
    }

    private ArtifactReadable getArtifact(Object object) {
        ArtifactReadable artifact = null;
        if (object instanceof ArtifactReadable) {
            artifact = (ArtifactReadable)object;
        } else if (object instanceof IAtsObject) {
            IAtsObject atsObject = (IAtsObject)object;
            artifact = atsObject.getStoreObject() instanceof ArtifactReadable ? (ArtifactReadable)atsObject.getStoreObject() : (ArtifactReadable)this.atsApi.getQueryService().getArtifact(atsObject.getId());
        } else if (object instanceof ArtifactToken) {
            artifact = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(((ArtifactToken)object).getId());
        }
        return artifact;
    }

    public void unrelateAll(Object object, RelationTypeSide relationType) {
        ArtifactReadable artifact = this.getArtifact(object);
        this.add(artifact);
        for (ArtifactReadable otherArt : artifact.getRelated(relationType)) {
            if (relationType.getSide().isSideA()) {
                this.getTransaction().unrelate((ArtifactId)otherArt, (RelationTypeToken)relationType, (ArtifactId)artifact);
            } else {
                this.getTransaction().unrelate((ArtifactId)artifact, (RelationTypeToken)relationType, (ArtifactId)otherArt);
            }
            this.add(otherArt);
        }
    }

    public void setRelationsAndOrder(Object object, RelationTypeSide relationSide, Collection<? extends Object> objects) {
        ArtifactReadable artifact = this.getArtifact(object);
        LinkedList<ArtifactReadable> artifacts = new LinkedList<ArtifactReadable>();
        for (Object object2 : objects) {
            ArtifactReadable art = this.getArtifact(object2);
            if (art == null) continue;
            artifacts.add(art);
        }
        this.getTransaction().setRelationsAndOrder((ArtifactId)artifact, relationSide, artifacts);
        artifacts.add(artifact);
    }

    public void setRelations(Object object, RelationTypeSide relationSide, Collection<? extends Object> objects) {
        ArtifactReadable art;
        ArtifactReadable artifact = this.getArtifact(object);
        LinkedList<ArtifactReadable> artifacts = new LinkedList<ArtifactReadable>();
        for (Object object2 : objects) {
            art = this.getArtifact(object2);
            if (art == null) continue;
            artifacts.add(art);
        }
        for (ArtifactReadable artifactReadable : artifact.getRelated(relationSide)) {
            if (artifacts.contains(artifactReadable)) continue;
            this.unrelate((ArtifactId)artifact, relationSide, (ArtifactId)artifactReadable);
        }
        for (Object object3 : objects) {
            art = this.getArtifact(object3);
            if (artifact.areRelated(relationSide, art)) continue;
            this.relate(object, relationSide, object3);
        }
    }

    public void unrelate(Object object1, RelationTypeSide relationType, Object object2) {
        this.getTransaction().unrelate((ArtifactId)this.getArtifact(object1), (RelationTypeToken)relationType, (ArtifactId)this.getArtifact(object2));
        this.add(object1);
    }

    public <T> void setAttribute(IAtsWorkItem workItem, AttributeId attributeId, T value) {
        Conditions.checkExpressionFailOnTrue((boolean)attributeId.isInvalid(), (String)"Can not set attribute by id that has not be persisted.  Attribute Id [%s] Work Item [%s]", (Object[])new Object[]{attributeId, workItem.toStringWithId()});
        ArtifactReadable artifact = this.getArtifact(workItem);
        boolean found = false;
        for (AttributeReadable attribute : artifact.getAttributes()) {
            if (!attributeId.equals(attribute)) continue;
            this.getTransaction().setAttributeById((ArtifactId)artifact, (AttributeId)attribute, value);
            found = true;
            break;
        }
        if (!found) {
            throw new OseeStateException("Attribute Id %d does not exist on Artifact %s", new Object[]{attributeId, workItem});
        }
        this.add(workItem);
    }

    public void deleteArtifact(ArtifactId artifact) {
        this.getTransaction().deleteArtifact(artifact);
        this.add(artifact);
    }

    public void setAttributeValues(IAtsObject atsObject, AttributeTypeToken attrType, List<Object> values) {
        ArtifactReadable artifact = this.getArtifact(atsObject);
        this.getTransaction().setAttributesFromValues((ArtifactId)artifact, attrType, values);
        this.add(artifact);
    }

    public void setAttributeValues(ArtifactId artifact, AttributeTypeToken attrType, List<Object> values) {
        this.getTransaction().setAttributesFromValues(artifact, attrType, values);
        this.add(artifact);
    }

    public <T> void setAttribute(ArtifactId artifact, AttributeId attrId, T value) {
        Conditions.checkExpressionFailOnTrue((boolean)attrId.isInvalid(), (String)"Can not set attribute by id that has not been persisted.  Atrribute Id [%s] ArtifactId [%s]", (Object[])new Object[]{attrId, artifact.toString()});
        for (AttributeReadable attribute : this.getArtifact(artifact).getAttributes()) {
            if (!attrId.equals(attribute)) continue;
            this.getTransaction().setAttributeById((ArtifactId)this.getArtifact(artifact), (AttributeId)attribute, value);
        }
    }

    public void setSoleAttributeValue(ArtifactId artifact, AttributeTypeToken attrType, Object value) {
        ArtifactReadable art = this.getArtifact(artifact);
        this.getTransaction().setSoleAttributeValue((ArtifactId)art, attrType, value);
        this.add(art);
    }

    public void deleteAttribute(ArtifactId artifact, IAttribute<?> attr) {
        AttributeReadable attribute = ((ArtifactReadable)artifact).getAttributeById(attr);
        this.getTransaction().deleteByAttributeId(artifact, (AttributeId)attribute);
        this.add(artifact);
    }

    public void unrelate(ArtifactId artifact, RelationTypeSide relationSide, ArtifactId artifact2) {
        ArtifactReadable art = this.getArtifact(artifact);
        ArtifactReadable art2 = this.getArtifact(artifact2);
        if (relationSide.getSide().isSideA()) {
            this.getTransaction().unrelate((ArtifactId)art2, (RelationTypeToken)relationSide, (ArtifactId)art);
        } else {
            this.getTransaction().unrelate((ArtifactId)art, (RelationTypeToken)relationSide, (ArtifactId)art2);
        }
        this.add(art);
        this.add(art2);
    }

    public void addAttribute(ArtifactId artifact, AttributeTypeToken attrType, Object value) {
        ArtifactReadable art = this.getArtifact(artifact);
        this.getTransaction().createAttribute(artifact, attrType, value);
        this.add(art);
    }

    public void setSoleAttributeFromString(ArtifactId artifact, AttributeTypeGeneric<?> attributeType, String value) {
        ArtifactReadable art = this.getArtifact(artifact);
        this.getTransaction().setSoleAttributeFromString(artifact, attributeType, value);
        this.add(art);
    }

    public void setSoleAttributeFromStream(ArtifactId artifact, AttributeTypeGeneric<?> attributeType, InputStream inputStream) {
        ArtifactReadable art = this.getArtifact(artifact);
        this.getTransaction().setSoleAttributeFromStream((ArtifactId)art, attributeType, inputStream);
        this.add(art);
    }

    public void unrelateFromAll(RelationTypeSide relationSide, ArtifactId artifact) {
        ArtifactReadable art = this.getArtifact(artifact);
        this.getTransaction().unrelateFromAll(relationSide, (ArtifactId)art);
        this.add(art);
    }

    public void deleteAttributes(ArtifactId artifact, AttributeTypeToken attributeType) {
        ArtifactReadable art = this.getArtifact(artifact);
        this.getTransaction().deleteAttributes((ArtifactId)art, attributeType);
        this.add(art);
    }

    public void setAttributeValuesAsStrings(IAtsObject atsObject, AttributeTypeToken attributeType, List<String> values) {
        LinkedList<Object> objValues = new LinkedList<Object>();
        for (String value : values) {
            if (attributeType.isString()) {
                try {
                    objValues.add(value);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid value [%s]; must be string", new Object[]{value});
                }
            }
            if (attributeType.isDate()) {
                try {
                    Date date = new Date(Long.valueOf(value));
                    objValues.add(date);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid date value [%s]; must be long date", new Object[]{value});
                }
            }
            if (attributeType.isDouble()) {
                try {
                    Double double1 = Double.valueOf(value);
                    objValues.add(double1);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid double value [%s]", new Object[]{value});
                }
            }
            if (attributeType.isInteger()) {
                try {
                    Integer integer = Integer.valueOf(value);
                    objValues.add(integer);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid integer value [%s]", new Object[]{value});
                }
            }
            if (attributeType.isLong()) {
                try {
                    Long longVal = Long.valueOf(value);
                    objValues.add(longVal);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid long value [%s]", new Object[]{value});
                }
            }
            if (attributeType.isBoolean()) {
                try {
                    Boolean bool = Boolean.valueOf(value);
                    objValues.add(bool);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid boolean value [%s]", new Object[]{value});
                }
            }
            if (attributeType.isEnumerated()) {
                try {
                    objValues.add(value);
                    continue;
                }
                catch (Exception ex) {
                    throw new OseeArgumentException((Throwable)ex, "Invalid value [%s]; must be string", new Object[]{value});
                }
            }
            throw new OseeArgumentException("Unsupported attribute value [%s] for type [%s] and artifact %s", new Object[]{value, attributeType, atsObject.toStringWithId()});
        }
        ArtifactReadable art = this.getArtifact(atsObject);
        this.setAttributeValues((ArtifactId)art, attributeType, objValues);
    }

    public void addArtifactReferencedAttribute(ArtifactId artifact, AttributeTypeToken attributeType, ArtifactId artifactRef) {
        this.addAttribute(artifact, attributeType, (Object)artifactRef.getIdString());
    }

    public ArtifactToken createArtifact(ArtifactToken parent, ArtifactTypeToken artType, String name) {
        ArtifactToken artifact = this.getTransaction().createArtifact(artType, name);
        this.addChild((ArtifactId)parent, (ArtifactId)artifact);
        this.add(artifact);
        return artifact;
    }

    public void deleteRelation(RelationId relation) {
        throw new UnsupportedOperationException("Unsupported on Server");
    }

    public void clear() {
        super.clear();
        this.transaction = null;
    }
}

