/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader;

import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreBranchCategoryTokens;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.core.executor.HasCancellation;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.LoadDescription;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.OrcsDataHandler;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.ResultObjectDescription;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.db.internal.OrcsObjectFactory;
import org.eclipse.osee.orcs.db.internal.loader.LoadSqlContext;
import org.eclipse.osee.orcs.db.internal.loader.LoadSqlWriter;
import org.eclipse.osee.orcs.db.internal.loader.criteria.CriteriaOrcsLoad;
import org.eclipse.osee.orcs.db.internal.loader.data.TransactionDataImpl;
import org.eclipse.osee.orcs.db.internal.loader.processor.AbstractLoadProcessor;
import org.eclipse.osee.orcs.db.internal.loader.processor.ArtifactLoadProcessor;
import org.eclipse.osee.orcs.db.internal.loader.processor.AttributeLoadProcessor;
import org.eclipse.osee.orcs.db.internal.loader.processor.DynamicLoadProcessor;
import org.eclipse.osee.orcs.db.internal.loader.processor.RelationLoadProcessor;
import org.eclipse.osee.orcs.db.internal.loader.processor.RelationLoadProcessor2;
import org.eclipse.osee.orcs.db.internal.search.QuerySqlContext;
import org.eclipse.osee.orcs.db.internal.sql.SqlContext;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandlerFactory;
import org.eclipse.osee.orcs.db.internal.sql.join.AbstractJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.Id4JoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class SqlObjectLoader {
    private final ArtifactLoadProcessor artifactProcessor;
    private final AttributeLoadProcessor attributeProcessor;
    private final RelationLoadProcessor relationProcessor;
    private final RelationLoadProcessor2 relationProcessor2;
    private final DynamicLoadProcessor dynamicProcessor;
    private final Log logger;
    private final JdbcClient jdbcClient;
    private final SqlJoinFactory joinFactory;
    private final SqlHandlerFactory handlerFactory;
    private final OrcsTokenService tokenService;

    public SqlObjectLoader(Log logger, JdbcClient jdbcClient, SqlJoinFactory joinFactory, SqlHandlerFactory handlerFactory, OrcsObjectFactory objectFactory, DynamicLoadProcessor dynamicProcessor, OrcsTokenService tokenService) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
        this.joinFactory = joinFactory;
        this.handlerFactory = handlerFactory;
        this.dynamicProcessor = dynamicProcessor;
        this.tokenService = tokenService;
        this.artifactProcessor = new ArtifactLoadProcessor(objectFactory);
        this.attributeProcessor = new AttributeLoadProcessor(logger, objectFactory, tokenService);
        this.relationProcessor = new RelationLoadProcessor(logger, objectFactory, tokenService);
        this.relationProcessor2 = new RelationLoadProcessor2(logger, objectFactory, tokenService);
    }

    public SqlHandlerFactory getFactory() {
        return this.handlerFactory;
    }

    public JdbcClient getJdbcClient() {
        return this.jdbcClient;
    }

    private void checkCancelled(HasCancellation cancellation) throws CancellationException {
        if (cancellation != null) {
            cancellation.checkForCancelled();
        }
    }

    private boolean isAttributeLoadingAllowed(LoadLevel level) {
        return level != LoadLevel.ARTIFACT_DATA && level != LoadLevel.RELATION_DATA;
    }

    private boolean isRelationLoadingAllowed(LoadLevel level) {
        return level != LoadLevel.ARTIFACT_DATA && level != LoadLevel.ARTIFACT_AND_ATTRIBUTE_DATA;
    }

    private void writeSql(Criteria criteria, LoadSqlContext context) {
        context.clear();
        SqlHandler<?> handler = this.handlerFactory.createHandler(criteria);
        LoadSqlWriter writer = new LoadSqlWriter(this.joinFactory, this.jdbcClient, (SqlContext)context, this.tokenService);
        writer.build(handler);
    }

    public void loadArtifacts(HasCancellation cancellation, LoadDataHandler handler, Id4JoinQuery join, CriteriaOrcsLoad criteria, LoadSqlContext loadContext, int fetchSize) {
        this.logger.trace("Sql Artifact Load - artifactJoinQuery[%s] loadSqlContext[%s]", new Object[]{join, loadContext});
        try {
            if (!join.isEmpty()) {
                join.store();
                criteria.setQueryId(join.getQueryId());
                this.loadArtifacts(cancellation, handler, criteria, loadContext, fetchSize);
            } else {
                this.logger.trace("Sql Artifact Load - artifactJoinQuery was empty - skipping load - loadSqlContext[%s]", new Object[]{loadContext});
            }
        }
        finally {
            join.close();
        }
    }

    public void loadBranches(List<? super Branch> branches, QuerySqlContext loadContext) {
        this.logger.trace("Sql Branch Load - loadContext[%s]", new Object[]{loadContext});
        Consumer<JdbcStatement> stmtConsumer = stmt -> {
            Long branchId = stmt.getLong("branch_id");
            String name = stmt.getString("branch_name");
            ArtifactId associatedArtifact = ArtifactId.valueOf((Long)stmt.getLong("associated_art_id"));
            TransactionId baselineTx = TransactionId.valueOf((Long)stmt.getLong("baseline_transaction_id"));
            TransactionId parentTx = TransactionId.valueOf((Long)stmt.getLong("parent_transaction_id"));
            BranchId parentBranch = BranchId.valueOf((Long)stmt.getLong("parent_branch_id"));
            boolean isArchived = stmt.getInt("archived") == 1;
            BranchState branchState = BranchState.valueOf((long)stmt.getInt("branch_state"));
            BranchType branchType = BranchType.valueOf((long)stmt.getInt("branch_type"));
            boolean inheritAccessControl = stmt.getInt("inherit_access_control") != 0;
            ArtifactId viewId = ArtifactId.SENTINEL;
            Branch branch = new Branch(branchId, name, associatedArtifact, baselineTx, parentTx, parentBranch, isArchived, branchState, branchType, inheritAccessControl, viewId);
            branches.add(branch);
        };
        this.load(loadContext, stmtConsumer);
    }

    public void loadTransactions(UserService userService, List<? super TransactionReadable> txs, QuerySqlContext queryContext) {
        Consumer<JdbcStatement> stmtConsumer = stmt -> {
            TransactionDataImpl tx = new TransactionDataImpl(stmt.getLong("transaction_id"));
            tx.setBranch(BranchId.valueOf((Long)stmt.getLong("branch_id")));
            tx.setTxType(TransactionDetailsType.valueOf((int)stmt.getInt("tx_type")));
            tx.setComment(stmt.getString("osee_comment"));
            tx.setDate(stmt.getTimestamp("time"));
            tx.setAuthor(userService.getUser(Long.valueOf(stmt.getLong("author"))));
            tx.setCommitArt(ArtifactId.valueOf((Long)stmt.getLong("commit_art_id")));
            tx.setBuildId(stmt.getLong("build_id"));
            txs.add((TransactionReadable)tx);
        };
        this.load(queryContext, stmtConsumer);
    }

    public void loadDynamicObjects(HasCancellation cancellation, LoadDataHandler handler, QuerySqlContext context, int fetchSize) {
        this.logger.trace("Sql Transaction Load - loadContext[%s] fetchSize[%s]", new Object[]{context, fetchSize});
        this.checkCancelled(cancellation);
        Options options = context.getOptions();
        options.put("sql", context.getSql());
        options.put("parameters", context.getParameters().toString());
        options.put("result.descriptor", (Object)context.getObjectDescription());
        LoadDescription description = SqlObjectLoader.createDescription(context.getSession(), options, context.getObjectDescription());
        handler.onLoadDescription(description);
        this.load(this.dynamicProcessor, handler, context, fetchSize);
        options.remove("result.descriptor");
    }

    private void loadArtifacts(HasCancellation cancellation, LoadDataHandler handler, CriteriaOrcsLoad criteria, LoadSqlContext loadContext, int fetchSize) {
        this.checkCancelled(cancellation);
        this.loadDescription(handler, loadContext);
        this.checkCancelled(cancellation);
        this.loadArtifacts(handler, criteria.getArtifactCriteria(), loadContext, fetchSize);
        this.checkCancelled(cancellation);
        this.loadAttributes(handler, criteria.getAttributeCriteria(), loadContext, fetchSize);
        this.checkCancelled(cancellation);
        this.loadRelations(handler, criteria.getRelationCriteria(), loadContext, fetchSize);
        if (!loadContext.getBranchCategories().isEmpty() && loadContext.getBranchCategories().contains(CoreBranchCategoryTokens.MIM)) {
            this.checkCancelled(cancellation);
            this.loadRelations2(handler, criteria.getRelationCriteria2(), loadContext, fetchSize);
        }
    }

    protected void loadDescription(LoadDataHandler builder, LoadSqlContext loadContext) {
        OrcsSession session = loadContext.getSession();
        Options options = loadContext.getOptions();
        BranchId branch = loadContext.getBranch();
        TransactionId transactionLoaded = OptionsUtil.isHeadTransaction((Options)options) ? this.loadHeadTransactionId(branch) : OptionsUtil.getFromTransaction((Options)options);
        LoadDescription description = SqlObjectLoader.createDescription(session, options, branch, transactionLoaded);
        builder.onLoadDescription(description);
    }

    protected void loadArtifacts(LoadDataHandler handler, Criteria criteria, LoadSqlContext loadContext, int fetchSize) {
        OrcsDataHandler<ArtifactData> artHandler = SqlObjectLoader.asArtifactHandler(handler);
        this.writeSql(criteria, loadContext);
        this.load(this.artifactProcessor, artHandler, loadContext, fetchSize);
    }

    protected void loadAttributes(LoadDataHandler handler, Criteria criteria, LoadSqlContext loadContext, int fetchSize) {
        LoadLevel loadLevel = OptionsUtil.getLoadLevel((Options)loadContext.getOptions());
        if (this.isAttributeLoadingAllowed(loadLevel)) {
            OrcsDataHandler<AttributeData> attrHandler = SqlObjectLoader.asAttributeHandler(handler);
            this.writeSql(criteria, loadContext);
            this.load(this.attributeProcessor, attrHandler, loadContext, fetchSize);
        }
    }

    protected void loadRelations(LoadDataHandler handler, Criteria criteria, LoadSqlContext loadContext, int fetchSize) {
        LoadLevel loadLevel = OptionsUtil.getLoadLevel((Options)loadContext.getOptions());
        if (this.isRelationLoadingAllowed(loadLevel)) {
            OrcsDataHandler<RelationData> relHandler = SqlObjectLoader.asRelationHandler(handler);
            this.writeSql(criteria, loadContext);
            this.load(this.relationProcessor, relHandler, loadContext, fetchSize);
        }
    }

    protected void loadRelations2(LoadDataHandler handler, Criteria criteria, LoadSqlContext loadContext, int fetchSize) {
        LoadLevel loadLevel = OptionsUtil.getLoadLevel((Options)loadContext.getOptions());
        if (this.isRelationLoadingAllowed(loadLevel)) {
            OrcsDataHandler<RelationData> relHandler = SqlObjectLoader.asRelationHandler(handler);
            this.writeSql(criteria, loadContext);
            this.load(this.relationProcessor2, relHandler, loadContext, fetchSize);
        }
    }

    protected TransactionId loadHeadTransactionId(BranchId branch) {
        String sql = "SELECT max(transaction_id) FROM osee_tx_details WHERE branch_id = ?";
        return (TransactionId)this.getJdbcClient().fetch((Object)TransactionId.SENTINEL, sql, new Object[]{branch});
    }

    /*
     * Unable to fully structure code
     */
    private void load(SqlContext queryContext, Consumer<JdbcStatement> consumer) {
        try {
            for (AbstractJoinQuery join : queryContext.getJoins()) {
                join.store();
            }
            this.jdbcClient.runQuery(consumer, queryContext.getFetchSize(), queryContext.getSql(), queryContext.getParameters().toArray());
        }
        finally {
            ** for (join : queryContext.getJoins())
        }
lbl-1000:
        // 1 sources

        {
            try {
                join.close();
            }
            catch (Exception v0) {}
            continue;
        }
lbl15:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <H> void load(AbstractLoadProcessor<H> processor, H handler, SqlContext loadContext, int fetchSize) {
        block18: {
            var6_5 = loadContext.getJoins().iterator();
            while (true) {
                if (!var6_5.hasNext()) {
                    startTime = System.currentTimeMillis();
                    var7_8 = null;
                    var8_10 = null;
                    ** try [egrp 1[TRYBLOCK] [1 : 54->257)] { 
lbl9:
                    // 1 sources

                    break;
                }
                join = var6_5.next();
                join.store();
            }
            {
                chStmt = this.getJdbcClient().getStatement();
                try {
                    chStmt.runPreparedQuery(fetchSize, loadContext.getSql(), loadContext.getParameters().toArray());
                    processorName = null;
                    if (this.logger.isTraceEnabled()) {
                        processorName = processor.getClass().getSimpleName();
                        this.logger.trace("Sql Artifact Load [%s] - [%s] fetchSize[%s] context[%s] ", new Object[]{Lib.getElapseString((long)startTime), processorName, fetchSize, loadContext});
                        startTime = System.currentTimeMillis();
                    }
                    rowCount = processor.processResultSet(handler, chStmt, loadContext.getOptions());
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Sql Artifact Load [%s] - [%s] processed [%d] rows", new Object[]{Lib.getElapseString((long)startTime), processorName, rowCount});
                    }
                    if (chStmt == null) break block18;
                }
                catch (Throwable var7_9) {
                    if (chStmt == null) throw var7_9;
                    chStmt.close();
                    throw var7_9;
                }
                chStmt.close();
            }
lbl32:
            // 1 sources

            catch (Throwable var8_11) {
                if (var7_8 == null) {
                    var7_8 = var8_11;
                    throw var7_8;
                }
                if (var7_8 == var8_11) throw var7_8;
                var7_8.addSuppressed(var8_11);
                throw var7_8;
            }
            finally {
                var14_17 = loadContext.getJoins().iterator();
                break;
            }
        }
        while (true) {
            if (!var14_17.hasNext()) {
                return;
            }
            join = var14_17.next();
            try {
                join.close();
            }
            catch (Exception v0) {}
        }
    }

    private static LoadDescription createDescription(OrcsSession session, Options options, ResultObjectDescription data) {
        return SqlObjectLoader.createDescription(session, options, null, TransactionId.SENTINEL, data);
    }

    private static LoadDescription createDescription(OrcsSession session, Options options, BranchId branch, TransactionId transactionLoaded) {
        return SqlObjectLoader.createDescription(session, options, branch, transactionLoaded, null);
    }

    private static LoadDescription createDescription(final OrcsSession session, final Options options, final BranchId branch, final TransactionId transactionLoaded, final ResultObjectDescription data) {
        return new LoadDescription(){

            public OrcsSession getSession() {
                return session;
            }

            public Options getOptions() {
                return options;
            }

            public BranchId getBranch() {
                return branch;
            }

            public TransactionId getTransaction() {
                return transactionLoaded;
            }

            public boolean isMultiBranch() {
                return this.getBranch() == null;
            }

            public ResultObjectDescription getObjectDescription() {
                return data;
            }
        };
    }

    private static OrcsDataHandler<ArtifactData> asArtifactHandler(final LoadDataHandler handler) {
        return new OrcsDataHandler<ArtifactData>(){

            public void onData(ArtifactData data) {
                handler.onData(data);
            }
        };
    }

    private static OrcsDataHandler<AttributeData> asAttributeHandler(final LoadDataHandler handler) {
        return new OrcsDataHandler<AttributeData>(){

            public void onData(AttributeData data) {
                handler.onData(data);
            }
        };
    }

    private static OrcsDataHandler<RelationData> asRelationHandler(final LoadDataHandler handler) {
        return new OrcsDataHandler<RelationData>(){

            public void onData(RelationData data) {
                handler.onData(data);
            }
        };
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCount(SqlContext queryContext) {
        try {
            for (AbstractJoinQuery join : queryContext.getJoins()) {
                join.store();
            }
            var5_4 = (Integer)this.jdbcClient.fetch((Object)-1, queryContext.getSql(), queryContext.getParameters().toArray());
            return var5_4;
        }
        finally {
            ** for (join : queryContext.getJoins())
        }
lbl-1000:
        // 1 sources

        {
            try {
                join.close();
            }
            catch (Exception v0) {}
            continue;
        }
lbl14:
        // 1 sources

        return var5_4;
    }
}

