/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.synchronization.rest.reqifsynchronizationartifactbuilder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.EnumMap;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeBoolean;
import org.eclipse.osee.framework.core.data.AttributeTypeBranchId;
import org.eclipse.osee.framework.core.data.AttributeTypeDate;
import org.eclipse.osee.framework.core.data.AttributeTypeDouble;
import org.eclipse.osee.framework.core.data.AttributeTypeInteger;
import org.eclipse.osee.framework.core.data.AttributeTypeLong;
import org.eclipse.osee.framework.core.data.AttributeTypeString;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.EnumBiConsumerMap;
import org.eclipse.osee.framework.jdk.core.util.EnumConsumerMap;
import org.eclipse.osee.framework.jdk.core.util.EnumSupplierMap;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.synchronization.rest.AttributeDefinitionGroveThing;
import org.eclipse.osee.synchronization.rest.AttributeValueGrove;
import org.eclipse.osee.synchronization.rest.AttributeValueGroveThing;
import org.eclipse.osee.synchronization.rest.CommonObjectGroveThing;
import org.eclipse.osee.synchronization.rest.CommonObjectTypeGroveThing;
import org.eclipse.osee.synchronization.rest.DataTypeDefinitionGrove;
import org.eclipse.osee.synchronization.rest.DataTypeDefinitionGroveThing;
import org.eclipse.osee.synchronization.rest.GroveThing;
import org.eclipse.osee.synchronization.rest.HeaderGrove;
import org.eclipse.osee.synchronization.rest.HeaderGroveThing;
import org.eclipse.osee.synchronization.rest.IdentifierType;
import org.eclipse.osee.synchronization.rest.IsSynchronizationArtifactBuilder;
import org.eclipse.osee.synchronization.rest.NativeDataType;
import org.eclipse.osee.synchronization.rest.SpecObjectGrove;
import org.eclipse.osee.synchronization.rest.SpecObjectGroveThing;
import org.eclipse.osee.synchronization.rest.SpecObjectTypeGrove;
import org.eclipse.osee.synchronization.rest.SpecObjectTypeGroveThing;
import org.eclipse.osee.synchronization.rest.SpecTypeGrove;
import org.eclipse.osee.synchronization.rest.SpecTypeGroveThing;
import org.eclipse.osee.synchronization.rest.SpecificationGrove;
import org.eclipse.osee.synchronization.rest.SpecificationGroveThing;
import org.eclipse.osee.synchronization.rest.SynchronizationArtifact;
import org.eclipse.osee.synchronization.rest.SynchronizationArtifactBuilder;
import org.eclipse.osee.synchronization.util.DataConverters;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionBoolean;
import org.eclipse.rmf.reqif10.AttributeDefinitionDate;
import org.eclipse.rmf.reqif10.AttributeDefinitionInteger;
import org.eclipse.rmf.reqif10.AttributeDefinitionReal;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueBoolean;
import org.eclipse.rmf.reqif10.AttributeValueDate;
import org.eclipse.rmf.reqif10.AttributeValueInteger;
import org.eclipse.rmf.reqif10.AttributeValueReal;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.DatatypeDefinitionBoolean;
import org.eclipse.rmf.reqif10.DatatypeDefinitionDate;
import org.eclipse.rmf.reqif10.DatatypeDefinitionInteger;
import org.eclipse.rmf.reqif10.DatatypeDefinitionReal;
import org.eclipse.rmf.reqif10.DatatypeDefinitionString;
import org.eclipse.rmf.reqif10.DatatypeDefinitionXHTML;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIFContent;
import org.eclipse.rmf.reqif10.ReqIFHeader;
import org.eclipse.rmf.reqif10.ReqIFToolExtension;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.SpecificationType;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.serialization.ReqIF10ResourceFactoryImpl;
import org.eclipse.rmf.reqif10.serialization.ReqIF10ResourceImpl;

@IsSynchronizationArtifactBuilder(artifactType="reqif")
public class ReqIFSynchronizationArtifactBuilder
implements SynchronizationArtifactBuilder {
    private static final EnumConsumerMap<IdentifierType, GroveThing> converterMap = new EnumConsumerMap(IdentifierType.class);
    private static final ZoneId zoneIdZ = ZoneId.of("Z");
    private static final GregorianCalendar lastChangeEpoch = GregorianCalendar.from(ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, zoneIdZ));
    private static final EnumBiConsumerMap<NativeDataType, ? super AttributeValue, ? super AttributeDefinition> reqifAttachAttributeDefinitionToAttributeValueMap = new EnumBiConsumerMap(NativeDataType.class);
    private static final EnumBiConsumerMap<NativeDataType, ? super AttributeDefinition, ? super DatatypeDefinition> reqifAttachDatatypeDefinitionToAttributeDefinitionMap = new EnumBiConsumerMap(NativeDataType.class);
    private static final EnumBiConsumerMap<NativeDataType, AttributeDefinitionGroveThing, AttributeDefinition> reqifAttributeDefinitionDatatypeConverterMap = new EnumBiConsumerMap(NativeDataType.class);
    private static final EnumSupplierMap<NativeDataType, AttributeDefinition> reqifAttributeDefinitionFactoryMap = new EnumSupplierMap(NativeDataType.class);
    private static final EnumSupplierMap<NativeDataType, AttributeValue> reqifAttributeValueFactoryMap = new EnumSupplierMap(NativeDataType.class);
    private static final EnumBiConsumerMap<NativeDataType, Object, AttributeValue> reqifAttributeValueSetterMap = new EnumBiConsumerMap(NativeDataType.class);
    private static final EnumSupplierMap<NativeDataType, DatatypeDefinition> reqifDatatypeDefinitionFactoryMap = new EnumSupplierMap(NativeDataType.class);
    private static final EnumBiConsumerMap<NativeDataType, DataTypeDefinitionGroveThing, DatatypeDefinition> reqifDatatypeDefinitionDatatypeConverterMap = new EnumBiConsumerMap(NativeDataType.class);
    private static final EnumMap<NativeDataType, ReqifDatatypeRecord> reqifDatatypeDefinitionRecordMap = new EnumMap(NativeDataType.class);
    private static final String version = "0.0";
    ReqIF reqIf = ReqIF10Factory.eINSTANCE.createReqIF();

    static {
        converterMap.put((Enum)IdentifierType.HEADER, ReqIFSynchronizationArtifactBuilder::convertHeader);
        converterMap.put((Enum)IdentifierType.DATA_TYPE_DEFINITION, ReqIFSynchronizationArtifactBuilder::convertDataTypeDefinition);
        converterMap.put((Enum)IdentifierType.SPECIFICATION_TYPE, ReqIFSynchronizationArtifactBuilder::convertSpecType);
        converterMap.put((Enum)IdentifierType.ATTRIBUTE_DEFINITION, ReqIFSynchronizationArtifactBuilder::convertAttributeDefinition);
        converterMap.put((Enum)IdentifierType.SPEC_OBJECT_TYPE, ReqIFSynchronizationArtifactBuilder::convertSpecObjectType);
        converterMap.put((Enum)IdentifierType.SPECIFICATION, ReqIFSynchronizationArtifactBuilder::convertSpecification);
        converterMap.put((Enum)IdentifierType.SPEC_OBJECT, ReqIFSynchronizationArtifactBuilder::convertSpecObject);
        converterMap.put((Enum)IdentifierType.ATTRIBUTE_VALUE, ReqIFSynchronizationArtifactBuilder::convertAttributeValue);
        reqifAttachAttributeDefinitionToAttributeValueMap.put((Enum)NativeDataType.ARTIFACT_IDENTIFIER, (attributeValue, attributeDefinition) -> ((AttributeValueInteger)attributeValue).setDefinition((AttributeDefinitionInteger)attributeDefinition));
        reqifAttachAttributeDefinitionToAttributeValueMap.put((Enum)NativeDataType.BRANCH_IDENTIFIER, (attributeValue, attributeDefinition) -> ((AttributeValueInteger)attributeValue).setDefinition((AttributeDefinitionInteger)attributeDefinition));
        reqifAttachAttributeDefinitionToAttributeValueMap.put((Enum)NativeDataType.BOOLEAN, (attributeValue, attributeDefinition) -> ((AttributeValueBoolean)attributeValue).setDefinition((AttributeDefinitionBoolean)attributeDefinition));
        reqifAttachAttributeDefinitionToAttributeValueMap.put((Enum)NativeDataType.DATE, (attributeValue, attributeDefinition) -> ((AttributeValueDate)attributeValue).setDefinition((AttributeDefinitionDate)attributeDefinition));
        reqifAttachAttributeDefinitionToAttributeValueMap.put((Enum)NativeDataType.DOUBLE, (attributeValue, attributeDefinition) -> ((AttributeValueReal)attributeValue).setDefinition((AttributeDefinitionReal)attributeDefinition));
        reqifAttachAttributeDefinitionToAttributeValueMap.put((Enum)NativeDataType.ENUMERATED, (attributeValue, attributeDefinition) -> ((AttributeValueString)attributeValue).setDefinition((AttributeDefinitionString)attributeDefinition));
        reqifAttachAttributeDefinitionToAttributeValueMap.put((Enum)NativeDataType.INPUT_STREAM, (attributeValue, attributeDefinition) -> ((AttributeValueString)attributeValue).setDefinition((AttributeDefinitionString)attributeDefinition));
        reqifAttachAttributeDefinitionToAttributeValueMap.put((Enum)NativeDataType.INTEGER, (attributeValue, attributeDefinition) -> ((AttributeValueInteger)attributeValue).setDefinition((AttributeDefinitionInteger)attributeDefinition));
        reqifAttachAttributeDefinitionToAttributeValueMap.put((Enum)NativeDataType.JAVA_OBJECT, (attributeValue, attributeDefinition) -> ((AttributeValueString)attributeValue).setDefinition((AttributeDefinitionString)attributeDefinition));
        reqifAttachAttributeDefinitionToAttributeValueMap.put((Enum)NativeDataType.LONG, (attributeValue, attributeDefinition) -> ((AttributeValueInteger)attributeValue).setDefinition((AttributeDefinitionInteger)attributeDefinition));
        reqifAttachAttributeDefinitionToAttributeValueMap.put((Enum)NativeDataType.STRING, (attributeValue, attributeDefinition) -> ((AttributeValueString)attributeValue).setDefinition((AttributeDefinitionString)attributeDefinition));
        reqifAttachAttributeDefinitionToAttributeValueMap.put((Enum)NativeDataType.STRING_WORD_ML, (attributeValue, attributeDefinition) -> ((AttributeValueXHTML)attributeValue).setDefinition((AttributeDefinitionXHTML)attributeDefinition));
        reqifAttachAttributeDefinitionToAttributeValueMap.put((Enum)NativeDataType.URI, (attributeValue, attributeDefinition) -> ((AttributeValueString)attributeValue).setDefinition((AttributeDefinitionString)attributeDefinition));
        reqifAttachDatatypeDefinitionToAttributeDefinitionMap.put((Enum)NativeDataType.ARTIFACT_IDENTIFIER, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionInteger)attributeDefinition).setType((DatatypeDefinitionInteger)datatypeDefinition));
        reqifAttachDatatypeDefinitionToAttributeDefinitionMap.put((Enum)NativeDataType.BRANCH_IDENTIFIER, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionInteger)attributeDefinition).setType((DatatypeDefinitionInteger)datatypeDefinition));
        reqifAttachDatatypeDefinitionToAttributeDefinitionMap.put((Enum)NativeDataType.BOOLEAN, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionBoolean)attributeDefinition).setType((DatatypeDefinitionBoolean)datatypeDefinition));
        reqifAttachDatatypeDefinitionToAttributeDefinitionMap.put((Enum)NativeDataType.DATE, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionDate)attributeDefinition).setType((DatatypeDefinitionDate)datatypeDefinition));
        reqifAttachDatatypeDefinitionToAttributeDefinitionMap.put((Enum)NativeDataType.DOUBLE, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionReal)attributeDefinition).setType((DatatypeDefinitionReal)datatypeDefinition));
        reqifAttachDatatypeDefinitionToAttributeDefinitionMap.put((Enum)NativeDataType.ENUMERATED, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionString)attributeDefinition).setType((DatatypeDefinitionString)datatypeDefinition));
        reqifAttachDatatypeDefinitionToAttributeDefinitionMap.put((Enum)NativeDataType.INPUT_STREAM, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionString)attributeDefinition).setType((DatatypeDefinitionString)datatypeDefinition));
        reqifAttachDatatypeDefinitionToAttributeDefinitionMap.put((Enum)NativeDataType.INTEGER, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionInteger)attributeDefinition).setType((DatatypeDefinitionInteger)datatypeDefinition));
        reqifAttachDatatypeDefinitionToAttributeDefinitionMap.put((Enum)NativeDataType.JAVA_OBJECT, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionString)attributeDefinition).setType((DatatypeDefinitionString)datatypeDefinition));
        reqifAttachDatatypeDefinitionToAttributeDefinitionMap.put((Enum)NativeDataType.LONG, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionInteger)attributeDefinition).setType((DatatypeDefinitionInteger)datatypeDefinition));
        reqifAttachDatatypeDefinitionToAttributeDefinitionMap.put((Enum)NativeDataType.STRING, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionString)attributeDefinition).setType((DatatypeDefinitionString)datatypeDefinition));
        reqifAttachDatatypeDefinitionToAttributeDefinitionMap.put((Enum)NativeDataType.STRING_WORD_ML, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionXHTML)attributeDefinition).setType((DatatypeDefinitionXHTML)datatypeDefinition));
        reqifAttachDatatypeDefinitionToAttributeDefinitionMap.put((Enum)NativeDataType.URI, (attributeDefinition, datatypeDefinition) -> ((AttributeDefinitionString)attributeDefinition).setType((DatatypeDefinitionString)datatypeDefinition));
        reqifAttributeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.ARTIFACT_IDENTIFIER, ReqIFSynchronizationArtifactBuilder::convertAttributeDefinitionReqIfAttributeDefinitionIntegerForArtifactId);
        reqifAttributeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.BRANCH_IDENTIFIER, ReqIFSynchronizationArtifactBuilder::convertAttributeDefinitionReqIfAttributeDefinitionIntegerForBranchId);
        reqifAttributeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.BOOLEAN, ReqIFSynchronizationArtifactBuilder::convertAttributeDefinitionReqIfAttributeDefinitionBoolean);
        reqifAttributeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.DATE, ReqIFSynchronizationArtifactBuilder::convertAttributeDefinitionReqIfAttributeDefinitionDate);
        reqifAttributeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.DOUBLE, ReqIFSynchronizationArtifactBuilder::convertAttributeDefinitionReqIfAttributeDefinitionDouble);
        reqifAttributeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.INTEGER, ReqIFSynchronizationArtifactBuilder::convertAttributeDefinitionReqIfAttributeDefinitionIntegerForInteger);
        reqifAttributeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.LONG, ReqIFSynchronizationArtifactBuilder::convertAttributeDefinitionReqIfAttributeDefinitionIntegerForLong);
        reqifAttributeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.STRING, ReqIFSynchronizationArtifactBuilder::convertAttributeDefinitionReqIfAttributeDefinitionString);
        reqifAttributeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.STRING_WORD_ML, ReqIFSynchronizationArtifactBuilder::convertAttributeDefinitionReqIfAttributeDefinitionXHTML);
        reqifAttributeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.URI, ReqIFSynchronizationArtifactBuilder::convertAttributeDefinitionReqIfAttributeDefinitionString);
        reqifAttributeDefinitionFactoryMap.put((Enum)NativeDataType.ARTIFACT_IDENTIFIER, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionInteger());
        reqifAttributeDefinitionFactoryMap.put((Enum)NativeDataType.BRANCH_IDENTIFIER, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionInteger());
        reqifAttributeDefinitionFactoryMap.put((Enum)NativeDataType.BOOLEAN, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionBoolean());
        reqifAttributeDefinitionFactoryMap.put((Enum)NativeDataType.DATE, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionDate());
        reqifAttributeDefinitionFactoryMap.put((Enum)NativeDataType.DOUBLE, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionReal());
        reqifAttributeDefinitionFactoryMap.put((Enum)NativeDataType.ENUMERATED, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionString());
        reqifAttributeDefinitionFactoryMap.put((Enum)NativeDataType.INPUT_STREAM, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionString());
        reqifAttributeDefinitionFactoryMap.put((Enum)NativeDataType.INTEGER, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionInteger());
        reqifAttributeDefinitionFactoryMap.put((Enum)NativeDataType.JAVA_OBJECT, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionString());
        reqifAttributeDefinitionFactoryMap.put((Enum)NativeDataType.LONG, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionInteger());
        reqifAttributeDefinitionFactoryMap.put((Enum)NativeDataType.STRING, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionString());
        reqifAttributeDefinitionFactoryMap.put((Enum)NativeDataType.STRING_WORD_ML, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionXHTML());
        reqifAttributeDefinitionFactoryMap.put((Enum)NativeDataType.URI, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeDefinitionString());
        reqifAttributeValueFactoryMap.put((Enum)NativeDataType.ARTIFACT_IDENTIFIER, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeValueInteger());
        reqifAttributeValueFactoryMap.put((Enum)NativeDataType.BRANCH_IDENTIFIER, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeValueInteger());
        reqifAttributeValueFactoryMap.put((Enum)NativeDataType.BOOLEAN, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeValueBoolean());
        reqifAttributeValueFactoryMap.put((Enum)NativeDataType.DATE, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeValueDate());
        reqifAttributeValueFactoryMap.put((Enum)NativeDataType.DOUBLE, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeValueReal());
        reqifAttributeValueFactoryMap.put((Enum)NativeDataType.ENUMERATED, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeValueString());
        reqifAttributeValueFactoryMap.put((Enum)NativeDataType.INPUT_STREAM, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeValueString());
        reqifAttributeValueFactoryMap.put((Enum)NativeDataType.INTEGER, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeValueInteger());
        reqifAttributeValueFactoryMap.put((Enum)NativeDataType.JAVA_OBJECT, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeValueString());
        reqifAttributeValueFactoryMap.put((Enum)NativeDataType.LONG, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeValueInteger());
        reqifAttributeValueFactoryMap.put((Enum)NativeDataType.STRING, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeValueString());
        reqifAttributeValueFactoryMap.put((Enum)NativeDataType.STRING_WORD_ML, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeValueXHTML());
        reqifAttributeValueFactoryMap.put((Enum)NativeDataType.URI, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createAttributeValueString());
        reqifAttributeValueSetterMap.put((Enum)NativeDataType.ARTIFACT_IDENTIFIER, (value, attributeValue) -> ((AttributeValueInteger)attributeValue).setTheValue(DataConverters.idToBigInteger((Id)value)));
        reqifAttributeValueSetterMap.put((Enum)NativeDataType.BRANCH_IDENTIFIER, (value, attributeValue) -> ((AttributeValueInteger)attributeValue).setTheValue(DataConverters.idToBigInteger((Id)value)));
        reqifAttributeValueSetterMap.put((Enum)NativeDataType.BOOLEAN, (value, attributeValue) -> ((AttributeValueBoolean)attributeValue).setTheValue(((Boolean)value).booleanValue()));
        reqifAttributeValueSetterMap.put((Enum)NativeDataType.DATE, (value, attributeValue) -> ((AttributeValueDate)attributeValue).setTheValue(DataConverters.dateToGregorianCalendar((Date)value)));
        reqifAttributeValueSetterMap.put((Enum)NativeDataType.DOUBLE, (value, attributeValue) -> ((AttributeValueReal)attributeValue).setTheValue(((Double)value).doubleValue()));
        reqifAttributeValueSetterMap.put((Enum)NativeDataType.INTEGER, (value, attributeValue) -> ((AttributeValueInteger)attributeValue).setTheValue(DataConverters.integerToBigInteger((Integer)value)));
        reqifAttributeValueSetterMap.put((Enum)NativeDataType.LONG, (value, attributeValue) -> ((AttributeValueInteger)attributeValue).setTheValue(DataConverters.longToBigInteger((Long)value)));
        reqifAttributeValueSetterMap.put((Enum)NativeDataType.STRING, (value, attributeValue) -> ((AttributeValueString)attributeValue).setTheValue((String)value));
        reqifAttributeValueSetterMap.put((Enum)NativeDataType.STRING_WORD_ML, (value, attributeValue) -> ((AttributeValueXHTML)attributeValue).setTheValue(DataConverters.wordMlStringToXhtmlContent((String)value)));
        reqifAttributeValueSetterMap.put((Enum)NativeDataType.URI, (value, attributeValue) -> ((AttributeValueString)attributeValue).setTheValue((String)value));
        reqifDatatypeDefinitionFactoryMap.put((Enum)NativeDataType.ARTIFACT_IDENTIFIER, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionInteger());
        reqifDatatypeDefinitionFactoryMap.put((Enum)NativeDataType.BRANCH_IDENTIFIER, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionInteger());
        reqifDatatypeDefinitionFactoryMap.put((Enum)NativeDataType.BOOLEAN, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionBoolean());
        reqifDatatypeDefinitionFactoryMap.put((Enum)NativeDataType.DATE, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionDate());
        reqifDatatypeDefinitionFactoryMap.put((Enum)NativeDataType.DOUBLE, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionReal());
        reqifDatatypeDefinitionFactoryMap.put((Enum)NativeDataType.ENUMERATED, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionString());
        reqifDatatypeDefinitionFactoryMap.put((Enum)NativeDataType.INPUT_STREAM, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionString());
        reqifDatatypeDefinitionFactoryMap.put((Enum)NativeDataType.INTEGER, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionInteger());
        reqifDatatypeDefinitionFactoryMap.put((Enum)NativeDataType.JAVA_OBJECT, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionString());
        reqifDatatypeDefinitionFactoryMap.put((Enum)NativeDataType.LONG, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionInteger());
        reqifDatatypeDefinitionFactoryMap.put((Enum)NativeDataType.STRING, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionString());
        reqifDatatypeDefinitionFactoryMap.put((Enum)NativeDataType.STRING_WORD_ML, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionXHTML());
        reqifDatatypeDefinitionFactoryMap.put((Enum)NativeDataType.URI, () -> ((ReqIF10Factory)ReqIF10Factory.eINSTANCE).createDatatypeDefinitionString());
        reqifDatatypeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.ARTIFACT_IDENTIFIER, ReqIFSynchronizationArtifactBuilder::convertDataTypeDefinitionReqIfDatatypeDefinitionInteger);
        reqifDatatypeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.BRANCH_IDENTIFIER, ReqIFSynchronizationArtifactBuilder::convertDataTypeDefinitionReqIfDatatypeDefinitionInteger);
        reqifDatatypeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.DOUBLE, ReqIFSynchronizationArtifactBuilder::convertDataTypeDefinitionReqIfDatatypeDefinitionReal);
        reqifDatatypeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.INPUT_STREAM, ReqIFSynchronizationArtifactBuilder::convertDataTypeDefinitionReqIfDatatypeDefinitionString);
        reqifDatatypeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.INTEGER, ReqIFSynchronizationArtifactBuilder::convertDataTypeDefinitionReqIfDatatypeDefinitionInteger);
        reqifDatatypeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.JAVA_OBJECT, ReqIFSynchronizationArtifactBuilder::convertDataTypeDefinitionReqIfDatatypeDefinitionString);
        reqifDatatypeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.LONG, ReqIFSynchronizationArtifactBuilder::convertDataTypeDefinitionReqIfDatatypeDefinitionInteger);
        reqifDatatypeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.STRING, ReqIFSynchronizationArtifactBuilder::convertDataTypeDefinitionReqIfDatatypeDefinitionString);
        reqifDatatypeDefinitionDatatypeConverterMap.put((Enum)NativeDataType.URI, ReqIFSynchronizationArtifactBuilder::convertDataTypeDefinitionReqIfDatatypeDefinitionString);
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.ARTIFACT_IDENTIFIER, new ReqifDatatypeIntegerRecord(Long.MAX_VALUE, Long.MIN_VALUE));
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.BRANCH_IDENTIFIER, new ReqifDatatypeIntegerRecord(Long.MAX_VALUE, Long.MIN_VALUE));
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.DOUBLE, new ReqifDatatypeDoubleRecord(64L, (Double)Double.MAX_VALUE, (Double)Double.MIN_VALUE));
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.INPUT_STREAM, new ReqifDatatypeStringRecord(0x100000L));
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.INTEGER, new ReqifDatatypeIntegerRecord((Long)Integer.MAX_VALUE, (Long)Integer.MIN_VALUE));
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.JAVA_OBJECT, new ReqifDatatypeStringRecord(1024L));
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.LONG, new ReqifDatatypeIntegerRecord(Long.MAX_VALUE, Long.MIN_VALUE));
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.STRING, new ReqifDatatypeStringRecord(8192L));
        reqifDatatypeDefinitionRecordMap.put(NativeDataType.URI, new ReqifDatatypeStringRecord(2048L));
    }

    @Override
    public Optional<Consumer<GroveThing>> getConverter(IdentifierType identifierType) {
        return converterMap.getFunction((Enum)identifierType);
    }

    @Override
    public boolean build(SynchronizationArtifact synchronizationArtifact) {
        HeaderGrove headerGrove = (HeaderGrove)synchronizationArtifact.getGrove(IdentifierType.HEADER);
        DataTypeDefinitionGrove datatypeDefinitionGrove = (DataTypeDefinitionGrove)synchronizationArtifact.getGrove(IdentifierType.DATA_TYPE_DEFINITION);
        SpecTypeGrove specTypeGrove = (SpecTypeGrove)synchronizationArtifact.getGrove(IdentifierType.SPECIFICATION_TYPE);
        SpecObjectTypeGrove specObjectTypeGrove = (SpecObjectTypeGrove)synchronizationArtifact.getGrove(IdentifierType.SPEC_OBJECT_TYPE);
        SpecificationGrove specificationGrove = (SpecificationGrove)synchronizationArtifact.getGrove(IdentifierType.SPECIFICATION);
        SpecObjectGrove specObjectGrove = (SpecObjectGrove)synchronizationArtifact.getGrove(IdentifierType.SPEC_OBJECT);
        AttributeValueGrove attributeValueGrove = (AttributeValueGrove)synchronizationArtifact.getGrove(IdentifierType.ATTRIBUTE_VALUE);
        headerGrove.stream().forEach(header -> this.reqIf.setTheHeader((ReqIFHeader)header.getForeignThing()));
        ReqIFContent reqifContent = ReqIF10Factory.eINSTANCE.createReqIFContent();
        this.reqIf.setCoreContent(reqifContent);
        EList reqifDatatypeDefinitionList = reqifContent.getDatatypes();
        datatypeDefinitionGrove.stream().forEach(datatypeDefinition -> {
            boolean bl = reqifDatatypeDefinitionList.add((Object)((DatatypeDefinition)datatypeDefinition.getForeignThing()));
        });
        EList reqifSpecTypeList = reqifContent.getSpecTypes();
        Stream.concat(specTypeGrove.stream(), specObjectTypeGrove.stream()).forEach(groveThing -> {
            CommonObjectTypeGroveThing commonObjectType = (CommonObjectTypeGroveThing)groveThing;
            SpecType reqifSpecType = (SpecType)groveThing.getForeignThing();
            reqifSpecTypeList.add((Object)reqifSpecType);
            EList reqifAttributeDefinitionList = reqifSpecType.getSpecAttributes();
            commonObjectType.streamAttributeDefinitions().forEach(attributeDefinition -> {
                reqifAttributeDefinitionList.add((Object)((AttributeDefinition)attributeDefinition.getForeignThing()));
                AttributeDefinition reqifAttributeDefinition = (AttributeDefinition)attributeDefinition.getForeignThing();
                DataTypeDefinitionGroveThing datatypeDefinition = attributeDefinition.getDataTypeDefinition();
                NativeDataType nativeDataType = (NativeDataType)datatypeDefinition.getNativeThing();
                DatatypeDefinition reqifDatatypeDefinition = (DatatypeDefinition)datatypeDefinition.getForeignThing();
                reqifAttachDatatypeDefinitionToAttributeDefinitionMap.accept((Enum)nativeDataType, (Object)reqifAttributeDefinition, (Object)reqifDatatypeDefinition);
            });
        });
        EList reqifSpecificationList = reqifContent.getSpecifications();
        specificationGrove.stream().forEach(groveThing -> {
            SpecificationGroveThing specification = (SpecificationGroveThing)groveThing;
            Specification reqifSpecification = (Specification)groveThing.getForeignThing();
            CommonObjectTypeGroveThing commonObjectType = specification.getCommonObjectType();
            SpecificationType reqifSpecificationType = (SpecificationType)commonObjectType.getForeignThing();
            reqifSpecification.setType(reqifSpecificationType);
            reqifSpecificationList.add((Object)reqifSpecification);
        });
        EList reqifSpecObjectList = reqifContent.getSpecObjects();
        specObjectGrove.stream().forEach(groveThing -> {
            if (groveThing instanceof SpecificationGroveThing) {
                return;
            }
            SpecObjectGroveThing specObject = (SpecObjectGroveThing)groveThing;
            SpecObject reqifSpecObject = (SpecObject)groveThing.getForeignThing();
            CommonObjectTypeGroveThing commonObjectType = specObject.getCommonObjectType();
            SpecObjectType reqifSpecObjectType = (SpecObjectType)commonObjectType.getForeignThing();
            reqifSpecObject.setType(reqifSpecObjectType);
            reqifSpecObjectList.add((Object)reqifSpecObject);
        });
        attributeValueGrove.stream().forEach(groveThing -> {
            AttributeValueGroveThing attributeValue = (AttributeValueGroveThing)groveThing;
            AttributeValue reqifAttributeValue = (AttributeValue)attributeValue.getForeignThing();
            CommonObjectGroveThing commonObject = attributeValue.getParent();
            SpecElementWithAttributes reqifSpecElementWithAttributes = (SpecElementWithAttributes)commonObject.getForeignThing();
            EList reqifAttributeValueList = reqifSpecElementWithAttributes.getValues();
            reqifAttributeValueList.add((Object)reqifAttributeValue);
            AttributeDefinitionGroveThing attributeDefinition = attributeValue.getAttributeDefinition();
            DataTypeDefinitionGroveThing datatypeDefinition = attributeDefinition.getDataTypeDefinition();
            NativeDataType nativeDataType = (NativeDataType)datatypeDefinition.getNativeThing();
            AttributeDefinition reqifAttributeDefinition = (AttributeDefinition)attributeDefinition.getForeignThing();
            reqifAttachAttributeDefinitionToAttributeValueMap.accept((Enum)nativeDataType, (Object)reqifAttributeValue, (Object)reqifAttributeDefinition);
        });
        specObjectGrove.streamRootGroveThingKeys().forEach(specificationIdentifier -> {
            SpecificationGroveThing specification = specObjectGrove.getSpecification((IdentifierType.Identifier)specificationIdentifier);
            Specification reqifSpecification = (Specification)specification.getForeignThing();
            EList specificationReqifChildren = reqifSpecification.getChildren();
            specification.setForeignHierarchy(specificationReqifChildren);
            specObjectGrove.forEachGroveThing((IdentifierType.Identifier)specificationIdentifier, (parentIdentifier, commonObjectIdentifier) -> {
                SpecObjectGroveThing specObject = specObjectGrove.getSpecObject((IdentifierType.Identifier)specificationIdentifier, (IdentifierType.Identifier)commonObjectIdentifier);
                SpecObject reqifSpecObject = (SpecObject)specObject.getForeignThing();
                SpecHierarchy reqifSpecHierarchy = ReqIF10Factory.eINSTANCE.createSpecHierarchy();
                EList reqifChildren = reqifSpecHierarchy.getChildren();
                reqifSpecHierarchy.setObject(reqifSpecObject);
                specObject.setForeignHierarchy(reqifChildren);
                CommonObjectGroveThing parentSpecObject = specificationIdentifier.equals(parentIdentifier) ? specObjectGrove.getSpecification((IdentifierType.Identifier)specificationIdentifier) : specObjectGrove.getSpecObject((IdentifierType.Identifier)specificationIdentifier, (IdentifierType.Identifier)parentIdentifier);
                EList parentReqifChildren = (EList)parentSpecObject.getForeignHierarchy();
                parentReqifChildren.add((Object)reqifSpecHierarchy);
            });
        });
        ReqIFToolExtension reqifToolExtension = ReqIF10Factory.eINSTANCE.createReqIFToolExtension();
        this.reqIf.getToolExtensions().add((Object)reqifToolExtension);
        return false;
    }

    @Override
    public InputStream serialize() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("reqif", new ReqIF10ResourceFactoryImpl(){

            public Resource createResource(URI uri) {
                return new ReqIF10ResourceImpl(uri){

                    protected boolean useUUIDs() {
                        return false;
                    }
                };
            }
        });
        URI uri = URI.createFileURI((String)"o.reqif");
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)this.reqIf);
        var outputStream = new ByteArrayOutputStream(){

            byte[] getBuffer() {
                return this.buf;
            }
        };
        try {
            resource.save((OutputStream)outputStream, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Resource Save Failed", e);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.getBuffer(), 0, outputStream.size());
        return inputStream;
    }

    private static void convertAttributeValue(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing) && groveThing instanceof AttributeValueGroveThing);
        AttributeValueGroveThing attributeValue = (AttributeValueGroveThing)groveThing;
        Object nativeAttributeValue = groveThing.getNativeThing();
        AttributeDefinitionGroveThing attributeDefinition = attributeValue.getAttributeDefinition();
        DataTypeDefinitionGroveThing datatypeDefinition = attributeDefinition.getDataTypeDefinition();
        NativeDataType nativeDataType = (NativeDataType)datatypeDefinition.getNativeThing();
        AttributeValue reqifAttributeValue = (AttributeValue)reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        if (reqifAttributeValueSetterMap.containsKey((Enum)nativeDataType)) {
            reqifAttributeValueSetterMap.accept((Enum)nativeDataType, nativeAttributeValue, (Object)reqifAttributeValue);
        }
        attributeValue.setForeignThing(reqifAttributeValue);
    }

    private static void convertAttributeDefinition(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing) && groveThing instanceof AttributeDefinitionGroveThing);
        AttributeDefinitionGroveThing attributeDefinition = (AttributeDefinitionGroveThing)groveThing;
        AttributeTypeToken cfr_ignored_0 = (AttributeTypeToken)groveThing.getNativeThing();
        DataTypeDefinitionGroveThing datatypeDefinition = attributeDefinition.getDataTypeDefinition();
        NativeDataType nativeDataType = (NativeDataType)datatypeDefinition.getNativeThing();
        AttributeDefinition reqifAttributeDefinition = (AttributeDefinition)reqifAttributeDefinitionFactoryMap.get((Enum)nativeDataType);
        ReqIFSynchronizationArtifactBuilder.convertAttributeDefinitionReqIfAttributeDefinition(attributeDefinition, reqifAttributeDefinition);
        if (reqifAttributeDefinitionDatatypeConverterMap.containsKey((Enum)nativeDataType)) {
            reqifAttributeDefinitionDatatypeConverterMap.accept((Enum)nativeDataType, (Object)attributeDefinition, (Object)reqifAttributeDefinition);
        }
        attributeDefinition.setForeignThing(reqifAttributeDefinition);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinition(AttributeDefinitionGroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        String description = nativeAttributeTypeToken.getDescription();
        if (description == null || description.isEmpty()) {
            description = new StringBuilder(512).append("OSEE ").append(nativeAttributeTypeToken.getName()).append(" Attribute Definition").toString();
        }
        reqifAttributeDefinition.setDesc(description);
        reqifAttributeDefinition.setIdentifier(attributeDefinitionGroveThing.getGroveThingKey().toString());
        reqifAttributeDefinition.setLastChange(lastChangeEpoch);
        reqifAttributeDefinition.setLongName(nativeAttributeTypeToken.getName());
        reqifAttributeDefinition.setEditable(!nativeAttributeTypeToken.notEditable());
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionBoolean(AttributeDefinitionGroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeBoolean);
        AttributeTypeBoolean nativeAttributeTypeBoolean = (AttributeTypeBoolean)nativeAttributeTypeToken;
        Boolean defaultValue = (Boolean)nativeAttributeTypeBoolean.getBaseAttributeTypeDefaultValue();
        assert (reqifAttributeDefinition instanceof AttributeDefinitionBoolean);
        AttributeDefinitionBoolean reqifAttributeDefinitionBoolean = (AttributeDefinitionBoolean)reqifAttributeDefinition;
        DataTypeDefinitionGroveThing datatypeDefinition = attributeDefinitionGroveThing.getDataTypeDefinition();
        NativeDataType nativeDataType = (NativeDataType)datatypeDefinition.getNativeThing();
        assert (nativeDataType.equals(NativeDataType.BOOLEAN));
        AttributeValueBoolean defaultAttributeValue = (AttributeValueBoolean)reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        defaultAttributeValue.setTheValue(defaultValue.booleanValue());
        reqifAttributeDefinitionBoolean.setDefaultValue(defaultAttributeValue);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionDate(AttributeDefinitionGroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeDate);
        AttributeTypeDate nativeAttributeTypeDate = (AttributeTypeDate)nativeAttributeTypeToken;
        Date defaultValue = (Date)nativeAttributeTypeDate.getBaseAttributeTypeDefaultValue();
        assert (reqifAttributeDefinition instanceof AttributeDefinitionDate);
        AttributeDefinitionDate reqifAttributeDefinitionDate = (AttributeDefinitionDate)reqifAttributeDefinition;
        DataTypeDefinitionGroveThing datatypeDefinition = attributeDefinitionGroveThing.getDataTypeDefinition();
        NativeDataType nativeDataType = (NativeDataType)datatypeDefinition.getNativeThing();
        assert (nativeDataType.equals(NativeDataType.DATE));
        AttributeValueDate defaultAttributeValue = (AttributeValueDate)reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        defaultAttributeValue.setTheValue(DataConverters.dateToGregorianCalendar(defaultValue));
        reqifAttributeDefinitionDate.setDefaultValue(defaultAttributeValue);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionDouble(AttributeDefinitionGroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeDouble);
        AttributeTypeDouble nativeAttributeTypeDouble = (AttributeTypeDouble)nativeAttributeTypeToken;
        Double defaultValue = (Double)nativeAttributeTypeDouble.getBaseAttributeTypeDefaultValue();
        assert (reqifAttributeDefinition instanceof AttributeDefinitionReal);
        AttributeDefinitionReal reqifAttributeDefinitionReal = (AttributeDefinitionReal)reqifAttributeDefinition;
        DataTypeDefinitionGroveThing datatypeDefinition = attributeDefinitionGroveThing.getDataTypeDefinition();
        NativeDataType nativeDataType = (NativeDataType)datatypeDefinition.getNativeThing();
        assert (nativeDataType.equals(NativeDataType.DOUBLE));
        AttributeValueReal defaultAttributeValue = (AttributeValueReal)reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        defaultAttributeValue.setTheValue(defaultValue.doubleValue());
        reqifAttributeDefinitionReal.setDefaultValue(defaultAttributeValue);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionIntegerForArtifactId(AttributeDefinitionGroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeArtifactId);
        AttributeTypeArtifactId nativeAttributeTypeArtifactId = (AttributeTypeArtifactId)nativeAttributeTypeToken;
        Long defaultValue = ((ArtifactId)nativeAttributeTypeArtifactId.getBaseAttributeTypeDefaultValue()).getId();
        assert (reqifAttributeDefinition instanceof AttributeDefinitionInteger);
        AttributeDefinitionInteger reqifAttributeDefinitionInteger = (AttributeDefinitionInteger)reqifAttributeDefinition;
        DataTypeDefinitionGroveThing datatypeDefinition = attributeDefinitionGroveThing.getDataTypeDefinition();
        NativeDataType nativeDataType = (NativeDataType)datatypeDefinition.getNativeThing();
        assert (nativeDataType.equals(NativeDataType.ARTIFACT_IDENTIFIER));
        AttributeValueInteger defaultAttributeValue = (AttributeValueInteger)reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        defaultAttributeValue.setTheValue(BigInteger.valueOf(defaultValue));
        reqifAttributeDefinitionInteger.setDefaultValue(defaultAttributeValue);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionIntegerForBranchId(AttributeDefinitionGroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeBranchId);
        AttributeTypeBranchId nativeAttributeTypeBranchId = (AttributeTypeBranchId)nativeAttributeTypeToken;
        Long defaultValue = ((BranchId)nativeAttributeTypeBranchId.getBaseAttributeTypeDefaultValue()).getId();
        assert (reqifAttributeDefinition instanceof AttributeDefinitionInteger);
        AttributeDefinitionInteger reqifAttributeDefinitionInteger = (AttributeDefinitionInteger)reqifAttributeDefinition;
        DataTypeDefinitionGroveThing datatypeDefinition = attributeDefinitionGroveThing.getDataTypeDefinition();
        NativeDataType nativeDataType = (NativeDataType)datatypeDefinition.getNativeThing();
        assert (nativeDataType.equals(NativeDataType.ARTIFACT_IDENTIFIER));
        AttributeValueInteger defaultAttributeValue = (AttributeValueInteger)reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        defaultAttributeValue.setTheValue(BigInteger.valueOf(defaultValue));
        reqifAttributeDefinitionInteger.setDefaultValue(defaultAttributeValue);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionIntegerForInteger(AttributeDefinitionGroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeInteger);
        AttributeTypeInteger nativeAttributeTypeInteger = (AttributeTypeInteger)nativeAttributeTypeToken;
        Integer defaultValue = (Integer)nativeAttributeTypeInteger.getBaseAttributeTypeDefaultValue();
        assert (reqifAttributeDefinition instanceof AttributeDefinitionInteger);
        AttributeDefinitionInteger reqifAttributeDefinitionInteger = (AttributeDefinitionInteger)reqifAttributeDefinition;
        DataTypeDefinitionGroveThing datatypeDefinition = attributeDefinitionGroveThing.getDataTypeDefinition();
        NativeDataType nativeDataType = (NativeDataType)datatypeDefinition.getNativeThing();
        assert (nativeDataType.equals(NativeDataType.INTEGER));
        AttributeValueInteger defaultAttributeValue = (AttributeValueInteger)reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        defaultAttributeValue.setTheValue(BigInteger.valueOf(defaultValue.intValue()));
        reqifAttributeDefinitionInteger.setDefaultValue(defaultAttributeValue);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionIntegerForLong(AttributeDefinitionGroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeLong);
        AttributeTypeLong nativeAttributeTypeLong = (AttributeTypeLong)nativeAttributeTypeToken;
        Long defaultValue = (Long)nativeAttributeTypeLong.getBaseAttributeTypeDefaultValue();
        assert (reqifAttributeDefinition instanceof AttributeDefinitionInteger);
        AttributeDefinitionInteger reqifAttributeDefinitionInteger = (AttributeDefinitionInteger)reqifAttributeDefinition;
        DataTypeDefinitionGroveThing datatypeDefinition = attributeDefinitionGroveThing.getDataTypeDefinition();
        NativeDataType nativeDataType = (NativeDataType)datatypeDefinition.getNativeThing();
        assert (nativeDataType.equals(NativeDataType.LONG));
        AttributeValueInteger defaultAttributeValue = (AttributeValueInteger)reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        defaultAttributeValue.setTheValue(BigInteger.valueOf(defaultValue));
        reqifAttributeDefinitionInteger.setDefaultValue(defaultAttributeValue);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionString(AttributeDefinitionGroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeString) : "Actual Type: " + nativeAttributeTypeToken.getClass().getName();
        AttributeTypeString nativeAttributeTypeString = (AttributeTypeString)nativeAttributeTypeToken;
        String defaultValue = (String)nativeAttributeTypeString.getBaseAttributeTypeDefaultValue();
        if (defaultValue.isEmpty()) {
            return;
        }
        assert (reqifAttributeDefinition instanceof AttributeDefinitionString);
        AttributeDefinitionString reqifAttributeDefinitionString = (AttributeDefinitionString)reqifAttributeDefinition;
        DataTypeDefinitionGroveThing datatypeDefinition = attributeDefinitionGroveThing.getDataTypeDefinition();
        NativeDataType nativeDataType = (NativeDataType)datatypeDefinition.getNativeThing();
        AttributeValueString defaultAttributeValue = (AttributeValueString)reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        defaultAttributeValue.setTheValue(defaultValue);
        reqifAttributeDefinitionString.setDefaultValue(defaultAttributeValue);
    }

    private static void convertAttributeDefinitionReqIfAttributeDefinitionXHTML(AttributeDefinitionGroveThing attributeDefinitionGroveThing, AttributeDefinition reqifAttributeDefinition) {
        AttributeTypeToken nativeAttributeTypeToken = (AttributeTypeToken)attributeDefinitionGroveThing.getNativeThing();
        assert (nativeAttributeTypeToken instanceof AttributeTypeString) : "Actual Type: " + nativeAttributeTypeToken.getClass().getName();
        AttributeTypeString nativeAttributeTypeString = (AttributeTypeString)nativeAttributeTypeToken;
        String defaultValue = (String)nativeAttributeTypeString.getBaseAttributeTypeDefaultValue();
        if (defaultValue.isEmpty()) {
            return;
        }
        assert (reqifAttributeDefinition instanceof AttributeDefinitionXHTML);
        AttributeDefinitionXHTML reqifAttributeDefinitionXHTML = (AttributeDefinitionXHTML)reqifAttributeDefinition;
        DataTypeDefinitionGroveThing datatypeDefinition = attributeDefinitionGroveThing.getDataTypeDefinition();
        NativeDataType nativeDataType = (NativeDataType)datatypeDefinition.getNativeThing();
        AttributeValueXHTML defaultAttributeValue = (AttributeValueXHTML)reqifAttributeValueFactoryMap.get((Enum)nativeDataType);
        XhtmlContent xhtmlContent = DataConverters.wordMlStringToXhtmlContent(defaultValue);
        defaultAttributeValue.setTheValue(xhtmlContent);
        reqifAttributeDefinitionXHTML.setDefaultValue(defaultAttributeValue);
    }

    private static void convertDataTypeDefinition(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing) && groveThing instanceof DataTypeDefinitionGroveThing);
        DataTypeDefinitionGroveThing dataTypeDefinition = (DataTypeDefinitionGroveThing)groveThing;
        NativeDataType nativeDataType = (NativeDataType)groveThing.getNativeThing();
        DatatypeDefinition reqifDatatypeDefinition = (DatatypeDefinition)reqifDatatypeDefinitionFactoryMap.get((Enum)nativeDataType);
        ReqIFSynchronizationArtifactBuilder.convertDataTypeDefinitionReqIfDatatypeDefinition(dataTypeDefinition, reqifDatatypeDefinition);
        if (reqifDatatypeDefinitionDatatypeConverterMap.containsKey((Enum)nativeDataType)) {
            reqifDatatypeDefinitionDatatypeConverterMap.accept((Enum)nativeDataType, (Object)dataTypeDefinition, (Object)reqifDatatypeDefinition);
        }
        dataTypeDefinition.setForeignThing(reqifDatatypeDefinition);
    }

    private static void convertDataTypeDefinitionReqIfDatatypeDefinition(DataTypeDefinitionGroveThing dataTypeDefinitionGroveThing, DatatypeDefinition reqifDatatypeDefinition) {
        NativeDataType nativeDataType = (NativeDataType)dataTypeDefinitionGroveThing.getNativeThing();
        reqifDatatypeDefinition.setDesc(nativeDataType.toString());
        reqifDatatypeDefinition.setIdentifier(dataTypeDefinitionGroveThing.getGroveThingKey().toString());
        reqifDatatypeDefinition.setLastChange(lastChangeEpoch);
        reqifDatatypeDefinition.setLongName(nativeDataType.name());
    }

    private static void convertDataTypeDefinitionReqIfDatatypeDefinitionInteger(DataTypeDefinitionGroveThing dataTypeDefinitionGroveThing, DatatypeDefinition reqifDatatypeDefinition) {
        assert (reqifDatatypeDefinition instanceof DatatypeDefinitionInteger);
        DatatypeDefinitionInteger reqifDatatypeDefinitionInteger = (DatatypeDefinitionInteger)reqifDatatypeDefinition;
        NativeDataType nativeDataType = (NativeDataType)dataTypeDefinitionGroveThing.getNativeThing();
        assert (reqifDatatypeDefinitionRecordMap.containsKey(nativeDataType));
        ReqifDatatypeRecord reqifDatatypeRecord = reqifDatatypeDefinitionRecordMap.get(nativeDataType);
        assert (reqifDatatypeRecord instanceof ReqifDatatypeIntegerRecord);
        ReqifDatatypeIntegerRecord reqifDatatypeIntegerRecord = (ReqifDatatypeIntegerRecord)reqifDatatypeRecord;
        reqifDatatypeDefinitionInteger.setMax(BigInteger.valueOf(reqifDatatypeIntegerRecord.max));
        reqifDatatypeDefinitionInteger.setMin(BigInteger.valueOf(reqifDatatypeIntegerRecord.min));
    }

    private static void convertDataTypeDefinitionReqIfDatatypeDefinitionReal(DataTypeDefinitionGroveThing dataTypeDefinitionGroveThing, DatatypeDefinition reqifDatatypeDefinition) {
        assert (reqifDatatypeDefinition instanceof DatatypeDefinitionReal);
        DatatypeDefinitionReal reqifDatatypeDefinitionReal = (DatatypeDefinitionReal)reqifDatatypeDefinition;
        NativeDataType nativeDataType = (NativeDataType)dataTypeDefinitionGroveThing.getNativeThing();
        assert (reqifDatatypeDefinitionRecordMap.containsKey(nativeDataType));
        ReqifDatatypeRecord reqifDatatypeRecord = reqifDatatypeDefinitionRecordMap.get(nativeDataType);
        assert (reqifDatatypeRecord instanceof ReqifDatatypeDoubleRecord);
        ReqifDatatypeDoubleRecord reqifDatatypeDoubleRecord = (ReqifDatatypeDoubleRecord)reqifDatatypeRecord;
        reqifDatatypeDefinitionReal.setAccuracy(BigInteger.valueOf(reqifDatatypeDoubleRecord.accuracy));
        reqifDatatypeDefinitionReal.setMax(reqifDatatypeDoubleRecord.max.doubleValue());
        reqifDatatypeDefinitionReal.setMin(reqifDatatypeDoubleRecord.min.doubleValue());
    }

    private static void convertDataTypeDefinitionReqIfDatatypeDefinitionString(DataTypeDefinitionGroveThing dataTypeDefinitionGroveThing, DatatypeDefinition reqifDatatypeDefinition) {
        assert (reqifDatatypeDefinition instanceof DatatypeDefinitionString);
        DatatypeDefinitionString reqifDatatypeDefinitionString = (DatatypeDefinitionString)reqifDatatypeDefinition;
        NativeDataType nativeDataType = (NativeDataType)dataTypeDefinitionGroveThing.getNativeThing();
        assert (reqifDatatypeDefinitionRecordMap.containsKey(nativeDataType));
        ReqifDatatypeRecord reqifDatatypeRecord = reqifDatatypeDefinitionRecordMap.get(nativeDataType);
        assert (reqifDatatypeRecord instanceof ReqifDatatypeStringRecord);
        ReqifDatatypeStringRecord reqifDatatypeStringRecord = (ReqifDatatypeStringRecord)reqifDatatypeRecord;
        reqifDatatypeDefinitionString.setMaxLength(BigInteger.valueOf(reqifDatatypeStringRecord.maxLength));
    }

    private static void convertHeader(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing) && groveThing instanceof HeaderGroveThing);
        HeaderGroveThing header = (HeaderGroveThing)groveThing;
        ReqIFHeader reqifHeader = ReqIF10Factory.eINSTANCE.createReqIFHeader();
        reqifHeader.setComment(header.getComment());
        reqifHeader.setIdentifier(header.getGroveThingKey().toString());
        reqifHeader.setRepositoryId(header.getRepositoryId());
        reqifHeader.setReqIFVersion("1.0.1");
        reqifHeader.setSourceToolId(header.getSourceToolId());
        reqifHeader.setReqIFToolId(String.valueOf(ReqIFSynchronizationArtifactBuilder.class.getName()) + ":" + version);
        reqifHeader.setCreationTime(header.getTime());
        reqifHeader.setTitle(header.getTitle());
        header.setForeignThing(reqifHeader);
    }

    private static void convertSpecification(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing) && groveThing instanceof SpecificationGroveThing);
        SpecificationGroveThing specification = (SpecificationGroveThing)groveThing;
        ArtifactReadable nativeArtifactReadable = (ArtifactReadable)groveThing.getNativeThing();
        Specification reqifSpecification = ReqIF10Factory.eINSTANCE.createSpecification();
        String description = new StringBuilder(512).append("OSEE ").append(nativeArtifactReadable.getName()).append(" SpecificationGroveThing").toString();
        reqifSpecification.setDesc(description);
        reqifSpecification.setIdentifier(specification.getGroveThingKey().toString());
        reqifSpecification.setLastChange(lastChangeEpoch);
        reqifSpecification.setLongName(nativeArtifactReadable.getName());
        specification.setForeignThing(reqifSpecification);
    }

    private static void convertSpecObject(GroveThing groveThing) {
        if (groveThing instanceof SpecificationGroveThing) {
            return;
        }
        assert (Objects.nonNull(groveThing) && groveThing instanceof SpecObjectGroveThing);
        SpecObjectGroveThing specObject = (SpecObjectGroveThing)groveThing;
        ArtifactReadable nativeArtifactReadable = (ArtifactReadable)groveThing.getNativeThing();
        SpecObject reqifSpecObject = ReqIF10Factory.eINSTANCE.createSpecObject();
        reqifSpecObject.setDesc(nativeArtifactReadable.getClass().getName());
        reqifSpecObject.setIdentifier(groveThing.getGroveThingKey().toString());
        reqifSpecObject.setLastChange(lastChangeEpoch);
        reqifSpecObject.setLongName(nativeArtifactReadable.getName());
        specObject.setForeignThing(reqifSpecObject);
    }

    private static void convertSpecObjectType(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing) && groveThing instanceof SpecObjectTypeGroveThing);
        SpecObjectTypeGroveThing specObjectType = (SpecObjectTypeGroveThing)groveThing;
        ArtifactTypeToken nativeArtifactTypeToken = (ArtifactTypeToken)groveThing.getNativeThing();
        SpecObjectType reqifSpecObjectType = ReqIF10Factory.eINSTANCE.createSpecObjectType();
        String description = new StringBuilder(512).append("OSEE ").append(nativeArtifactTypeToken.getName()).append(" Spec Object Type").toString();
        reqifSpecObjectType.setDesc(description);
        reqifSpecObjectType.setIdentifier(specObjectType.getGroveThingKey().toString());
        reqifSpecObjectType.setLastChange(lastChangeEpoch);
        reqifSpecObjectType.setLongName(nativeArtifactTypeToken.getName());
        specObjectType.setForeignThing(reqifSpecObjectType);
    }

    private static void convertSpecType(GroveThing groveThing) {
        assert (Objects.nonNull(groveThing) && groveThing instanceof SpecTypeGroveThing);
        SpecTypeGroveThing specType = (SpecTypeGroveThing)groveThing;
        ArtifactTypeToken nativeArtifactTypeToken = (ArtifactTypeToken)groveThing.getNativeThing();
        SpecificationType reqifSpecificationType = ReqIF10Factory.eINSTANCE.createSpecificationType();
        String description = new StringBuilder(512).append("OSEE ").append(nativeArtifactTypeToken.getName()).append(" SpecificationGroveThing Type").toString();
        reqifSpecificationType.setDesc(description);
        reqifSpecificationType.setIdentifier(specType.getGroveThingKey().toString());
        reqifSpecificationType.setLastChange(lastChangeEpoch);
        reqifSpecificationType.setLongName(nativeArtifactTypeToken.getName());
        specType.setForeignThing(reqifSpecificationType);
    }

    private static class ReqifDatatypeDoubleRecord
    implements ReqifDatatypeRecord {
        final Long accuracy;
        final Double max;
        final Double min;

        ReqifDatatypeDoubleRecord(Long accuracy, Double max, Double min) {
            this.accuracy = accuracy;
            this.max = max;
            this.min = min;
        }
    }

    private static class ReqifDatatypeIntegerRecord
    implements ReqifDatatypeRecord {
        final Long max;
        final Long min;

        ReqifDatatypeIntegerRecord(Long max, Long min) {
            this.max = max;
            this.min = min;
        }
    }

    private static interface ReqifDatatypeRecord {
    }

    private static class ReqifDatatypeStringRecord
    implements ReqifDatatypeRecord {
        final Long maxLength;

        ReqifDatatypeStringRecord(Long maxLength) {
            this.maxLength = maxLength;
        }
    }
}

