/*********************************************************************
 * Copyright (c) 2004, 2007 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.framework.ui.branch.graph.parts;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.ui.branch.graph.model.BranchModel;
import org.eclipse.osee.framework.ui.branch.graph.model.GraphCache;
import org.eclipse.osee.framework.ui.branch.graph.model.TxModel;

/**
 * @author Roberto E. Escobar
 */
public class GraphEditPartFactory implements EditPartFactory {

   private final GraphicalViewer viewer;

   public GraphEditPartFactory(GraphicalViewer viewer) {
      this.viewer = viewer;
   }

   @Override
   public EditPart createEditPart(EditPart context, Object model) {
      EditPart editPart = null;
      if (model instanceof String) {
         editPart = new LabelEditPart((String) model);
      } else if (model instanceof GraphCache) {
         editPart = new GraphEditPart(viewer);
      } else if (model instanceof BranchModel) {
         editPart = new BranchEditPart();
      } else if (model instanceof BranchId) {
         editPart = new BranchDataEditPart();
      } else if (model instanceof TxModel) {
         editPart = new TxEditPart();
      }
      if (editPart == null) {
         throw new RuntimeException(String.format("Error no EditPart defined for: [%s]", model.getClass().getName()));
      } else {
         editPart.setModel(model);
      }
      return editPart;
   }

}
