/*********************************************************************
 * Copyright (c) 2016 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.framework.skynet.core.change;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.TransactionDelta;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

/**
 * @author Angel Avila
 */
public class TupleChange extends Change {

   private final String isValue;
   private final String wasValue;
   private final String itemKind;
   private final TupleTypeId itemTypeId;

   public TupleChange(BranchId branch, GammaId sourceGamma, TransactionDelta txDelta, ModificationType modType, TupleTypeId itemTypeId, String isValue, String wasValue, String itemKind, boolean isHistorical) {
      super(branch, sourceGamma, ArtifactId.valueOf(0L), txDelta, modType, isHistorical, Artifact.SENTINEL, null);
      this.itemTypeId = itemTypeId;
      this.isValue = isValue;
      this.wasValue = wasValue;
      this.itemKind = itemKind;
   }

   @Override
   public TupleTypeId getItemTypeId() {
      return itemTypeId;
   }

   @Override
   public String getIsValue() {
      return isValue;
   }

   @Override
   public String getWasValue() {
      return wasValue;
   }

   @Override
   public String getItemTypeName() {
      return itemTypeId.getIdString();
   }

   @Override
   public String getName() {
      return "N/A";
   }

   @Override
   public String getNameOrToken() {
      return "N/A";
   }

   @Override
   public String getItemKind() {
      return itemKind;
   }

   @Override
   public Id getItemId() {
      return getGamma();
   }

   @Override
   public ChangeType getChangeType() {
      return ChangeType.Tuple;
   }
}
