/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.aries.util.internal.BundleToClassLoaderAdapter;
import org.apache.aries.util.internal.FrameworkUtilWorker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;

public class DefaultWorker
implements FrameworkUtilWorker,
BundleListener,
FrameworkListener {
    private Map<Bundle, ClassLoader> classLoaders = new IdentityHashMap<Bundle, ClassLoader>();
    private static final Bundle myFrameworkBundle;

    public ClassLoader getClassLoader(final Bundle b) {
        ClassLoader cl = this.get(b);
        if (cl != null) {
            return cl;
        }
        String activator = (String)b.getHeaders().get("Bundle-Activator");
        if (activator != null) {
            try {
                Class clazz = b.loadClass(activator);
                Bundle activatorBundle = FrameworkUtil.getBundle((Class)clazz);
                if (activatorBundle == b) {
                    cl = clazz.getClassLoader();
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (cl == null) {
            cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return new BundleToClassLoaderAdapter(b);
                }
            });
        }
        if (cl != null) {
            this.setupListener(b);
            cl = this.put(b, cl);
        }
        return cl;
    }

    private void setupListener(Bundle b) {
        BundleContext ctx = b.getBundleContext().getBundle(0L).getBundleContext();
        ctx.addBundleListener((BundleListener)this);
        ctx.addFrameworkListener((FrameworkListener)this);
    }

    private synchronized ClassLoader put(Bundle b, ClassLoader cl) {
        if (b.getState() == 1 || b.getState() == 2) {
            return null;
        }
        ClassLoader previous = this.classLoaders.put(b, cl);
        if (previous != null) {
            cl = previous;
            this.classLoaders.put(b, cl);
        }
        return cl;
    }

    private synchronized ClassLoader get(Bundle b) {
        return this.classLoaders.get(b);
    }

    private synchronized void remove(Bundle bundle) {
        this.classLoaders.remove(bundle);
    }

    public boolean isValid() {
        return true;
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16 || event.getType() == 64) {
            Bundle b = event.getBundle();
            this.remove(b);
            if (b.getBundleId() == 0L) {
                this.clearBundles(b);
            }
        }
    }

    private void clearBundles(Bundle b) {
        Bundle[] bundles;
        BundleContext ctx = b.getBundleContext();
        ctx.removeBundleListener((BundleListener)this);
        for (Bundle bundle : bundles = ctx.getBundles()) {
            this.remove(bundle);
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 64) {
            Bundle b = event.getBundle();
            if (b == myFrameworkBundle) {
                this.classLoaders.clear();
            } else if (b != null) {
                this.clearBundles(b);
            }
            b.getBundleContext().removeFrameworkListener((FrameworkListener)this);
        }
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(DefaultWorker.class);
        BundleContext myContext = bundle == null ? null : bundle.getBundleContext();
        myFrameworkBundle = myContext != null ? myContext.getBundle(0L) : null;
    }
}

