/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.xnavigate;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Shell;

public class XNavigateItemAction
extends XNavigateItem {
    private final Action action;
    private boolean promptFirst = false;

    public XNavigateItemAction(XNavigateItem parent, String name) {
        this(parent, name, null);
    }

    public XNavigateItemAction(XNavigateItem parent, String name, KeyedImage oseeImage) {
        this(parent, name, false, oseeImage);
    }

    public XNavigateItemAction(XNavigateItem parent, String name, boolean promptFirst, KeyedImage oseeImage) {
        super(parent, name, oseeImage);
        this.action = null;
        this.promptFirst = promptFirst;
    }

    public XNavigateItemAction(XNavigateItem parent, Action action, KeyedImage oseeImage) {
        this(parent, action, oseeImage, false);
    }

    public XNavigateItemAction(XNavigateItem parent, Action action, KeyedImage oseeImage, boolean promptFirst) {
        super(parent, action.getText(), oseeImage);
        this.action = action;
        this.promptFirst = promptFirst;
    }

    @Override
    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) throws Exception {
        if (this.action != null) {
            if (this.promptFirst) {
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)XNavigateItemAction.this.getName(), (String)(String.valueOf(XNavigateItemAction.this.getName()) + "?"))) {
                            XNavigateItemAction.this.action.run();
                        }
                    }
                });
            } else if (this.action.getStyle() == 2) {
                this.action.setChecked(!this.action.isChecked());
                if (this.action.isChecked()) {
                    this.action.run();
                }
            } else {
                this.action.run();
            }
        }
    }

    public boolean isPromptFirst() {
        return this.promptFirst;
    }

    public void setPromptFirst(boolean promptFirst) {
        this.promptFirst = promptFirst;
    }
}

