/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.xnavigate;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.OseeActivator;
import org.eclipse.osee.framework.plugin.core.util.ExtensionPoints;
import org.eclipse.osee.framework.ui.plugin.xnavigate.IXNavigateContainer;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateExtensionPointData;
import org.osgi.framework.Bundle;

public final class XNavigateContributionManager {
    private XNavigateContributionManager() {
    }

    public static Set<XNavigateExtensionPointData> getNavigateItems(String viewIdToMatch) {
        Conditions.checkNotNull((Object)viewIdToMatch, (String)"viewIdToMatch");
        HashSet<XNavigateExtensionPointData> toReturn = new HashSet<XNavigateExtensionPointData>();
        List elements = ExtensionPoints.getExtensionElements((String)"org.eclipse.osee.framework.ui.plugin.XNavigateItem", (String)"XNavigateItem");
        for (IConfigurationElement element : elements) {
            IXNavigateContainer navigateContainer;
            String viewId = element.getAttribute("viewId");
            if (!viewIdToMatch.equals(viewId)) continue;
            String className = element.getAttribute("classname");
            String bundleName = element.getContributor().getName();
            if (!Strings.isValid((String)bundleName) || !Strings.isValid((String)className) || (navigateContainer = XNavigateContributionManager.createXNavigateContainer(className, bundleName)) == null) continue;
            String category = element.getAttribute("category");
            XNavigateExtensionPointData data = XNavigateContributionManager.createXNavigateData(viewId, category, navigateContainer);
            toReturn.add(data);
        }
        return toReturn;
    }

    private static XNavigateExtensionPointData createXNavigateData(String viewId, String category, IXNavigateContainer navigateContainer) {
        String categoryToSet = category != null ? category : "";
        return new XNavigateExtensionPointData(viewId, categoryToSet, navigateContainer);
    }

    private static IXNavigateContainer createXNavigateContainer(String className, String bundleName) {
        IXNavigateContainer toReturn = null;
        Bundle bundle = Platform.getBundle((String)bundleName);
        try {
            Class taskClass = bundle.loadClass(className);
            try {
                Method getInstance = taskClass.getMethod("getInstance", new Class[0]);
                toReturn = (IXNavigateContainer)getInstance.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                toReturn = (IXNavigateContainer)taskClass.newInstance();
            }
        }
        catch (Exception ex) {
            OseeLog.logf(OseeActivator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Unable to Load: [%s - %s]", (Object[])new Object[]{bundleName, className});
        }
        catch (LinkageError error) {
            OseeLog.logf(OseeActivator.class, (Level)Level.SEVERE, (Throwable)error, (String)"Unable to Load: [%s - %s]", (Object[])new Object[]{bundleName, className});
        }
        return toReturn;
    }
}

