/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.demo.populate;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.AgileEndpointApi;
import org.eclipse.osee.ats.api.agile.AgileWriterResult;
import org.eclipse.osee.ats.api.agile.IAgileProgram;
import org.eclipse.osee.ats.api.agile.IAgileProgramBacklog;
import org.eclipse.osee.ats.api.agile.IAgileProgramBacklogItem;
import org.eclipse.osee.ats.api.agile.IAgileProgramFeature;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileStory;
import org.eclipse.osee.ats.api.agile.JaxAgileItem;
import org.eclipse.osee.ats.api.agile.JaxAgileProgram;
import org.eclipse.osee.ats.api.agile.JaxAgileProgramBacklog;
import org.eclipse.osee.ats.api.agile.JaxAgileProgramBacklogItem;
import org.eclipse.osee.ats.api.agile.JaxAgileProgramFeature;
import org.eclipse.osee.ats.api.agile.JaxAgileStory;
import org.eclipse.osee.ats.api.agile.JaxNewAgileBacklog;
import org.eclipse.osee.ats.api.agile.JaxNewAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxNewAgileSprint;
import org.eclipse.osee.ats.api.agile.JaxNewAgileTeam;
import org.eclipse.osee.ats.api.config.JaxAtsObject;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.demo.AtsDemoOseeTypes;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelper;
import org.eclipse.osee.ats.ide.demo.SprintItemData;
import org.eclipse.osee.ats.ide.demo.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DemoUsers;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.SevereLoggingMonitor;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.support.test.util.TestUtil;

public class Pdd93CreateDemoAgile {
    private AgileEndpointApi agileEp;

    private static void validateArtifactCache() {
        Collection list = ArtifactCache.getDirtyArtifacts();
        if (!list.isEmpty()) {
            XResultData results = new XResultData();
            for (Artifact artifact : list) {
                results.errorf("Artifact [%s] is dirty [%s]\n", new Object[]{artifact.toStringWithId(), Artifacts.getDirtyReport((Artifact)artifact)});
            }
            throw new OseeStateException("[%d] Dirty Artifacts found after populate\n\n %s ", new Object[]{list.size(), results.toString()});
        }
    }

    public void run() throws Exception {
        this.agileEp = AtsApiService.get().getServerEndpoints().getAgile();
        Pdd93CreateDemoAgile.validateArtifactCache();
        AtsApiService.get().reloadServerAndClientCaches();
        SevereLoggingMonitor monitorLog = TestUtil.severeLoggingStart();
        IAgileProgram aProgram = this.createAgileProgram();
        this.createSawAgileTeam(aProgram);
        this.createCisAgileTeam(aProgram);
        this.createProgramBacklogAndFeaturesAndStories(aProgram);
        this.createAgileStandAloneTeam();
        TestUtil.severeLoggingEnd((SevereLoggingMonitor)monitorLog);
    }

    private void createProgramBacklogAndFeaturesAndStories(IAgileProgram aProgram) {
        JaxAgileProgramBacklog jaxProgramBacklog = JaxAgileProgramBacklog.construct((IAgileProgram)aProgram, (ArtifactToken)DemoArtifactToken.RD_Program_Backlog);
        IAgileProgramBacklog programBacklog = AtsApiService.get().getAgileService().createAgileProgramBacklog(aProgram, jaxProgramBacklog);
        JaxAgileProgramBacklogItem backlogItem1 = JaxAgileProgramBacklogItem.construct((IAgileProgramBacklog)programBacklog, (ArtifactToken)DemoArtifactToken.RD_Program_Backlog_Item_1);
        IAgileProgramBacklogItem item = AtsApiService.get().getAgileService().createAgileProgramBacklogItem(programBacklog, backlogItem1);
        JaxAgileProgramBacklogItem item2 = JaxAgileProgramBacklogItem.construct((IAgileProgramBacklog)programBacklog, (ArtifactToken)DemoArtifactToken.RD_Program_Backlog_Item_2);
        AtsApiService.get().getAgileService().createAgileProgramBacklogItem(programBacklog, item2);
        JaxAgileProgramBacklogItem item3 = JaxAgileProgramBacklogItem.construct((IAgileProgramBacklog)programBacklog, (ArtifactToken)DemoArtifactToken.RD_Program_Backlog_Item_3);
        AtsApiService.get().getAgileService().createAgileProgramBacklogItem(programBacklog, item3);
        JaxAgileProgramFeature jaxFeature = JaxAgileProgramFeature.construct((IAgileProgramBacklogItem)backlogItem1, (ArtifactToken)DemoArtifactToken.RD_Program_Feature_Robot_Nav);
        IAgileProgramFeature feature = AtsApiService.get().getAgileService().createAgileProgramFeature(item, jaxFeature);
        JaxAgileStory jaxStory1 = JaxAgileStory.construct((IAgileProgramFeature)feature, (ArtifactToken)DemoArtifactToken.RD_Robot_Nav_Story_1);
        IAgileStory story1 = AtsApiService.get().getAgileService().createAgileStory(feature, jaxStory1);
        JaxAgileStory jaxStory2 = JaxAgileStory.construct((IAgileProgramFeature)feature, (ArtifactToken)DemoArtifactToken.RD_Robot_Nav_Story_2);
        IAgileStory story2 = AtsApiService.get().getAgileService().createAgileStory(feature, jaxStory2);
        JaxAgileStory jaxStory3 = JaxAgileStory.construct((IAgileProgramFeature)feature, (ArtifactToken)DemoArtifactToken.RD_Robot_Nav_Story_3);
        IAgileStory story3 = AtsApiService.get().getAgileService().createAgileStory(feature, jaxStory3);
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Add Agile Items to Stories");
        IAtsTeamWorkflow codeWf = AtsApiService.get().getQueryService().getTeamWf((ArtifactId)DemoArtifactToken.SAW_Commited_Code_TeamWf);
        AtsApiService.get().getAgileService().setAgileStory(codeWf, story1, changes);
        IAtsTeamWorkflow testWf = AtsApiService.get().getQueryService().getTeamWf((ArtifactId)DemoArtifactToken.SAW_Commited_Test_TeamWf);
        AtsApiService.get().getAgileService().setAgileStory(testWf, story1, changes);
        IAtsTeamWorkflow reqWf = AtsApiService.get().getQueryService().getTeamWf((ArtifactId)DemoArtifactToken.SAW_Commited_Req_TeamWf);
        ArtifactToken story1Art = AtsApiService.get().getQueryService().getArtifact((IAtsObject)story1);
        ArtifactToken agileTeamArt = AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_Agile_Team);
        changes.relate((Object)story1Art, AtsRelationTypes.AgileStoryToAgileTeam_AgileTeam, (Object)agileTeamArt);
        ArtifactToken sprint2Art = AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_Sprint_2);
        changes.relate((Object)story1Art, AtsRelationTypes.AgileStoryToSprint_AgileSprint, (Object)sprint2Art);
        ArtifactToken story2Art = AtsApiService.get().getQueryService().getArtifact((IAtsObject)story2);
        changes.relate((Object)story2Art, AtsRelationTypes.AgileStoryToAgileTeam_AgileTeam, (Object)agileTeamArt);
        changes.relate((Object)story2Art, AtsRelationTypes.AgileStoryToSprint_AgileSprint, (Object)sprint2Art);
        ArtifactToken story3Art = AtsApiService.get().getQueryService().getArtifact((IAtsObject)story3);
        changes.relate((Object)story3Art, AtsRelationTypes.AgileStoryToAgileTeam_AgileTeam, (Object)agileTeamArt);
        changes.relate((Object)story3Art, AtsRelationTypes.AgileStoryToSprint_AgileSprint, (Object)sprint2Art);
        AtsApiService.get().getAgileService().setAgileStory(reqWf, story1, changes);
        changes.relate((Object)story1Art, AtsRelationTypes.AgileStoryToItem_TeamWorkflow, (Object)reqWf);
        IAtsTeamWorkflow codeWf2 = AtsApiService.get().getQueryService().getTeamWf((ArtifactId)DemoArtifactToken.SAW_UnCommited_Code_TeamWf);
        AtsApiService.get().getAgileService().setAgileStory(codeWf2, story2, changes);
        IAtsTeamWorkflow testWf2 = AtsApiService.get().getQueryService().getTeamWf((ArtifactId)DemoArtifactToken.SAW_UnCommited_Test_TeamWf);
        AtsApiService.get().getAgileService().setAgileStory(testWf2, story2, changes);
        IAtsTeamWorkflow reqWf2 = AtsApiService.get().getQueryService().getTeamWf((ArtifactId)DemoArtifactToken.SAW_UnCommited_Req_TeamWf);
        AtsApiService.get().getAgileService().setAgileStory(reqWf2, story2, changes);
        IAtsTeamWorkflow codeWf3 = AtsApiService.get().getQueryService().getTeamWf((ArtifactId)DemoArtifactToken.SAW_NoBranch_Code_TeamWf);
        AtsApiService.get().getAgileService().setAgileStory(codeWf3, story3, changes);
        IAtsTeamWorkflow testWf3 = AtsApiService.get().getQueryService().getTeamWf((ArtifactId)DemoArtifactToken.SAW_NoBranch_Test_TeamWf);
        AtsApiService.get().getAgileService().setAgileStory(testWf3, story3, changes);
        IAtsTeamWorkflow reqWf3 = AtsApiService.get().getQueryService().getTeamWf((ArtifactId)DemoArtifactToken.SAW_NoBranch_Req_TeamWf);
        AtsApiService.get().getAgileService().setAgileStory(reqWf3, story3, changes);
        changes.execute();
        Artifact progArt = AtsApiService.get().getQueryServiceIde().getArtifact((Object)aProgram);
        RelationManager.setRelationOrder((Artifact)progArt, (RelationTypeToken)CoreRelationTypes.DefaultHierarchical_Child, (RelationSide)RelationSide.SIDE_B, (RelationSorter)RelationSorter.UNORDERED, (List)progArt.getChildren());
        progArt.persist("Set Relation Order");
        jaxFeature = JaxAgileProgramFeature.construct((IAgileProgramBacklogItem)backlogItem1, (ArtifactToken)DemoArtifactToken.RD_Program_Feature_Robot_Voice);
        AtsApiService.get().getAgileService().createAgileProgramFeature(item, jaxFeature);
    }

    private void createAgileStandAloneTeam() {
        long teamId = 999L;
        JaxNewAgileTeam newTeam = new JaxNewAgileTeam();
        newTeam.setName("Facilities Team");
        newTeam.setId(Long.valueOf(teamId));
        Response response = AtsApiService.get().getServerEndpoints().getAgile().createTeam(newTeam);
        Assert.isTrue((Response.Status.CREATED.getStatusCode() == response.getStatus() ? 1 : 0) != 0);
        JaxNewAgileBacklog backlog = new JaxNewAgileBacklog();
        backlog.setName("Facilities Backlog");
        backlog.setId(Long.valueOf(9991L));
        backlog.setTeamId(newTeam.getId().longValue());
        response = this.agileEp.createBacklog(teamId, backlog);
        Assert.isTrue((Response.Status.CREATED.getStatusCode() == response.getStatus() ? 1 : 0) != 0);
    }

    private void createCisAgileTeam(IAgileProgram aProgram) {
        JaxNewAgileTeam newTeam = new JaxNewAgileTeam();
        newTeam.setName(DemoArtifactToken.CIS_Agile_Team.getName());
        newTeam.setId(DemoArtifactToken.CIS_Agile_Team.getId());
        newTeam.setProgramId(aProgram.getIdString());
        Response response = this.agileEp.createTeam(newTeam);
        Assert.isTrue((Response.Status.CREATED.getStatusCode() == response.getStatus() ? 1 : 0) != 0);
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Config Agile Team with points attr type");
        Artifact sawAgileTeam = AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)DemoArtifactToken.CIS_Agile_Team);
        changes.setSoleAttributeValue((ArtifactId)sawAgileTeam, (AttributeTypeToken)AtsAttributeTypes.PointsAttributeType, (Object)AtsAttributeTypes.Points.getName());
        changes.execute();
        JaxNewAgileBacklog backlog = new JaxNewAgileBacklog();
        backlog.setName(DemoArtifactToken.CIS_Backlog.getName());
        backlog.setId(DemoArtifactToken.CIS_Backlog.getId());
        backlog.setTeamId(newTeam.getId().longValue());
        response = this.agileEp.createBacklog(DemoArtifactToken.CIS_Agile_Team.getId().longValue(), backlog);
        Assert.isTrue((Response.Status.CREATED.getStatusCode() == response.getStatus() ? 1 : 0) != 0);
    }

    private IAgileProgram createAgileProgram() {
        JaxAgileProgram jProgram = new JaxAgileProgram();
        jProgram.setName(DemoArtifactToken.RD_Agile_Program.getName());
        jProgram.setId(DemoArtifactToken.RD_Agile_Program.getId());
        IAgileProgram aProgram = AtsApiService.get().getAgileService().createAgileProgram((IAgileProgram)jProgram);
        return aProgram;
    }

    private void createSawAgileTeam(IAgileProgram aProgram) {
        AgileEndpointApi agile = this.agileEp;
        JaxNewAgileTeam newTeam = this.getJaxAgileTeam();
        newTeam.setProgramId(aProgram.getId().toString());
        Response response = agile.createTeam(newTeam);
        Assert.isTrue((Response.Status.CREATED.getStatusCode() == response.getStatus() ? 1 : 0) != 0);
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Config Agile Team with points attr type");
        Artifact sawAgileTeam = AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)DemoArtifactToken.SAW_Agile_Team);
        changes.setSoleAttributeValue((ArtifactId)sawAgileTeam, (AttributeTypeToken)AtsAttributeTypes.PointsAttributeType, (Object)AtsAttributeTypes.Points.getName());
        changes.execute();
        Artifact sawCodeArt = AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)DemoArtifactToken.SAW_Code);
        Conditions.assertNotNull((Object)sawCodeArt, (String)"sawCodeArt", (Object[])new Object[0]);
        Artifact agileTeam = AtsApiService.get().getQueryServiceIde().getArtifact((Object)newTeam.getId());
        agileTeam.addRelation(AtsRelationTypes.AgileTeamToAtsTeam_AtsTeam, sawCodeArt);
        agileTeam.persist("Assigne ATS Team to Agile Team");
        Artifact joeUser = AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)DemoUsers.Joe_Smith);
        agileTeam.addRelation(CoreRelationTypes.Users_User, joeUser);
        Artifact kayUser = AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)DemoUsers.Kay_Jones);
        agileTeam.addRelation(CoreRelationTypes.Users_User, kayUser);
        agileTeam.persist("Add Team Members to Agile Team");
        JaxNewAgileBacklog backlog = this.getBacklog();
        response = agile.createBacklog(DemoArtifactToken.SAW_Agile_Team.getId().longValue(), backlog);
        Assert.isTrue((Response.Status.CREATED.getStatusCode() == response.getStatus() ? 1 : 0) != 0);
        Collection items = AtsApiService.get().getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).isOfType(new ArtifactTypeToken[]{AtsDemoOseeTypes.DemoCodeTeamWorkflow, AtsDemoOseeTypes.DemoReqTeamWorkflow, AtsDemoOseeTypes.DemoTestTeamWorkflow}).getItems();
        Assert.isTrue((items.size() > 0 ? 1 : 0) != 0);
        JaxAgileItem item = new JaxAgileItem();
        item.setBacklogId(backlog.getId().longValue());
        item.setSetBacklog(true);
        for (IAtsWorkItem workItem : items) {
            item.getIds().add(workItem.getId());
        }
        AgileWriterResult result = agile.updateItems(item);
        Conditions.assertFalse((boolean)result.getResults().isErrors(), (String)result.getResults().toString(), (Object[])new Object[0]);
        Artifact backlogArt = AtsApiService.get().getQueryServiceIde().getArtifact((Object)backlog.getId());
        RelationManager.setRelationOrder((Artifact)backlogArt, (RelationTypeToken)AtsRelationTypes.Goal_Member, (RelationSide)RelationSide.SIDE_B, (RelationSorter)RelationSorter.USER_DEFINED, (List)backlogArt.getRelatedArtifacts(AtsRelationTypes.Goal_Member));
        backlogArt.persist("Set Backlog Order");
        JaxNewAgileSprint sprint1 = this.newSprint(DemoArtifactToken.SAW_Sprint_1);
        response = agile.createSprint(sprint1.getTeamId(), sprint1);
        Assert.isTrue((Response.Status.CREATED.getStatusCode() == response.getStatus() ? 1 : 0) != 0);
        JaxNewAgileSprint sprint2 = this.newSprint(DemoArtifactToken.SAW_Sprint_2);
        response = agile.createSprint(sprint2.getTeamId(), sprint2);
        Assert.isTrue((Response.Status.CREATED.getStatusCode() == response.getStatus() ? 1 : 0) != 0);
        JaxAgileItem completedItems = new JaxAgileItem();
        completedItems.setSprintId(DemoArtifactToken.SAW_Sprint_1.getId().longValue());
        completedItems.setSetSprint(true);
        JaxAgileItem inworkItems = new JaxAgileItem();
        inworkItems.setSprintId(DemoArtifactToken.SAW_Sprint_2.getId().longValue());
        inworkItems.setSetSprint(true);
        for (IAtsWorkItem workItem : items) {
            if (workItem.getStateMgr().getStateType().isCompleted()) {
                completedItems.getIds().add(workItem.getId());
                continue;
            }
            inworkItems.getIds().add(workItem.getId());
        }
        result = agile.updateItems(inworkItems);
        Conditions.assertFalse((boolean)result.getResults().isErrors(), (String)result.getResults().toString(), (Object[])new Object[0]);
        result = agile.updateItems(completedItems);
        Conditions.assertFalse((boolean)result.getResults().isErrors(), (String)result.getResults().toString(), (Object[])new Object[0]);
        Artifact sprint1Art = AtsApiService.get().getQueryServiceIde().getArtifact((Object)sprint1.getId());
        RelationManager.setRelationOrder((Artifact)sprint1Art, (RelationTypeToken)AtsRelationTypes.AgileSprintToItem_AtsItem, (RelationSide)RelationSide.SIDE_B, (RelationSorter)RelationSorter.USER_DEFINED, (List)sprint1Art.getRelatedArtifacts(AtsRelationTypes.AgileSprintToItem_AtsItem));
        sprint1Art.persist("Set sort order for Sprint 1");
        Artifact sprint2Art = AtsApiService.get().getQueryServiceIde().getArtifact((Object)sprint2.getId());
        RelationManager.setRelationOrder((Artifact)sprint2Art, (RelationTypeToken)AtsRelationTypes.AgileSprintToItem_AtsItem, (RelationSide)RelationSide.SIDE_B, (RelationSorter)RelationSorter.USER_DEFINED, (List)sprint2Art.getRelatedArtifacts(AtsRelationTypes.AgileSprintToItem_AtsItem));
        sprint2Art.persist("Set sort order for Sprint 2");
        changes.addAttribute((ArtifactId)agileTeam, (AttributeTypeToken)AtsAttributeTypes.KanbanStoryName, (Object)(String.valueOf(DemoUsers.Jason_Michael.getName()) + ":Jason Rockstar Michael"));
        changes.execute();
        IAtsWorkItem sprint = (IAtsWorkItem)AtsApiService.get().getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andIds(new Long[]{DemoArtifactToken.SAW_Sprint_1.getId()}).getItems().iterator().next();
        TransitionHelper helper = new TransitionHelper("Transition Agile Stprint", Arrays.asList(sprint), TeamState.Completed.getName(), null, null, changes, (AtsApi)AtsApiService.get(), new TransitionOption[]{TransitionOption.OverrideAssigneeCheck});
        TransitionResults results = AtsApiService.get().getWorkItemService().transition((ITransitionHelper)helper);
        if (results.isErrors()) {
            throw new OseeStateException("Exception transitioning sprint: %s", new Object[]{results.toString()});
        }
        for (String name : Arrays.asList("Communications", "UI", "Documentation", "Framework")) {
            JaxNewAgileFeatureGroup featureGroup = this.newFeatureGroup(name);
            response = agile.createFeatureGroup(DemoArtifactToken.SAW_Program.getId().longValue(), featureGroup);
            Assert.isTrue((Response.Status.CREATED.getStatusCode() == response.getStatus() ? 1 : 0) != 0);
        }
        this.setupSprint2ForBurndown(DemoArtifactToken.SAW_Sprint_2.getId());
    }

    private void setupSprint2ForBurndown(long secondSprintId) {
        IAtsWorkItem sprint = (IAtsWorkItem)AtsApiService.get().getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andIds(new Long[]{secondSprintId}).getItems().iterator().next();
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Setup Sprint 2 for Burndown");
        Calendar cal = Calendar.getInstance();
        cal.add(6, -5);
        Date holiday1 = null;
        Date holiday2 = null;
        while (!DateUtil.isWeekDay((Calendar)cal)) {
            cal.add(6, -1);
        }
        changes.setSoleAttributeValue((IAtsObject)sprint, (AttributeTypeToken)AtsAttributeTypes.StartDate, (Object)cal.getTime());
        int x = 1;
        int holidayDayNum = 5;
        x = 1;
        while (x <= 21) {
            cal.add(6, 1);
            while (!DateUtil.isWeekDay((Calendar)cal)) {
                cal.add(6, 1);
            }
            if (x == holidayDayNum) {
                holiday1 = cal.getTime();
            } else if (x == holidayDayNum + 1) {
                holiday2 = cal.getTime();
            }
            ++x;
        }
        changes.setSoleAttributeValue((IAtsObject)sprint, (AttributeTypeToken)AtsAttributeTypes.EndDate, (Object)cal.getTime());
        changes.setSoleAttributeValue((IAtsObject)sprint, (AttributeTypeToken)AtsAttributeTypes.UnplannedPoints, (Object)45);
        changes.setSoleAttributeValue((IAtsObject)sprint, (AttributeTypeToken)AtsAttributeTypes.PlannedPoints, (Object)200);
        changes.addAttribute((IAtsObject)sprint, (AttributeTypeToken)AtsAttributeTypes.Holiday, (Object)holiday1);
        changes.addAttribute((IAtsObject)sprint, (AttributeTypeToken)AtsAttributeTypes.Holiday, (Object)holiday2);
        Artifact agileTeamArt = AtsApiService.get().getQueryServiceIde().getArtifact((Object)sprint).getRelatedArtifact(AtsRelationTypes.AgileTeamToSprint_AgileTeam);
        changes.execute();
        this.setSprintItemData(agileTeamArt.getId(), (IAgileSprint)sprint);
    }

    private void setSprintItemData(Long teamId, IAgileSprint sprint) {
        LinkedList<SprintItemData> datas = new LinkedList<SprintItemData>();
        datas.add(new SprintItemData("Sprint Order", "Title", "Points", "Unplanned Work", "Feature Group", "CreatedDate"));
        datas.add(new SprintItemData("1", "Button W doesn't work on Situation Page", "8", " ", "Communications", "10/03/2016"));
        datas.add(new SprintItemData("2", "Can't load Diagram Tree", "4", "Unplanned Work", "Framework", "10/03/2016"));
        datas.add(new SprintItemData("3", "Can't see the Graph View", "8", "Unplanned Work", "Framework", "10/03/2016"));
        datas.add(new SprintItemData("4", "Problem in Diagram Tree", "40", " ", "Framework", "10/03/2016"));
        datas.add(new SprintItemData("5", "Problem with the Graph View", "8", " ", "Communications", "10/03/2016"));
        datas.add(new SprintItemData("6", "SAW (committed) Reqt Changes for Diagram View", "2", "Unplanned Work", "Framework", "10/03/2016"));
        datas.add(new SprintItemData("7", "SAW (committed) Reqt Changes for Diagram View", "8", " ", "Framework", "10/03/2016"));
        datas.add(new SprintItemData("8", "SAW (committed) Reqt Changes for Diagram View", "16", " ", "UI", "10/03/2016"));
        datas.add(new SprintItemData("9", "SAW (no-branch) Even More Requirement Changes for Diagram View", "32", " ", "Communications", "10/03/2016"));
        datas.add(new SprintItemData("10", "SAW (no-branch) Even More Requirement Changes for Diagram View", "40", " ", "Documentation", "10/03/2016"));
        datas.add(new SprintItemData("11", "SAW (no-branch) Even More Requirement Changes for Diagram View", "8", " ", "Documentation", "10/03/2016"));
        datas.add(new SprintItemData("12", "SAW (uncommitted) More Reqt Changes for Diagram View", "1", " ", "Communications", "10/03/2016"));
        datas.add(new SprintItemData("13", "SAW (uncommitted) More Reqt Changes for Diagram View", "6", " ", "Documentation", "10/03/2016"));
        datas.add(new SprintItemData("14", "SAW (uncommitted) More Reqt Changes for Diagram View", "32", " ", "Communications", "10/03/2016"));
        datas.add(new SprintItemData("15", DemoArtifactToken.SAW_UnCommitedConflicted_Req_TeamWf.getName(), "1", " ", "Communications", "10/03/2016"));
        datas.add(new SprintItemData("16", "Workaround for Graph View for SAW_Bld_2", "1", "Unplanned Work", "Communications", "10/03/2016"));
        datas.add(new SprintItemData("17", "Workaround for Graph View for SAW_Bld_3", "2", "Unplanned Work", "Communications", "10/03/2016"));
        int x = 1;
        for (JaxAtsObject jaxWorkItem : this.agileEp.getSprintItemsAsJax(teamId.longValue(), sprint.getId().longValue()).getAtsObjects()) {
            SprintItemData data;
            String featureGroupName;
            if (Strings.isValid((String)(featureGroupName = (data = this.getSprintData(datas, x++, jaxWorkItem)).getFeature()))) {
                this.agileEp.addFeatureGroup(jaxWorkItem.getId().longValue(), featureGroupName);
            }
            String unPlannedStr = data.getUnPlanned();
            boolean unPlanned = false;
            if (Strings.isValid((String)unPlannedStr) && unPlannedStr.toLowerCase().contains("un")) {
                unPlanned = true;
            }
            this.agileEp.setUnPlanned(jaxWorkItem.getId().longValue(), unPlanned);
            String points = data.getPoints();
            if (!Strings.isValid((String)points)) continue;
            this.agileEp.setPoints(jaxWorkItem.getId().longValue(), points);
        }
    }

    private SprintItemData getSprintData(List<SprintItemData> datas, int i, JaxAtsObject workItem) {
        for (SprintItemData data : datas) {
            if (!data.getOrder().equals(String.valueOf(i)) || !data.getTitle().equals(workItem.getName())) continue;
            return data;
        }
        return null;
    }

    private JaxNewAgileBacklog getBacklog() {
        JaxNewAgileBacklog backlog = new JaxNewAgileBacklog();
        backlog.setName(DemoArtifactToken.SAW_Backlog.getName());
        backlog.setId(DemoArtifactToken.SAW_Backlog.getId());
        backlog.setTeamId(DemoArtifactToken.SAW_Agile_Team.getId().longValue());
        return backlog;
    }

    private JaxNewAgileFeatureGroup newFeatureGroup(String name) {
        JaxNewAgileFeatureGroup group = new JaxNewAgileFeatureGroup();
        group.setName(name);
        group.setTeamId(DemoArtifactToken.SAW_Agile_Team.getId().longValue());
        group.setId(Lib.generateArtifactIdAsInt());
        return group;
    }

    private JaxNewAgileSprint newSprint(ArtifactToken token) {
        JaxNewAgileSprint newSprint = new JaxNewAgileSprint();
        newSprint.setName(token.getName());
        newSprint.setId(token.getId());
        newSprint.setTeamId(DemoArtifactToken.SAW_Agile_Team.getId().longValue());
        return newSprint;
    }

    private JaxNewAgileTeam getJaxAgileTeam() {
        JaxNewAgileTeam newTeam = new JaxNewAgileTeam();
        newTeam.setName(DemoArtifactToken.SAW_Agile_Team.getName());
        newTeam.setId(DemoArtifactToken.SAW_Agile_Team.getId());
        return newTeam;
    }
}

