/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.demo.navigate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.query.ReleasedOption;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.config.version.CreateNewVersionItem;
import org.eclipse.osee.ats.ide.config.version.ReleaseVersionItem;
import org.eclipse.osee.ats.ide.demo.internal.Activator;
import org.eclipse.osee.ats.ide.demo.internal.AtsApiService;
import org.eclipse.osee.ats.ide.demo.navigate.CreateGoalTestDemoArtifacts;
import org.eclipse.osee.ats.ide.navigate.IAtsNavigateItem;
import org.eclipse.osee.ats.ide.navigate.SearchNavigateItem;
import org.eclipse.osee.ats.ide.world.search.ArtifactTypeSearchItem;
import org.eclipse.osee.ats.ide.world.search.ArtifactTypeWithInheritenceSearchItem;
import org.eclipse.osee.ats.ide.world.search.ILazyTeamDefinitionProvider;
import org.eclipse.osee.ats.ide.world.search.NextVersionSearchItem;
import org.eclipse.osee.ats.ide.world.search.OpenWorkflowsByTeamDefSearchItem;
import org.eclipse.osee.ats.ide.world.search.VersionTargetedForTeamSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemFolder;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateUrlItem;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.util.DbConnectionUtility;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class DemoNavigateViewItems
implements IAtsNavigateItem {
    private static IAtsTeamDefinition getTeamDef(ArtifactToken team) {
        TeamDefinition results = null;
        if (!ClientSessionManager.isProductionDataStore()) {
            try {
                results = AtsApiService.get().getTeamDefinitionService().getTeamDefinitionById((ArtifactId)team);
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return results;
    }

    public List<XNavigateItem> getNavigateItems(XNavigateItem parentItem) {
        ArtifactToken[] teams = new ArtifactToken[]{DemoArtifactToken.Process_Team, DemoArtifactToken.Tools_Team, DemoArtifactToken.SAW_HW, DemoArtifactToken.SAW_Code, DemoArtifactToken.SAW_Test, DemoArtifactToken.SAW_SW_Design, DemoArtifactToken.SAW_Requirements, DemoArtifactToken.SAW_SW, DemoArtifactToken.CIS_SW, DemoArtifactToken.CIS_Code, DemoArtifactToken.CIS_Test, DemoArtifactToken.Facilities_Team};
        ArrayList<XNavigateItem> items = new ArrayList<XNavigateItem>();
        if (DbConnectionUtility.areOSEEServicesAvailable().isFalse()) {
            return items;
        }
        try {
            if (DemoNavigateViewItems.getTeamDef((ArtifactToken)DemoArtifactToken.Process_Team) == null) {
                return items;
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.INFO, (String)"Demo Teams Not Cofigured", (Throwable)ex);
            return items;
        }
        XNavigateItemFolder jhuItem = new XNavigateItemFolder(parentItem, "John Hopkins Univ (JHU)");
        new XNavigateUrlItem((XNavigateItem)jhuItem, "Open JHU Website - Externally", "http://www.jhu.edu/", true);
        new XNavigateUrlItem((XNavigateItem)jhuItem, "Open JHU Website - Internally", "http://www.jhu.edu/", false);
        items.add((XNavigateItem)jhuItem);
        ArtifactToken[] artifactTokenArray = teams;
        int n = teams.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactToken team = artifactTokenArray[n2];
            try {
                IAtsTeamDefinition teamDef = DemoNavigateViewItems.getTeamDef(team);
                XNavigateItemFolder teamItems = new XNavigateItemFolder((XNavigateItem)jhuItem, "JHU " + team.getName().replaceAll("_", " "));
                new SearchNavigateItem((XNavigateItem)teamItems, (WorldSearchItem)new OpenWorkflowsByTeamDefSearchItem("Show Open " + teamDef + " Workflows", (ILazyTeamDefinitionProvider)new SimpleTeamDefinitionProvider(Arrays.asList(teamDef))));
                for (IAtsTeamDefinition childTeamDef : AtsApiService.get().getTeamDefinitionService().getChildren(teamDef, true)) {
                    new SearchNavigateItem((XNavigateItem)teamItems, (WorldSearchItem)new OpenWorkflowsByTeamDefSearchItem("Show Open " + childTeamDef + " Workflows", (ILazyTeamDefinitionProvider)new SimpleTeamDefinitionProvider(Arrays.asList(childTeamDef))));
                }
                if (AtsApiService.get().getVersionService().isTeamUsesVersions(teamDef)) {
                    if (team.getName().contains("SAW")) {
                        new XNavigateUrlItem((XNavigateItem)teamItems, "Open SAW Website", "http://www.cisst.org/cisst/saw/", false);
                    } else if (team.getName().contains("CIS")) {
                        new XNavigateUrlItem((XNavigateItem)teamItems, "Open CIS Website", "http://www.cisst.org/cisst/cis/", false);
                    }
                    new SearchNavigateItem((XNavigateItem)teamItems, (WorldSearchItem)new NextVersionSearchItem(teamDef, WorldSearchItem.LoadView.WorldEditor));
                    new SearchNavigateItem((XNavigateItem)teamItems, (WorldSearchItem)new VersionTargetedForTeamSearchItem(teamDef, null, false, WorldSearchItem.LoadView.WorldEditor));
                    new SearchNavigateItem((XNavigateItem)teamItems, (WorldSearchItem)new OpenWorkflowsByTeamDefSearchItem("Show Un-Released Team Workflows", (ILazyTeamDefinitionProvider)new SimpleTeamDefinitionProvider(Arrays.asList(teamDef)), true, ReleasedOption.UnReleased));
                    new ReleaseVersionItem((XNavigateItem)teamItems, teamDef);
                    new CreateNewVersionItem((XNavigateItem)teamItems, teamDef);
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
            ++n2;
        }
        XNavigateItem adminItems = new XNavigateItem((XNavigateItem)jhuItem, "JHU Admin", (KeyedImage)FrameworkImage.LASER);
        new SearchNavigateItem(adminItems, (WorldSearchItem)new ArtifactTypeSearchItem("Show all Actions", AtsArtifactTypes.Action));
        new SearchNavigateItem(adminItems, (WorldSearchItem)new ArtifactTypeSearchItem("Show all Decision Review", AtsArtifactTypes.DecisionReview));
        new SearchNavigateItem(adminItems, (WorldSearchItem)new ArtifactTypeSearchItem("Show all PeerToPeer Review", AtsArtifactTypes.PeerToPeerReview));
        new SearchNavigateItem(adminItems, (WorldSearchItem)new ArtifactTypeWithInheritenceSearchItem("Show all Team Workflows", AtsArtifactTypes.TeamWorkflow));
        new SearchNavigateItem(adminItems, (WorldSearchItem)new ArtifactTypeSearchItem("Show all Tasks", AtsArtifactTypes.Task));
        XNavigateItem healthItems = new XNavigateItem(adminItems, "Health", (KeyedImage)FrameworkImage.LASER);
        new CreateGoalTestDemoArtifacts(healthItems);
        return items;
    }

    private class SimpleTeamDefinitionProvider
    implements ILazyTeamDefinitionProvider {
        private final Collection<IAtsTeamDefinition> teamDefs;

        public SimpleTeamDefinitionProvider(Collection<IAtsTeamDefinition> teamDefs) {
            this.teamDefs = teamDefs;
        }

        public Collection<IAtsTeamDefinition> getTeamDefs() {
            return this.teamDefs;
        }
    }
}

