/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.demo.navigate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.task.JaxAtsTaskFactory;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskDataFactory;
import org.eclipse.osee.ats.api.task.NewTaskDatas;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.AtsImage;
import org.eclipse.osee.ats.ide.demo.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.GoalManager;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.IWorldEditorProvider;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorSimpleProvider;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Shell;

public class CreateGoalTestDemoArtifacts
extends XNavigateItemAction {
    private Date createdDate;
    private AtsUser createdBy;

    public CreateGoalTestDemoArtifacts(XNavigateItem parent) {
        super(parent, "Create Test Goal Artifacts - Demo", (KeyedImage)AtsImage.GOAL);
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        if (AtsApiService.get().getStoreService().isProductionDb()) {
            AWorkbench.popup((String)"Can't be run on production");
            return;
        }
        if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)this.getName(), (String)this.getName())) {
            return;
        }
        this.createdDate = new Date();
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(this.getName());
        this.createdBy = AtsApiService.get().getUserService().getCurrentUser();
        GoalArtifact sawCodeGoal = GoalManager.createGoal((String)"SAW Code", (IAtsChangeSet)changes);
        GoalArtifact sawTestGoal = GoalManager.createGoal((String)"SAW Test", (IAtsChangeSet)changes);
        GoalArtifact toolsTeamGoal = GoalManager.createGoal((String)"Tools Team", (IAtsChangeSet)changes);
        GoalArtifact facilitiesGoal = GoalManager.createGoal((String)"Facilities Team", (IAtsChangeSet)changes);
        GoalArtifact cisReqGoal = GoalManager.createGoal((String)"CIS Requirements", (IAtsChangeSet)changes);
        IAtsTeamWorkflow teamArt = this.createAction1(changes, sawCodeGoal);
        this.createAction2(changes, sawCodeGoal, cisReqGoal);
        this.createAction3(changes, sawTestGoal, cisReqGoal);
        this.createAction7(changes, facilitiesGoal);
        changes.execute();
        teamArt = this.createAction456(sawCodeGoal, facilitiesGoal, teamArt);
        NewTaskData newTaskData = NewTaskDataFactory.get((String)this.getName(), (AtsUser)this.createdBy, (IAtsTeamWorkflow)teamArt);
        for (String name : Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "AA", "BB", "CC", "DD", "EE", "FF", "GG", "HH", "II", "JJ", "KK", "LL", "MM", "NN", "OO", "PP", "QQ", "RR")) {
            JaxAtsTaskFactory.get((NewTaskData)newTaskData, (String)("Task " + name), (AtsUser)this.createdBy, (Date)this.createdDate);
        }
        Collection createTasks = AtsApiService.get().getTaskService().createTasks(new NewTaskDatas(newTaskData));
        changes = AtsApiService.get().createChangeSet(this.getName());
        for (IAtsTask task : createTasks) {
            Artifact taskArt = AtsApiService.get().getQueryServiceIde().getArtifact((Object)task);
            toolsTeamGoal.addMember((ArtifactId)taskArt);
            changes.relate((Object)toolsTeamGoal, AtsRelationTypes.Goal_Member, (Object)taskArt);
        }
        changes.execute();
        WorldEditor.open((IWorldEditorProvider)new WorldEditorSimpleProvider("Goals", Arrays.asList(sawCodeGoal, sawTestGoal, toolsTeamGoal, facilitiesGoal, cisReqGoal)));
    }

    private void createAction7(IAtsChangeSet changes, GoalArtifact facilitiesGoal) {
        ActionResult action = AtsApiService.get().getActionService().createAction(null, "Add the Improvement", "Description", ChangeType.Improvement, "4", false, null, (Collection)AtsApiService.get().getActionableItemService().getActionableItems(Arrays.asList("Network")), this.createdDate, this.createdBy, null, changes);
        facilitiesGoal.addMember(action.getActionArt());
        changes.add((Object)facilitiesGoal);
    }

    private IAtsTeamWorkflow createAction456(GoalArtifact sawCodeGoal, GoalArtifact facilitiesGoal, IAtsTeamWorkflow teamArt) {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(this.getName());
        NewTaskDatas newTaskDatas = new NewTaskDatas();
        for (String msaTool : Arrays.asList("Backups", "Computers", "Network")) {
            ActionResult action = AtsApiService.get().getActionService().createAction(null, "Fix " + msaTool + " button", "Description", ChangeType.Problem, "4", false, null, (Collection)AtsApiService.get().getActionableItemService().getActionableItems(Arrays.asList(msaTool)), this.createdDate, this.createdBy, null, changes);
            facilitiesGoal.addMember((ArtifactId)AtsApiService.get().getWorkItemService().getFirstTeam((Object)action).getStoreObject());
            teamArt = AtsApiService.get().getWorkItemService().getFirstTeam((Object)action);
            NewTaskData newTaskData = NewTaskDataFactory.get((String)"createAction456", (AtsUser)this.createdBy, (IAtsTeamWorkflow)teamArt);
            newTaskDatas.add(newTaskData);
            JaxAtsTaskFactory.get((NewTaskData)newTaskData, (String)"Task 1", (AtsUser)this.createdBy, (Date)this.createdDate);
            JaxAtsTaskFactory.get((NewTaskData)newTaskData, (String)"Task 2", (AtsUser)this.createdBy, (Date)this.createdDate);
        }
        changes.add((Object)facilitiesGoal);
        changes.add((Object)sawCodeGoal);
        changes.execute();
        Collection createTasks = AtsApiService.get().getTaskService().createTasks(newTaskDatas);
        changes = AtsApiService.get().createChangeSet(this.getName());
        for (IAtsTask task : createTasks) {
            facilitiesGoal.addMember((ArtifactId)task.getStoreObject());
            sawCodeGoal.addMember((ArtifactId)task.getStoreObject());
            changes.add((Object)task);
        }
        changes.execute();
        return teamArt;
    }

    private void createAction3(IAtsChangeSet changes, GoalArtifact sawCodeGoal, GoalArtifact cisReqGoal) {
        ActionResult action = AtsApiService.get().getActionService().createAction(null, "Remove Workflow button", "Description", ChangeType.Problem, "4", false, null, (Collection)AtsApiService.get().getActionableItemService().getActionableItems(Arrays.asList("SAW Code", "CIS Requirements")), this.createdDate, this.createdBy, null, changes);
        sawCodeGoal.addMember((ArtifactId)AtsApiService.get().getWorkItemService().getFirstTeam((Object)action).getStoreObject());
        cisReqGoal.addMember((ArtifactId)AtsApiService.get().getWorkItemService().getFirstTeam((Object)action).getStoreObject());
    }

    private void createAction2(IAtsChangeSet changes, GoalArtifact sawCodeGoal, GoalArtifact cisReqGoal) {
        ActionResult action = AtsApiService.get().getActionService().createAction(null, "Add CDB Check Signals", "Description", ChangeType.Problem, "4", false, null, (Collection)AtsApiService.get().getActionableItemService().getActionableItems(Arrays.asList("SAW Code", "CIS Requirements")), this.createdDate, this.createdBy, null, changes);
        sawCodeGoal.addMember((ArtifactId)AtsApiService.get().getWorkItemService().getFirstTeam((Object)action).getStoreObject());
        cisReqGoal.addMember((ArtifactId)AtsApiService.get().getWorkItemService().getFirstTeam((Object)action).getStoreObject());
    }

    private IAtsTeamWorkflow createAction1(IAtsChangeSet changes, GoalArtifact sawCodeGoal) {
        ActionResult action = AtsApiService.get().getActionService().createAction(null, "Fix this model", "Description", ChangeType.Problem, "2", false, null, (Collection)AtsApiService.get().getActionableItemService().getActionableItems(Arrays.asList("SAW Code")), this.createdDate, this.createdBy, null, changes);
        sawCodeGoal.addMember((ArtifactId)AtsApiService.get().getWorkItemService().getFirstTeam((Object)action).getStoreObject());
        IAtsTeamWorkflow teamWf = AtsApiService.get().getWorkItemService().getFirstTeam((Object)action);
        IAtsPeerToPeerReview peerReviewArt = AtsApiService.get().getReviewService().createNewPeerToPeerReview((IAtsTeamWorkflow)((TeamWorkFlowArtifact)teamWf.getStoreObject()), "New Review", "Implement", changes);
        sawCodeGoal.addMember((ArtifactId)peerReviewArt.getStoreObject());
        return teamWf;
    }
}

