/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.demo;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.demo.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.DemoBranches;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.utility.OseeInfo;

public class DemoUtil {
    private static String atsIds;
    public static List<String> Saw_Code_Committed_Task_Titles;
    public static List<String> Saw_Code_UnCommitted_Task_Titles;

    static {
        Saw_Code_Committed_Task_Titles = Arrays.asList("Look into Graph View.", "Redesign how view shows values.", "Discuss new design with Senior Engineer", "Develop prototype", "Show prototype to management", "Create development plan", "Create test plan", "Make changes");
        Saw_Code_UnCommitted_Task_Titles = Arrays.asList("Document how Graph View works", "Update help contents", "Review new documentation", "Publish documentation to website", "Remove old viewer", "Deploy release");
    }

    public static int getNumTasks() {
        return Saw_Code_Committed_Task_Titles.size() + Saw_Code_UnCommitted_Task_Titles.size();
    }

    private DemoUtil() {
    }

    public static Result isDbPopulatedWithDemoData() throws Exception {
        List robotArtifacts = ArtifactQuery.getArtifactListFromTypeAndName((ArtifactTypeId)CoreArtifactTypes.SoftwareRequirementMsWord, (String)"Robot", (BranchId)DemoBranches.SAW_Bld_1, (QueryOption[])QueryOption.CONTAINS_MATCH_OPTIONS);
        if (robotArtifacts.size() < 6) {
            return new Result(String.format("Expected at least 6 Software Requirements with name \"Robot\" but found [%s].  Database is not be populated with demo data.", robotArtifacts.size()));
        }
        return Result.TrueResult;
    }

    public static void checkDbInitSuccess() {
        if (!DemoUtil.isDbInitSuccessful()) {
            throw new OseeStateException("DbInit must be successful to continue", new Object[0]);
        }
    }

    public static void checkDbInitAndPopulateSuccess() {
        if (!DemoUtil.isDbInitSuccessful()) {
            throw new OseeStateException("DbInit must be successful to continue", new Object[0]);
        }
        if (!DemoUtil.isPopulateDbSuccessful()) {
            throw new OseeStateException("PopulateDemoDb must be successful to continue", new Object[0]);
        }
    }

    public static boolean isDbInitSuccessful() {
        return OseeInfo.getValue((String)"DbInitSuccess").equals("true");
    }

    public static void setDbInitSuccessful(boolean success) {
        OseeInfo.setValue((String)"DbInitSuccess", (String)String.valueOf(success));
    }

    public static boolean isPopulateDbSuccessful() {
        return OseeInfo.getValue((String)"PopulateSuccessful").equals("true");
    }

    public static void setPopulateDbSuccessful(boolean success) {
        OseeInfo.setValue((String)"PopulateSuccessful", (String)String.valueOf(success));
    }

    public static TeamWorkFlowArtifact getSawCodeCommittedWf() {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_Commited_Code_TeamWf);
    }

    public static TeamWorkFlowArtifact getSawTestCommittedWf() {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_Commited_Test_TeamWf);
    }

    public static TeamWorkFlowArtifact getSawReqCommittedWf() {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_Commited_Req_TeamWf);
    }

    public static TeamWorkFlowArtifact getSawSWDesignCommittedWf() {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_Commited_SWDesign_TeamWf);
    }

    public static TeamWorkFlowArtifact getSawCodeUnCommittedWf() {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_UnCommited_Code_TeamWf);
    }

    public static TeamWorkFlowArtifact getSawTestUnCommittedWf() {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_UnCommited_Test_TeamWf);
    }

    public static TeamWorkFlowArtifact getSawReqUnCommittedWf() {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_UnCommited_Req_TeamWf);
    }

    public static TeamWorkFlowArtifact getSawSWDesignUnCommittedWf() {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_UnCommited_SWDesign_TeamWf);
    }

    public static TeamWorkFlowArtifact getSwDesignNoBranchWf() {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_NoBranch_SWDesign_TeamWf);
    }

    public static TeamWorkFlowArtifact getSawCodeNoBranchWf() {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_NoBranch_Code_TeamWf);
    }

    public static TeamWorkFlowArtifact getSawTestNoBranchWf() {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_NoBranch_Test_TeamWf);
    }

    public static TeamWorkFlowArtifact getSawReqNoBranchWf() {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_NoBranch_Req_TeamWf);
    }

    public static TeamWorkFlowArtifact getSawSWDesignNoBranchWf() {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.SAW_NoBranch_SWDesign_TeamWf);
    }

    public static TeamWorkFlowArtifact getButtonWDoesntWorkOnSituationPageWf() {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.ButtonWDoesntWorkOnSituationPage_TeamWf);
    }

    public static TeamWorkFlowArtifact getCantLoadDiagramTreeWf() {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.CantLoadDiagramTree_TeamWf);
    }

    public static TeamWorkFlowArtifact getProblemInDiagramTree_TeamWfWf() {
        return (TeamWorkFlowArtifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)DemoArtifactToken.ProblemInDiagramTree_TeamWf);
    }

    public static Collection<TeamWorkFlowArtifact> getSawCommittedTeamWfs() {
        return Arrays.asList(DemoUtil.getSawTestCommittedWf(), DemoUtil.getSawReqCommittedWf(), DemoUtil.getSawCodeCommittedWf());
    }

    public static Collection<TeamWorkFlowArtifact> getSawUnCommittedTeamWfs() {
        return Arrays.asList(DemoUtil.getSawTestUnCommittedWf(), DemoUtil.getSawReqUnCommittedWf(), DemoUtil.getSawCodeUnCommittedWf(), DemoUtil.getSawSWDesignUnCommittedWf());
    }

    public static String getSawAtsIdsStr() {
        if (atsIds == null) {
            atsIds = Collections.toString((String)",", (Iterable)AtsObjects.toAtsIds(DemoUtil.getSawCommittedTeamWfs()));
        }
        return atsIds;
    }
}

