/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.client.demo.internal;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.client.demo.internal.OseeApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DemoBranches;
import org.eclipse.osee.framework.core.enums.DemoUsers;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.database.init.IDbInitializationTask;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.importing.parsers.IArtifactExtractor;
import org.eclipse.osee.framework.skynet.core.importing.parsers.IArtifactExtractorDelegate;
import org.eclipse.osee.framework.skynet.core.importing.parsers.WordOutlineExtractor;
import org.eclipse.osee.framework.skynet.core.importing.parsers.WordOutlineExtractorDelegate;
import org.eclipse.osee.framework.skynet.core.importing.resolvers.IArtifactImportResolver;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.framework.ui.skynet.Import.ArtifactImportOperationFactory;
import org.eclipse.osee.framework.ui.skynet.Import.ArtifactImportOperationParameter;
import org.eclipse.osee.framework.ui.skynet.Import.ArtifactResolverFactory;

public class AddRequirementData
implements IDbInitializationTask {
    private static boolean DEBUG = false;
    private static final String UPDATE_BRANCH_TYPE = "update osee_branch set branch_type = ? where branch_id = ?";

    public void run() {
        try {
            BranchToken branch = DemoBranches.SAW_Bld_1;
            this.importRequirements((BranchId)branch, CoreArtifactTypes.SoftwareRequirementMsWord, CoreArtifactTokens.SoftwareRequirementsFolder, OseeInf.getResourceAsFile((String)"requirements/SAW-SoftwareRequirements.xml", this.getClass()));
            this.importRequirements((BranchId)branch, CoreArtifactTypes.SystemRequirementMsWord, CoreArtifactTokens.SystemRequirementsFolder, OseeInf.getResourceAsFile((String)"requirements/SAW-SystemRequirements.xml", this.getClass()));
            this.importRequirements((BranchId)branch, CoreArtifactTypes.SubsystemRequirementMsWord, CoreArtifactTokens.SubSystemRequirementsFolder, OseeInf.getResourceAsFile((String)"requirements/SAW-SubsystemRequirements.xml", this.getClass()));
            SkynetTransaction demoDbTraceability = TransactionManager.createTransaction((BranchId)branch, (String)"Populate Demo DB - Create Traceability");
            this.demoDbTraceabilityTx(demoDbTraceability, (BranchId)branch);
            demoDbTraceability.execute();
            BranchToken childBranch = BranchManager.createBaselineBranch((BranchToken)DemoBranches.SAW_Bld_1, (BranchToken)DemoBranches.SAW_Bld_2);
            OseeApiService.get().getAccessControlService().setPermission((ArtifactToken)UserManager.getUser((UserToken)DemoUsers.Joe_Smith), (BranchId)DemoBranches.SAW_Bld_2, PermissionEnum.FULLACCESS);
            ConnectionHandler.runPreparedUpdate((String)UPDATE_BRANCH_TYPE, (Object[])new Object[]{BranchType.BASELINE, childBranch});
            BranchManager.refreshBranches();
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    private void importRequirements(BranchId branch, ArtifactTypeToken requirementType, ArtifactToken folderArt, File file) throws Exception {
        if (DEBUG) {
            OseeLog.logf(AddRequirementData.class, (Level)Level.INFO, (String)"Importing \"%s\" requirements on branch \"%s\"", (Object[])new Object[]{folderArt.toStringWithId(), branch});
        }
        Artifact systemReq = ArtifactQuery.getArtifactFromId((ArtifactId)folderArt, (BranchId)branch);
        IArtifactImportResolver artifactResolver = ArtifactResolverFactory.createAlwaysNewArtifacts((ArtifactTypeToken)requirementType);
        WordOutlineExtractor extractor = new WordOutlineExtractor();
        extractor.setDelegate((IArtifactExtractorDelegate)new WordOutlineExtractorDelegate());
        ArtifactImportOperationParameter importOptions = new ArtifactImportOperationParameter();
        importOptions.setSourceFile(file);
        importOptions.setDestinationArtifact(systemReq);
        importOptions.setExtractor((IArtifactExtractor)extractor);
        importOptions.setResolver(artifactResolver);
        IOperation operation = ArtifactImportOperationFactory.completeOperation((ArtifactImportOperationParameter)importOptions);
        Operations.executeWorkAndCheckStatus((IOperation)operation);
        if (systemReq.getChildren().isEmpty()) {
            throw new IllegalStateException("Artifacts were not imported");
        }
    }

    private void relate(RelationTypeSide relationSide, Artifact artifact, Collection<Artifact> artifacts) {
        for (Artifact otherArtifact : artifacts) {
            artifact.addRelation(relationSide, otherArtifact);
        }
    }

    private void demoDbTraceabilityTx(SkynetTransaction transaction, BranchId branch) throws Exception {
        Collection<Artifact> systemArts = this.getArtTypeRequirements(DEBUG, CoreArtifactTypes.SystemRequirementMsWord, "Robot", branch);
        Collection<Artifact> component = this.getArtTypeRequirements(DEBUG, CoreArtifactTypes.Component, "API", branch);
        component.addAll(this.getArtTypeRequirements(DEBUG, CoreArtifactTypes.Component, "Hardware", branch));
        component.addAll(this.getArtTypeRequirements(DEBUG, CoreArtifactTypes.Component, "Sensor", branch));
        Collection<Artifact> subSystemArts = this.getArtTypeRequirements(DEBUG, CoreArtifactTypes.SubsystemRequirementMsWord, "Robot", branch);
        subSystemArts.addAll(this.getArtTypeRequirements(DEBUG, CoreArtifactTypes.SubsystemRequirementMsWord, "Video", branch));
        subSystemArts.addAll(this.getArtTypeRequirements(DEBUG, CoreArtifactTypes.SubsystemRequirementMsWord, "Interface", branch));
        Collection<Artifact> softArts = this.getArtTypeRequirements(DEBUG, CoreArtifactTypes.SoftwareRequirementMsWord, "Robot", branch);
        softArts.addAll(this.getArtTypeRequirements(DEBUG, CoreArtifactTypes.SoftwareRequirementMsWord, "Interface", branch));
        for (Artifact systemArt : systemArts) {
            this.relate(CoreRelationTypes.RequirementTrace_LowerLevelRequirement, systemArt, subSystemArts);
            systemArt.persist(transaction);
            for (Artifact subSystemArt : subSystemArts) {
                this.relate(CoreRelationTypes.RequirementTrace_LowerLevelRequirement, subSystemArt, softArts);
                subSystemArt.persist(transaction);
            }
        }
        for (Artifact art : systemArts) {
            this.relate(CoreRelationTypes.Allocation_Component, art, component);
            art.persist(transaction);
        }
        for (Artifact art : subSystemArts) {
            this.relate(CoreRelationTypes.Allocation_Component, art, component);
            art.persist(transaction);
        }
        for (Artifact art : softArts) {
            this.relate(CoreRelationTypes.Allocation_Component, art, component);
        }
        HashSet<Artifact> verificationTests = new HashSet<Artifact>();
        Artifact verificationHeader = ArtifactQuery.getArtifactFromTypeAndName((ArtifactTypeId)CoreArtifactTypes.Folder, (String)"Verification Tests", (BranchId)branch);
        if (verificationHeader == null) {
            throw new IllegalStateException("Could not find Verification Tests header");
        }
        String[] stringArray = new String[]{"A", "B", "C"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            Artifact newArt = ArtifactTypeManager.addArtifact((ArtifactTypeToken)CoreArtifactTypes.TestCase, (BranchToken)verificationHeader.getBranch(), (String)("Verification Test " + str));
            verificationTests.add(newArt);
            verificationHeader.addRelation(CoreRelationTypes.DefaultHierarchical_Child, newArt);
            newArt.persist(transaction);
            ++n2;
        }
        Artifact[] verificationTestsArray = verificationTests.toArray(new Artifact[verificationTests.size()]);
        HashSet<Artifact> validationTests = new HashSet<Artifact>();
        Artifact validationHeader = ArtifactQuery.getArtifactFromTypeAndName((ArtifactTypeId)CoreArtifactTypes.Folder, (String)"Validation Tests", (BranchId)branch);
        if (validationHeader == null) {
            throw new IllegalStateException("Could not find Validation Tests header");
        }
        String[] stringArray2 = new String[]{"1", "2", "3"};
        int n3 = stringArray2.length;
        int newArt = 0;
        while (newArt < n3) {
            String str = stringArray2[newArt];
            Artifact newArt2 = ArtifactTypeManager.addArtifact((ArtifactTypeToken)CoreArtifactTypes.TestProcedure, (BranchToken)validationHeader.getBranch(), (String)("Validation Test " + str));
            validationTests.add(newArt2);
            validationHeader.addRelation(CoreRelationTypes.DefaultHierarchical_Child, newArt2);
            newArt2.persist(transaction);
            ++newArt;
        }
        Artifact[] validationTestsArray = validationTests.toArray(new Artifact[validationTests.size()]);
        HashSet<Artifact> integrationTests = new HashSet<Artifact>();
        Artifact integrationHeader = ArtifactQuery.getArtifactFromTypeAndName((ArtifactTypeId)CoreArtifactTypes.Folder, (String)"Integration Tests", (BranchId)branch);
        if (integrationHeader == null) {
            throw new IllegalStateException("Could not find integration Tests header");
        }
        String[] stringArray3 = new String[]{"X", "Y", "Z"};
        int n4 = stringArray3.length;
        int newArt2 = 0;
        while (newArt2 < n4) {
            String str = stringArray3[newArt2];
            Artifact newArt3 = ArtifactTypeManager.addArtifact((ArtifactTypeToken)CoreArtifactTypes.TestProcedure, (BranchToken)integrationHeader.getBranch(), (String)("integration Test " + str));
            integrationTests.add(newArt3);
            integrationHeader.addRelation(CoreRelationTypes.DefaultHierarchical_Child, newArt3);
            newArt3.persist(transaction);
            ++newArt2;
        }
        Artifact[] integrationTestsArray = integrationTests.toArray(new Artifact[integrationTests.size()]);
        Artifact[] softReqsArray = softArts.toArray(new Artifact[softArts.size()]);
        softReqsArray[0].addRelation(CoreRelationTypes.Validation_Validator, verificationTestsArray[0]);
        softReqsArray[0].addRelation(CoreRelationTypes.Validation_Validator, verificationTestsArray[1]);
        softReqsArray[1].addRelation(CoreRelationTypes.Validation_Validator, verificationTestsArray[0]);
        softReqsArray[1].addRelation(CoreRelationTypes.Validation_Validator, validationTestsArray[1]);
        softReqsArray[2].addRelation(CoreRelationTypes.Validation_Validator, validationTestsArray[0]);
        softReqsArray[2].addRelation(CoreRelationTypes.Validation_Validator, integrationTestsArray[1]);
        softReqsArray[3].addRelation(CoreRelationTypes.Validation_Validator, integrationTestsArray[0]);
        softReqsArray[4].addRelation(CoreRelationTypes.Validation_Validator, integrationTestsArray[2]);
        softReqsArray[5].addRelation(CoreRelationTypes.Validation_Validator, validationTestsArray[2]);
        for (Artifact artifact : softArts) {
            artifact.persist(transaction);
        }
    }

    private Collection<Artifact> getArtTypeRequirements(boolean DEBUG, ArtifactTypeToken artifactType, String artifactNameStr, BranchId branch) {
        if (DEBUG) {
            OseeLog.logf(AddRequirementData.class, (Level)Level.INFO, (String)"Getting [%s] requirement(s) from Branch [%s]", (Object[])new Object[]{artifactNameStr, branch.getIdString()});
        }
        List arts = ArtifactQuery.getArtifactListFromTypeAndName((ArtifactTypeId)artifactType, (String)artifactNameStr, (BranchId)branch, (QueryOption[])QueryOption.CONTAINS_MATCH_OPTIONS);
        if (DEBUG) {
            OseeLog.logf(AddRequirementData.class, (Level)Level.INFO, (String)"Found [%s] Artifacts", (Object[])new Object[]{arts.size()});
        }
        return arts;
    }
}

