/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClientConfig;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcDbType;
import org.eclipse.osee.jdbc.JdbcException;
import org.eclipse.osee.jdbc.JdbcMigrationOptions;
import org.eclipse.osee.jdbc.JdbcMigrationResource;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.jdbc.JdbcTransaction;
import org.eclipse.osee.jdbc.OseePreparedStatement;

public interface JdbcClient {
    public JdbcDbType getDbType();

    public JdbcClientConfig getConfig();

    public JdbcStatement getStatement();

    public JdbcStatement getStatement(int var1, int var2);

    public int runQuery(Consumer<JdbcStatement> var1, String var2, Object ... var3);

    public int runQuery(JdbcConnection var1, Consumer<JdbcStatement> var2, String var3, Object ... var4);

    public int runQuery(Consumer<JdbcStatement> var1, int var2, String var3, Object ... var4);

    public int runQuery(JdbcConnection var1, Consumer<JdbcStatement> var2, int var3, String var4, Object ... var5);

    public int runQueryWithLimit(Consumer<JdbcStatement> var1, int var2, String var3, Object ... var4);

    public <R> R fetch(R var1, String var2, Object ... var3);

    public <R> R fetch(JdbcConnection var1, R var2, String var3, Object ... var4);

    public <R> R fetch(R var1, Function<JdbcStatement, R> var2, String var3, Object ... var4);

    public <R> R fetch(JdbcConnection var1, R var2, Function<JdbcStatement, R> var3, String var4, Object ... var5);

    public <R> R fetchOrException(Supplier<OseeCoreException> var1, Function<JdbcStatement, R> var2, String var3, Object ... var4);

    public <R> R fetchOrException(JdbcConnection var1, Supplier<OseeCoreException> var2, Function<JdbcStatement, R> var3, String var4, Object ... var5);

    public <R> R fetchOrException(Class<R> var1, Supplier<OseeCoreException> var2, String var3, Object ... var4);

    public int runBatchUpdate(String var1, Iterable<Object[]> var2);

    public OseePreparedStatement getBatchStatement(String var1);

    public OseePreparedStatement getBatchStatement(String var1, int var2);

    public int runPreparedUpdate(String var1, Object ... var2);

    public <T> T runFunction(T var1, String var2, Object ... var3);

    public void runCall(String var1, Object ... var2);

    public Map<String, String> getStatistics();

    public JdbcConnection getConnection();

    public JdbcStatement getStatement(JdbcConnection var1, boolean var2);

    public JdbcStatement getStatement(JdbcConnection var1);

    public int runPreparedUpdate(JdbcConnection var1, String var2, Object ... var3);

    public int runBatchUpdate(JdbcConnection var1, String var2, Iterable<Object[]> var3);

    public OseePreparedStatement getBatchStatement(JdbcConnection var1, String var2);

    public OseePreparedStatement getBatchStatement(JdbcConnection var1, String var2, int var3);

    public void runTransaction(JdbcTransaction var1);

    public void runTransaction(JdbcConnection var1, JdbcTransaction var2) throws JdbcException;

    public void createDataStore(JdbcMigrationOptions var1, Iterable<JdbcMigrationResource> var2);

    public long getNextSequence(String var1, boolean var2);

    public void invalidateSequences();

    public int clearTable(String var1);

    default public String injectOrderedHint(String sql) {
        return String.format(sql, this.getOrderedHint());
    }

    default public String getOrderedHint() {
        return this.getDbType().areHintsSupported() ? "/*+ ordered */" : "";
    }

    public void vacuum();
}

