/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.util.io.Field;
import org.eclipse.osee.framework.jdk.core.util.io.IEnumValueBuilder;

public class JavaFileBuilder {
    protected String packageName;
    protected String className;
    protected String classJavaDoc;
    protected String extendsClass;
    private final ArrayList<String> interfaces;
    private final List<Field> fields;
    private final List<String> imports;
    private final List<String> methods;
    private final List<IEnumValueBuilder.EnumRecord> enumFields;

    public JavaFileBuilder(String className) {
        this(null, className, null, null);
    }

    public JavaFileBuilder(String packageName, String className, String classJavaDoc, String extendsClass) {
        this.packageName = packageName;
        this.className = className;
        this.classJavaDoc = classJavaDoc;
        this.extendsClass = extendsClass;
        this.interfaces = new ArrayList();
        this.fields = new LinkedList<Field>();
        this.imports = new LinkedList<String>();
        this.methods = new LinkedList<String>();
        this.enumFields = new LinkedList<IEnumValueBuilder.EnumRecord>();
    }

    public void addInterface(String interfaceName) {
        this.interfaces.add(interfaceName);
    }

    public void addField(Field field) {
        this.fields.add(field);
    }

    public void addEnumField(IEnumValueBuilder.EnumRecord enumField) {
        this.enumFields.add(enumField);
    }

    public void addImport(String importName) {
        this.imports.add(importName);
    }

    public void addMethod(String method) {
        this.methods.add(method);
    }

    public void setClassJavaDoc(String classJavaDoc) {
        this.classJavaDoc = classJavaDoc;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setExtendsClass(String extendsClass) {
        this.extendsClass = extendsClass;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void write(File directory) throws FileNotFoundException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Supplied file is not a directory");
        }
        PrintWriter out = new PrintWriter(new File(directory, String.valueOf(this.className) + ".java"));
        out.write(this.toString());
        out.close();
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM d, yyyy");
        string.append("/*\n * Created on " + dateFormat.format(new Date()) + "\n *\n * PLACE_YOUR_DISTRIBUTION_STATEMENT_RIGHT_HERE\n */\n\n");
        string.append("package " + this.packageName + ";");
        string.append("\n\n");
        for (String importName : this.imports) {
            string.append("import " + importName + ";\n");
        }
        string.append("\n");
        if (this.classJavaDoc != null) {
            string.append(this.stringToJavadoc(this.classJavaDoc));
        }
        if (this.interfaces.size() != 0 && this.interfaces.get(0).equals("IEnumValue") && this.extendsClass == null) {
            string.append("public enum " + this.className + " implements IEnumValue");
            string.append(" {\n");
            this.getEnumFields(string);
        } else {
            string.append("public class " + this.className + (this.extendsClass == null ? "" : " extends " + this.extendsClass.trim()));
            int i = 0;
            while (i < this.interfaces.size()) {
                if (i == 0) {
                    string.append(" implements " + this.interfaces.get(i));
                } else {
                    string.append(", " + this.interfaces.get(i));
                }
                ++i;
            }
            string.append(" {\n");
            this.getFields(string);
        }
        this.getMethods(string);
        string.append("}");
        return string.toString();
    }

    protected void getFields(StringBuilder string) {
        for (Field field : this.fields) {
            string.append(String.valueOf(field.toString()) + "\n");
        }
    }

    protected void getEnumFields(StringBuilder string) {
        Iterator<IEnumValueBuilder.EnumRecord> enumFieldsIter = this.enumFields.iterator();
        while (enumFieldsIter.hasNext()) {
            IEnumValueBuilder.EnumRecord eField = enumFieldsIter.next();
            string.append("\t" + eField);
            if (!enumFieldsIter.hasNext()) {
                string.append(";\n\n");
                continue;
            }
            string.append(",\n");
        }
    }

    protected void getMethods(StringBuilder string) {
        for (String method : this.methods) {
            string.append(String.valueOf(method) + "\n");
        }
    }

    private String stringToJavadoc(String string) {
        return "/**\n" + string.replaceAll("^", " * ").replaceAll("\n", "\n * ") + "\n */\n";
    }
}

