/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.internal.launching.ILaunchingPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.EmptyOutlinePage;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.ToggleLinkWithEditorAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class PDEMultiPageContentOutline
extends Page
implements IContentOutlinePage,
ISelectionChangedListener,
ILaunchingPreferenceConstants {
    private PageBook pagebook;
    private ISelection selection;
    private ArrayList<ISelectionChangedListener> listeners;
    private ISortableContentOutlinePage currentPage;
    private ISortableContentOutlinePage emptyPage;
    private boolean sortingOn;
    private PDEFormEditor editor;
    private ToggleLinkWithEditorAction fToggleLinkWithEditorAction;

    public PDEMultiPageContentOutline(PDEFormEditor editor) {
        this.editor = editor;
        this.listeners = new ArrayList();
        this.selection = StructuredSelection.EMPTY;
        this.sortingOn = PDEPlugin.getDefault().getPreferenceStore().getBoolean("PDEMultiPageContentOutline.SortingAction.isChecked");
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void createControl(Composite parent) {
        this.pagebook = new PageBook(parent, 0);
        if (this.currentPage != null) {
            this.setPageActive(this.currentPage);
        }
    }

    public void dispose() {
        if (this.pagebook != null && !this.pagebook.isDisposed()) {
            this.pagebook.dispose();
        }
        if (this.emptyPage != null) {
            this.emptyPage.dispose();
            this.emptyPage = null;
        }
        if (this.currentPage != null) {
            this.currentPage.removeSelectionChangedListener(this);
            this.currentPage = null;
        }
        this.pagebook = null;
        this.listeners = null;
        this.editor = null;
        if (this.fToggleLinkWithEditorAction != null) {
            this.fToggleLinkWithEditorAction.fEditor = null;
            this.fToggleLinkWithEditorAction = null;
        }
    }

    public boolean isDisposed() {
        return this.listeners == null;
    }

    public Control getControl() {
        return this.pagebook;
    }

    public PageBook getPagebook() {
        return this.pagebook;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.registerToolbarActions(pageSite.getActionBars());
    }

    public void setFocus() {
        if (this.currentPage != null) {
            this.currentPage.setFocus();
        }
    }

    private ISortableContentOutlinePage getEmptyPage() {
        if (this.emptyPage == null) {
            this.emptyPage = new EmptyOutlinePage();
        }
        return this.emptyPage;
    }

    public void setPageActive(ISortableContentOutlinePage page) {
        if (page == null) {
            page = this.getEmptyPage();
        }
        if (this.currentPage != null) {
            this.currentPage.removeSelectionChangedListener(this);
        }
        page.sort(this.sortingOn);
        page.addSelectionChangedListener(this);
        this.currentPage = page;
        if (this.pagebook == null) {
            return;
        }
        Control control = page.getControl();
        if (control == null || control.isDisposed()) {
            page.createControl((Composite)this.pagebook);
            control = page.getControl();
        }
        this.pagebook.showPage(control);
        this.currentPage = page;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        if (this.listeners == null) {
            return;
        }
        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).selectionChanged(e);
            ++i;
        }
    }

    private void registerToolbarActions(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        if (toolBarManager != null) {
            this.fToggleLinkWithEditorAction = new ToggleLinkWithEditorAction(this.editor);
            toolBarManager.add((IAction)this.fToggleLinkWithEditorAction);
            toolBarManager.add((IAction)new SortingAction());
        }
    }

    class SortingAction
    extends Action {
        public SortingAction() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.pde.doc.user.outline_sort_action");
            this.setText(PDEUIMessages.PDEMultiPageContentOutline_SortingAction_label);
            this.setImageDescriptor(PDEPluginImages.DESC_ALPHAB_SORT_CO);
            this.setDisabledImageDescriptor(PDEPluginImages.DESC_ALPHAB_SORT_CO_DISABLED);
            this.setToolTipText(PDEUIMessages.PDEMultiPageContentOutline_SortingAction_tooltip);
            this.setDescription(PDEUIMessages.PDEMultiPageContentOutline_SortingAction_description);
            this.setChecked(PDEMultiPageContentOutline.this.sortingOn);
        }

        public void run() {
            this.setChecked(this.isChecked());
            this.valueChanged(this.isChecked());
        }

        private void valueChanged(boolean on) {
            PDEMultiPageContentOutline.this.sortingOn = on;
            if (PDEMultiPageContentOutline.this.currentPage != null) {
                PDEMultiPageContentOutline.this.currentPage.sort(on);
            }
            PDEPlugin.getDefault().getPreferenceStore().setValue("PDEMultiPageContentOutline.SortingAction.isChecked", on);
        }
    }
}

