/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.ws.rs.core.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.NullOperationLogger;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.event.model.TransactionEvent;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.orcs.rest.client.OseeClient;
import org.eclipse.osee.orcs.rest.model.TransactionEndpoint;

public class PurgeTransactionOperation
extends AbstractOperation {
    private final List<Long> txIdsToDelete;
    private final Set<PurgeTransactionListener> listeners = new CopyOnWriteArraySet<PurgeTransactionListener>();
    private final Pair<TransactionEvent, Map<String, Long>> transEventAndIds;

    public PurgeTransactionOperation(List<Long> txIdsToDelete, Pair<TransactionEvent, Map<String, Long>> transEventAndIds) {
        super("Purge transactions " + txIdsToDelete, "org.eclipse.osee.framework.skynet.core", NullOperationLogger.getSingleton());
        this.txIdsToDelete = txIdsToDelete;
        this.transEventAndIds = transEventAndIds;
    }

    public void addListener(PurgeTransactionListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(PurgeTransactionListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        OseeClient client = ServiceUtil.getOseeClient();
        TransactionEndpoint txEndpoint = client.getTransactionEndpoint();
        String deleteTxs = Collections.toString((String)",", this.txIdsToDelete);
        Response result = txEndpoint.purgeTxs(deleteTxs);
        if (Response.Status.OK.getStatusCode() == result.getStatus()) {
            for (PurgeTransactionListener listener : this.listeners) {
                listener.onPurgeTransactionSuccess(this.txIdsToDelete, this.transEventAndIds);
            }
        }
    }

    public static interface PurgeTransactionListener {
        public void onPurgeTransactionSuccess(List<Long> var1, Pair<TransactionEvent, Map<String, Long>> var2);
    }
}

