/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.users;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.eclipse.osee.cache.admin.Cache;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.LazyObject;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.skynet.core.utility.DbUtil;

public class UserDataWriter {
    private final LazyObject<Cache<String, User>> cacheProvider;

    public UserDataWriter(LazyObject<Cache<String, User>> cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public User createUser(UserToken userToken, String comment) {
        SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)CoreBranches.COMMON, comment);
        User user = this.createUser(userToken, transaction);
        Operations.executeWorkAndCheckStatus((IOperation)transaction);
        return user;
    }

    public User createUser(UserToken userToken, SkynetTransaction transaction) {
        User user = (User)((Object)((Cache)this.cacheProvider.get()).getIfPresent((Object)userToken.getUserId()));
        if (user != null) {
            user.setName(userToken.getName());
            user.setEmail(userToken.getEmail());
            user.setActive(userToken.isActive());
        } else {
            long uuid = userToken.getId() > 0L ? userToken.getId() : Lib.generateArtifactIdAsInt();
            user = (User)ArtifactTypeManager.addArtifact(CoreArtifactTypes.User, CoreBranches.COMMON, userToken.getName(), GUID.create(), uuid);
            user.setActive(userToken.isActive());
            user.setUserID(userToken.getUserId());
            user.setEmail(userToken.getEmail());
            this.addUserToUserGroups(user);
            this.cacheUser(user);
            if (!DbUtil.isDbInit() && !"false".equals(System.getProperty("displayCreateUserError"))) {
                Exception ex = new Exception("just wanted the stack trace");
                OseeLog.logf(Activator.class, (Level)Level.INFO, (Throwable)ex, (String)"Created user [%s]", (Object[])new Object[]{user});
            }
        }
        if (transaction != null) {
            user.persist(transaction);
        }
        return user;
    }

    private void cacheUser(final User newUser) {
        Cache cache = (Cache)this.cacheProvider.get();
        try {
            cache.get((Object)newUser.getUserId(), (Callable)new Callable<User>(){

                @Override
                public User call() {
                    return newUser;
                }
            });
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    private void addUserToUserGroups(Artifact user) {
        List<Artifact> defaultGroups = ArtifactQuery.getArtifactListFromAttribute((AttributeTypeId)CoreAttributeTypes.DefaultGroup, "true", (BranchId)CoreBranches.COMMON);
        for (Artifact userGroup : defaultGroups) {
            userGroup.addRelation(CoreRelationTypes.Users_User, user);
        }
    }
}

