/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal;

import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.rest.model.TypesEndpoint;

public class OseeTypesExportOperation
extends AbstractOperation {
    private final TypesEndpoint typesEndpoint;
    private final OutputStream outputStream;

    public OseeTypesExportOperation(TypesEndpoint typesEndpoint, OutputStream outputStream) {
        super("Export Osee Types Model", "org.eclipse.osee.framework.skynet.core");
        this.typesEndpoint = typesEndpoint;
        this.outputStream = outputStream;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        block5: {
            Conditions.checkNotNull((Object)this.outputStream, (String)"outputStream");
            try {
                Response response = this.typesEndpoint.getTypes();
                if (Response.Status.OK.getStatusCode() != response.getStatus()) break block5;
                InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
                try {
                    Lib.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)this.outputStream);
                }
                finally {
                    Lib.close((AutoCloseable)inputStream);
                }
            }
            catch (Exception ex) {
                throw OseeCoreException.wrap((Throwable)ex);
            }
        }
    }
}

