/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.resolvers;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.importing.RoughArtifact;
import org.eclipse.osee.framework.skynet.core.importing.resolvers.AttributeBasedArtifactResolver;
import org.eclipse.osee.framework.skynet.core.importing.resolvers.IRoughArtifactTranslator;

public class DropTargetAttributeBasedResolver
extends AttributeBasedArtifactResolver {
    private final Artifact dropTarget;
    public static final Pattern oseeFilePattern = Pattern.compile("([^_]+)_[^\\d]+[^_]+_[^-]+.*");
    public static final Matcher oseeFileMatcher = oseeFilePattern.matcher("");

    public DropTargetAttributeBasedResolver(IRoughArtifactTranslator translator, ArtifactTypeToken primaryArtifactType, ArtifactTypeToken secondaryArtifactType, Collection<AttributeTypeToken> nonChangingAttributes, boolean createNewIfNotExist, boolean deleteUnmatchedArtifacts, Artifact dropTarget) {
        super(translator, primaryArtifactType, secondaryArtifactType, nonChangingAttributes, createNewIfNotExist, deleteUnmatchedArtifacts);
        this.dropTarget = dropTarget;
    }

    @Override
    public Artifact resolve(RoughArtifact roughArtifact, BranchToken branch, Artifact realParent, Artifact root) {
        oseeFileMatcher.reset(roughArtifact.getName());
        if (oseeFileMatcher.find()) {
            roughArtifact.setName(oseeFileMatcher.group(1));
        }
        if (this.dropTarget != null && this.attributeValuesMatch(roughArtifact, this.dropTarget)) {
            this.getTranslator().translate(roughArtifact, this.dropTarget);
        }
        return this.dropTarget;
    }
}

