/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact.search;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactSearchCriteria;
import org.eclipse.osee.orcs.rest.client.QueryBuilder;

public class AttributeCriteria
implements ArtifactSearchCriteria {
    private final AttributeTypeId attributeType;
    private String value;
    private Collection<String> values;
    private final QueryOption[] options;
    private final boolean existsSearch;

    public AttributeTypeId getAttributeType() {
        return this.attributeType;
    }

    public String getValue() {
        return this.value;
    }

    public Collection<String> getValues() {
        return this.values;
    }

    public QueryOption[] getOptions() {
        return this.options;
    }

    public AttributeCriteria(AttributeTypeId attributeType, String value, QueryOption ... options) {
        this(attributeType, value, null, false, options);
    }

    public AttributeCriteria(AttributeTypeId attributeType, QueryOption ... options) {
        this(attributeType, null, null, true, options);
    }

    public AttributeCriteria(AttributeTypeId attributeType, Collection<String> values) {
        this(attributeType, null, AttributeCriteria.validate(values), false, new QueryOption[0]);
    }

    private static Collection<String> validate(Collection<String> values) {
        if (values == null || values.isEmpty()) {
            throw new OseeArgumentException("values provided to AttributeCriteria must not be null or empty", new Object[0]);
        }
        return values;
    }

    private AttributeCriteria(AttributeTypeId attributeType, String value, Collection<String> values, boolean existsSearch, QueryOption ... options) {
        this.attributeType = attributeType;
        this.existsSearch = existsSearch;
        if (!Conditions.hasValues(values)) {
            this.value = value;
        } else if (values.size() == 1) {
            this.value = values.iterator().next();
        } else {
            this.values = values;
        }
        this.options = options;
    }

    public String toString() {
        StringBuilder strB = new StringBuilder();
        if (this.attributeType != null) {
            strB.append(this.attributeType);
        } else {
            strB.append("*");
        }
        strB.append(" ");
        if (this.value != null) {
            strB.append(this.value);
        }
        return strB.toString();
    }

    @Override
    public void addToQueryBuilder(QueryBuilder builder) {
        if (this.existsSearch) {
            builder.andExists(new AttributeTypeId[]{this.getAttributeType()});
        } else if (this.getValues() != null) {
            builder.and(this.getAttributeType(), this.getValues(), this.getOptions());
        } else {
            builder.and(this.getAttributeType(), this.getValue(), this.getOptions());
        }
    }
}

