/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact.cache;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.factory.ArtifactFactoryManager;

public class ArtifactIdCache {
    private final ConcurrentHashMap<ArtifactToken, Object> idCache;
    private final CompositeKeyHashMap<String, BranchId, Object> guidCache;

    public ArtifactIdCache(int initialCapacity) {
        this.idCache = new ConcurrentHashMap(initialCapacity);
        this.guidCache = new CompositeKeyHashMap(initialCapacity, true);
    }

    public Artifact getById(ArtifactToken artifact) {
        return this.asArtifact(this.idCache.get(artifact));
    }

    public Artifact getByGuid(String artGuid, BranchId branch) {
        return this.asArtifact(this.guidCache.get((Object)artGuid, (Object)branch));
    }

    public Object cache(Artifact artifact) {
        Object object = this.asCacheObject(artifact);
        this.idCache.put(artifact, object);
        this.guidCache.put((Object)artifact.getGuid(), (Object)artifact.getBranch(), object);
        return object;
    }

    public void deCache(Artifact artifact) {
        this.idCache.remove((Object)artifact);
        this.guidCache.removeAndGet((Object)artifact.getGuid(), (Object)artifact.getBranch());
    }

    public Collection<Artifact> getAll() {
        return this.getItems(FilterType.NONE);
    }

    public Collection<Artifact> getAllDirties() {
        return this.getItems(FilterType.ONLY_DIRTIES);
    }

    private boolean isFiltered(Artifact artifact, FilterType filter) {
        boolean isFiltered = true;
        if (artifact != null) {
            isFiltered = false;
            if (FilterType.ONLY_DIRTIES == filter) {
                isFiltered = !artifact.isDirty();
            }
        }
        return isFiltered;
    }

    private Collection<Artifact> getItems(FilterType filterType) {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        for (Map.Entry entry : this.guidCache.entrySet()) {
            Artifact art = this.asArtifact(entry.getValue());
            if (this.isFiltered(art, filterType)) continue;
            artifacts.add(art);
        }
        return artifacts;
    }

    private Object asCacheObject(Artifact artifact) {
        if (ArtifactFactoryManager.getEternalArtifactTypes().contains(artifact.getArtifactType())) {
            return artifact;
        }
        if (artifact.isDirty()) {
            return artifact;
        }
        return new WeakReference<Artifact>(artifact);
    }

    protected Artifact asArtifact(Object obj) {
        if (obj != null) {
            if (obj instanceof Artifact) {
                return (Artifact)((Object)obj);
            }
            if (obj instanceof WeakReference) {
                WeakReference art = (WeakReference)obj;
                return (Artifact)((Object)art.get());
            }
        }
        return null;
    }

    public void updateReferenceType(ArtifactToken token) {
        Object obj = this.idCache.get(token);
        if (obj != null) {
            WeakReference art;
            Artifact artifact;
            if (obj instanceof Artifact) {
                Artifact artifact2 = (Artifact)((Object)obj);
                if (!artifact2.isDirty()) {
                    this.cache(artifact2);
                }
            } else if (obj instanceof WeakReference && (artifact = (Artifact)((Object)(art = (WeakReference)obj).get())) != null && artifact.isDirty()) {
                this.cache(artifact);
            }
        }
    }

    public int size() {
        return this.getAll().size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Items:   [%s]\n", this.size()));
        builder.append(String.format("Dirtied: [%s]\n", this.getAllDirties()));
        return builder.toString();
    }

    private static enum FilterType {
        ONLY_DIRTIES,
        NONE;

    }
}

