/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.utility.AbstractDbTxOperation;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.framework.skynet.core.utility.IdJoinQuery;
import org.eclipse.osee.framework.skynet.core.utility.JoinUtility;
import org.eclipse.osee.jdbc.JdbcConnection;

public class PurgeAttributes
extends AbstractDbTxOperation {
    private static final String DELETE_TXS = "DELETE FROM osee_txs WHERE EXISTS (select 1 from osee_join_id WHERE query_id = ? AND id = gamma_id)";
    private static final String DELETE_ATTR = "DELETE FROM osee_attribute WHERE EXISTS (select 1 from osee_join_id WHERE query_id = ? AND id = gamma_id)";
    private static final String SELECT_ATTR_GAMMAS = "SELECT gamma_id FROM osee_attribute, osee_join_id where attr_id = id and query_id = ?";
    private final Collection<Attribute<?>> attributesToPurge;
    private boolean success;

    public PurgeAttributes(Collection<Attribute<?>> attributesToPurge) {
        super(ConnectionHandler.getJdbcClient(), "Purge Attributes", "org.eclipse.osee.framework.skynet.core");
        this.attributesToPurge = attributesToPurge;
    }

    @Override
    protected void doTxWork(IProgressMonitor monitor, JdbcConnection connection) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (IdJoinQuery idJoin = this.populateIdJoin(connection);){
            this.getJdbcClient().runPreparedUpdate(connection, DELETE_TXS, new Object[]{idJoin.getQueryId()});
            this.getJdbcClient().runPreparedUpdate(connection, DELETE_ATTR, new Object[]{idJoin.getQueryId()});
            this.attributesToPurge.forEach(Attribute::purge);
            this.success = true;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private IdJoinQuery populateIdJoin(JdbcConnection connection) {
        IdJoinQuery idJoin = JoinUtility.createIdJoinQuery(this.getJdbcClient(), connection);
        Throwable throwable = null;
        Object var4_5 = null;
        try (IdJoinQuery attributeJoin = JoinUtility.createIdJoinQuery(this.getJdbcClient(), connection);){
            attributeJoin.addAndStore(this.attributesToPurge);
            this.getJdbcClient().runQuery(connection, stmt -> idJoin.add(stmt.getLong("gamma_id")), 10000, SELECT_ATTR_GAMMAS, new Object[]{attributeJoin.getQueryId()});
            idJoin.store();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return idJoin;
    }

    @Override
    protected void handleTxFinally(IProgressMonitor monitor) {
        super.handleTxFinally(monitor);
        if (this.success) {
            HashSet<EventBasicGuidArtifact> artifactChanges = new HashSet<EventBasicGuidArtifact>();
            for (Attribute<?> attribute : this.attributesToPurge) {
                artifactChanges.add(new EventBasicGuidArtifact(EventModType.Purged, attribute.getArtifact()));
            }
            ArtifactEvent artifactEvent = new ArtifactEvent((BranchId)this.attributesToPurge.iterator().next().getArtifact().getBranch());
            for (EventBasicGuidArtifact guidArt : artifactChanges) {
                artifactEvent.addArtifact(guidArt);
            }
            OseeEventManager.kickPersistEvent((Object)this, artifactEvent);
        }
    }
}

