/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.function.Predicate;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.model.Branch;
import org.eclipse.osee.framework.core.model.cache.BranchFilter;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactFactory;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.ChangeArtifactType;
import org.eclipse.osee.framework.skynet.core.artifact.factory.ArtifactFactoryManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.internal.OseeTypesExportOperation;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.orcs.rest.client.OseeClient;
import org.eclipse.osee.orcs.rest.model.TypesEndpoint;

public class ArtifactTypeManager {
    private static final ArtifactFactoryManager factoryManager = new ArtifactFactoryManager();
    private static final String COUNT_ARTIFACT_OCCURRENCE = "select count(1) from (select DISTINCT(art_id) FROM osee_artifact where art_type_id = ?) t1";

    public static Artifact addArtifact(ArtifactToken artifactToken) {
        Conditions.assertTrue((boolean)artifactToken.getBranch().isValid(), (String)"Branch must be specified.", (Object[])new Object[0]);
        return ArtifactTypeManager.addArtifact(artifactToken, artifactToken.getBranch());
    }

    public static Artifact addArtifact(ArtifactTypeToken artifactType, BranchToken branch) {
        return ArtifactTypeManager.addArtifact(artifactType, branch, null, null, null);
    }

    public static Artifact addArtifact(ArtifactTypeToken artifactType, BranchToken branch, String name) {
        return ArtifactTypeManager.addArtifact(artifactType, branch, name, null, null);
    }

    public static Artifact addArtifact(ArtifactTypeToken artifactType, BranchToken branch, String name, Long artifactId) {
        return ArtifactTypeManager.addArtifact(artifactType, branch, name, null, artifactId);
    }

    public static Artifact addArtifact(ArtifactTypeToken artifactType, BranchToken branch, String name, ArtifactId artifact) {
        return ArtifactTypeManager.addArtifact(artifactType, branch, name, null, artifact.getId());
    }

    public static Artifact addArtifact(ArtifactTypeToken artifactType, BranchToken branch, String name, String guid) {
        return ArtifactTypeManager.getFactory(artifactType).makeNewArtifact(branch, artifactType, name, guid);
    }

    public static Artifact addArtifact(ArtifactTypeToken artifactType, BranchToken branch, String name, String guid, Long uuid) {
        return ArtifactTypeManager.getFactory(artifactType).makeNewArtifact(branch, artifactType, name, guid, uuid);
    }

    public static Artifact addArtifact(ArtifactToken artifactToken, BranchToken branch) {
        return ArtifactTypeManager.addArtifact(artifactToken.getArtifactType(), branch, artifactToken.getName(), artifactToken.getGuid(), artifactToken.getId());
    }

    public static void purgeArtifactType(ArtifactTypeId artifactType) {
        int artifactCount = (Integer)ConnectionHandler.getJdbcClient().fetch((Object)0, COUNT_ARTIFACT_OCCURRENCE, new Object[]{artifactType});
        if (artifactCount != 0) {
            throw new OseeArgumentException("Can not delete artifact type [%s] because there are %d existing artifacts of this type.", new Object[]{artifactType, artifactCount});
        }
    }

    public static void purgeArtifactTypesWithCheck(Collection<? extends ArtifactTypeId> purgeArtifactTypes, ArtifactTypeToken newArtifactType) {
        for (ArtifactTypeId artifactTypeId : purgeArtifactTypes) {
            LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
            for (BranchId branchId : BranchManager.getBranches((Predicate<Branch>)new BranchFilter(new BranchType[0]))) {
                artifacts.addAll(ArtifactQuery.getArtifactListFromType(CoreArtifactTypes.SoftwareRequirementMsWord, branchId, DeletionFlag.INCLUDE_DELETED));
            }
            if (artifacts.size() > 0) {
                HashMap<Integer, Artifact> hashMap = new HashMap<Integer, Artifact>();
                for (Artifact artifact : artifacts) {
                    hashMap.put(artifact.getArtId(), artifact);
                }
                if (newArtifactType == null) {
                    HashSet<BranchToken> branches = new HashSet<BranchToken>();
                    for (Artifact artifact : artifacts) {
                        branches.add(artifact.getBranch());
                    }
                    throw new OseeStateException("Found %d artifact references of type [%s] on branches [%s]", new Object[]{artifacts.size(), artifactTypeId, branches});
                }
                ChangeArtifactType.changeArtifactType(hashMap.values(), newArtifactType, true);
            }
            ArtifactTypeManager.purgeArtifactType(artifactTypeId);
        }
    }

    public static ArtifactFactory getFactory(ArtifactTypeToken artifactType) {
        if (artifactType == null) {
            throw new OseeArgumentException("Artifact Type cannot be null", new Object[0]);
        }
        return factoryManager.getFactory(artifactType);
    }

    public static IOperation newExportTypesOp(OutputStream outputStream) {
        OseeClient oseeClient = ServiceUtil.getOseeClient();
        TypesEndpoint typesEndpoint = oseeClient.getTypesEndpoint();
        return new OseeTypesExportOperation(typesEndpoint, outputStream);
    }

    public static boolean isUserCreationAllowed(ArtifactTypeToken artifactType) {
        boolean userCreationoAllowed = false;
        ArtifactFactory factory = factoryManager.getFactory(artifactType);
        if (factory != null && factory.isUserCreationEnabled(artifactType)) {
            userCreationoAllowed = true;
        } else if (factory == null) {
            userCreationoAllowed = true;
        }
        return userCreationoAllowed;
    }
}

