/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.internal.OseeApiService;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;

public class ArtifactPersistenceManager {
    public static void deleteArtifact(SkynetTransaction transaction, boolean overrideDeleteCheck, Artifact ... artifacts) {
        ArtifactPersistenceManager.deleteArtifactCollection(transaction, overrideDeleteCheck, Arrays.asList(artifacts));
    }

    public static void deleteArtifactCollection(SkynetTransaction transaction, boolean overrideDeleteCheck, Collection<Artifact> artifacts) {
        if (artifacts.isEmpty()) {
            return;
        }
        ArtifactPersistenceManager.bulkLoadRelatives(artifacts);
        if (!overrideDeleteCheck) {
            ArtifactPersistenceManager.performDeleteChecks(artifacts);
        }
        boolean reorderRelations = true;
        for (Artifact artifact : artifacts) {
            ArtifactPersistenceManager.deleteTrace(artifact, transaction, reorderRelations);
        }
    }

    private static void performDeleteChecks(Collection<Artifact> artifacts) {
        XResultData results = OseeApiService.get().getAccessControlService().isDeleteable(artifacts, new XResultData());
        if (results.isErrors()) {
            throw new OseeStateException(results.toString(), new Object[0]);
        }
    }

    public static void performDeleteRelationChecks(Artifact artifact, RelationTypeToken relationType) {
        XResultData results = OseeApiService.get().getAccessControlService().isDeleteableRelation((ArtifactToken)artifact, relationType, new XResultData());
        if (results.isErrors()) {
            throw new OseeStateException(results.toString(), new Object[0]);
        }
    }

    private static void bulkLoadRelatives(Collection<Artifact> artifacts) {
        HashSet<ArtifactToken> relatives = new HashSet<ArtifactToken>();
        for (Artifact artifact : artifacts) {
            for (RelationLink link : artifact.getRelationsAll(DeletionFlag.EXCLUDE_DELETED)) {
                relatives.add(link.getArtifactIdA());
                relatives.add(link.getArtifactIdB());
            }
        }
        BranchToken branch = artifacts.iterator().next().getBranch();
        ArtifactQuery.getArtifactListFrom(relatives, (BranchId)branch);
    }

    private static void deleteTrace(Artifact artifact, SkynetTransaction transaction, boolean reorderRelations) {
        if (!artifact.isDeleted()) {
            for (Artifact childArtifact : artifact.getChildren()) {
                ArtifactPersistenceManager.deleteTrace(childArtifact, transaction, false);
            }
            try {
                artifact.internalSetDeleted();
                RelationManager.deleteRelationsAll(artifact, reorderRelations, transaction);
                if (transaction != null) {
                    artifact.persist(transaction);
                }
            }
            catch (OseeCoreException ex) {
                artifact.resetToPreviousModType();
                throw ex;
            }
        }
    }
}

